/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.transactions.PaymentFilterDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterServiceLocal;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.model.PaymentFilterVO;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;

public class PaymentFilterServiceImpl
implements PaymentFilterServiceLocal {
    private PaymentFilterDAO paymentFilterDao;
    private AccountHelper accountHelper;

    @Override
    public Collection<PaymentFilter> load(Collection<Long> ids, Relationship ... fetch) {
        return this.paymentFilterDao.load(ids, fetch);
    }

    @Override
    public PaymentFilter load(Long id, Relationship ... fetch) {
        return (PaymentFilter)this.paymentFilterDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.paymentFilterDao.delete(ids);
    }

    @Override
    public PaymentFilter save(PaymentFilter paymentFilter) {
        this.validate(paymentFilter);
        if (paymentFilter.isTransient()) {
            return this.paymentFilterDao.insert(paymentFilter);
        }
        return this.paymentFilterDao.update(paymentFilter);
    }

    @Override
    public List<PaymentFilter> search(PaymentFilterQuery query) {
        return this.paymentFilterDao.search(query);
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setPaymentFilterDao(PaymentFilterDAO paymentFilterDao) {
        this.paymentFilterDao = paymentFilterDao;
    }

    @Override
    public List<PaymentFilterVO> getPaymentFilterVOs(List<PaymentFilter> paymentFilters) {
        return this.accountHelper.toPaymentFilterVOs(paymentFilters);
    }

    @Override
    public void validate(PaymentFilter paymentFilter) {
        this.getValidator().validate(paymentFilter);
    }

    private Validator getValidator() {
        Validator validator = new Validator("paymentFilter");
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(1000);
        return validator;
    }
}

