/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilterQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterService;
import nl.strohalm.cyclos.services.transfertypes.PaymentFilterServiceLocal;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.webservices.model.PaymentFilterVO;

public class PaymentFilterServiceSecurity
extends BaseServiceSecurity
implements PaymentFilterService {
    private PaymentFilterServiceLocal paymentFilterService;
    private AccountTypeServiceLocal accountTypeService;

    @Override
    public List<PaymentFilterVO> getPaymentFilterVOs(List<PaymentFilter> paymentFilters) {
        if (paymentFilters == null) {
            return Collections.emptyList();
        }
        for (PaymentFilter paymentFilter : paymentFilters) {
            this.checkView(paymentFilter);
        }
        return this.paymentFilterService.getPaymentFilterVOs(paymentFilters);
    }

    @Override
    public Collection<PaymentFilter> load(Collection<Long> ids, Relationship ... fetch) {
        Collection<PaymentFilter> paymentFilters = this.paymentFilterService.load(ids, new Relationship[0]);
        this.checkView(paymentFilters.toArray(new PaymentFilter[paymentFilters.size()]));
        return paymentFilters;
    }

    @Override
    public PaymentFilter load(Long id, Relationship ... fetch) {
        PaymentFilter paymentFilter = this.paymentFilterService.load(id, fetch);
        this.checkView(paymentFilter);
        return paymentFilter;
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.paymentFilterService.remove(ids);
    }

    @Override
    public PaymentFilter save(PaymentFilter paymentFilter) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.paymentFilterService.save(paymentFilter);
    }

    @Override
    public List<PaymentFilter> search(PaymentFilterQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.paymentFilterService.search(query);
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    public void setPaymentFilterServiceLocal(PaymentFilterServiceLocal paymentFilterService) {
        this.paymentFilterService = paymentFilterService;
    }

    @Override
    public void validate(PaymentFilter paymentFilter) {
        this.paymentFilterService.validate(paymentFilter);
    }

    private boolean applyQueryRestrictions(PaymentFilterQuery query) {
        Collection<AccountType> accountTypes = PermissionHelper.checkSelection(this.accountTypeService.getVisibleAccountTypes(), query.getAccountTypes());
        query.setAccountTypes(accountTypes);
        return accountTypes != null;
    }

    private void checkView(PaymentFilter ... paymentFilters) {
        Collection<AccountType> visibleAccountTypes = this.accountTypeService.getVisibleAccountTypes();
        for (PaymentFilter pf : paymentFilters) {
            if (visibleAccountTypes.contains(pf.getAccountType())) continue;
            throw new PermissionDeniedException();
        }
    }
}

