/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.math.BigDecimal;
import java.math.MathContext;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;

public class TransactionFeePreviewForRatesDTO
extends TransactionFeePreviewDTO {
    private static final long serialVersionUID = 8886564544894519454L;
    private BigDecimal aRate;
    private BigDecimal dRate;

    public BigDecimal getARate() {
        return this.aRate;
    }

    public BigDecimal getDRate() {
        return this.dRate;
    }

    public BigDecimal getRatesAsFeePercentage() {
        BigDecimal resultAmount = this.getFinalAmount();
        BigDecimal amountToConvert = this.getAmount();
        if (amountToConvert.compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        int scale = 10;
        MathContext mc = new MathContext(10);
        BigDecimal totalConversionFeeAsFraction = BigDecimal.ONE.subtract(resultAmount.divide(amountToConvert, mc));
        BigDecimal totalConversionFeeAsPercentage = totalConversionFeeAsFraction.multiply(new BigDecimal(100.0));
        return totalConversionFeeAsPercentage;
    }

    public void setARate(BigDecimal rate) {
        this.aRate = rate;
    }

    public void setDRate(BigDecimal rate) {
        this.dRate = rate;
    }
}

