/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.accounts.fee.transaction.TransactionFeeDAO;
import nl.strohalm.cyclos.dao.members.brokerings.BrokeringCommissionStatusDAO;
import nl.strohalm.cyclos.dao.members.brokerings.DefaultBrokerCommissionDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatus;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatusQuery;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommission;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommissionQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.accounts.AccountDTO;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.ARatedFeeDTO;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RatesDTO;
import nl.strohalm.cyclos.services.accounts.rates.RatesPreviewDTO;
import nl.strohalm.cyclos.services.accounts.rates.RatesResultDTO;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.BuildTransferWithFeesDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewForRatesDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.MessageProcessingHelper;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.conversion.UnitsConverter;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.model.TransactionFeeVO;
import nl.strohalm.cyclos.webservices.utils.PaymentHelper;

public class TransactionFeeServiceImpl
implements TransactionFeeServiceLocal {
    private MessageResolver messageResolver;
    private AccountServiceLocal accountService;
    private RateServiceLocal rateService;
    private BrokeringServiceLocal brokeringService;
    private CommissionServiceLocal commissionService;
    private FetchServiceLocal fetchService;
    private SettingsServiceLocal settingsService;
    private TransferTypeServiceLocal transferTypeService;
    private BrokeringCommissionStatusDAO brokeringCommissionStatusDao;
    private DefaultBrokerCommissionDAO defaultBrokerCommissionDao;
    private TransactionFeeDAO transactionFeeDao;
    private PaymentHelper paymentHelper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Transfer buildTransfer(BuildTransferWithFeesDTO params) {
        Account toAccount;
        Account fromAccount;
        Calendar date = params.getDate();
        Account from = params.getFrom();
        Account to = params.getTo();
        BigDecimal transferAmount = params.getTransferAmount();
        TransactionFee fee = params.getFee();
        boolean simulation = params.isSimulation();
        Calendar rawARateParam = params.getEmissionDate();
        Calendar rawDRateParam = params.getExpirationDate();
        if (fee.isTransient()) {
            throw new UnexpectedEntityException();
        }
        if (!this.doTests(fee = this.fetchService.fetch(fee, TransactionFee.Relationships.ORIGINAL_TRANSFER_TYPE, RelationshipHelper.nested(TransactionFee.Relationships.GENERATED_TRANSFER_TYPE, TransferType.Relationships.FROM, TransferType.Relationships.TO, AccountType.Relationships.CURRENCY), TransactionFee.Relationships.FROM_GROUPS, TransactionFee.Relationships.TO_GROUPS, TransactionFee.Relationships.FROM_FIXED_MEMBER, SimpleTransactionFee.Relationships.TO_FIXED_MEMBER), transferAmount, from, to)) {
            return null;
        }
        BrokerCommissionContract commissionContract = null;
        TransactionFee.ChargeType feeChargeType = fee.getChargeType();
        BigDecimal feeValue = fee.getValue();
        TransferType generated = fee.getGeneratedTransferType();
        AccountOwner fromOwner = this.getOwner(fee.getPayer(), fee.getFromFixedMember(), from, to);
        AccountOwner toOwner = null;
        if (fee.getNature() == TransactionFee.Nature.SIMPLE) {
            SimpleTransactionFee simpleFee = (SimpleTransactionFee)fee;
            toOwner = this.getOwner(simpleFee.getReceiver(), simpleFee.getToFixedMember(), from, to);
        } else {
            BrokerCommission brokerCommission = (BrokerCommission)fee;
            Account relatedAccount = null;
            switch (brokerCommission.getWhichBroker()) {
                case SOURCE: {
                    relatedAccount = from;
                    break;
                }
                case DESTINATION: {
                    relatedAccount = to;
                }
            }
            boolean crossPayment = false;
            if (fee.getPayer() == TransactionFee.Subject.SOURCE && brokerCommission.getWhichBroker() == BrokerCommission.WhichBroker.DESTINATION || fee.getPayer() == TransactionFee.Subject.DESTINATION && brokerCommission.getWhichBroker() == BrokerCommission.WhichBroker.SOURCE) {
                crossPayment = true;
            }
            if (relatedAccount instanceof MemberAccount) {
                Amount feeAmount;
                Member member = ((MemberAccount)relatedAccount).getMember();
                toOwner = member.getBroker();
                Brokering brokering = this.brokeringService.getActiveBrokering(member);
                if (brokering == null) {
                    return null;
                }
                Member broker = brokering.getBroker();
                if (!brokerCommission.isAllBrokerGroups()) {
                    BrokerGroup brokerGroup = (BrokerGroup)this.fetchService.fetch(brokering.getBroker().getGroup(), new Relationship[0]);
                    if (!brokerCommission.getBrokerGroups().contains(brokerGroup)) {
                        return null;
                    }
                }
                BrokeringCommissionStatus brokeringCommissionStatus = this.commissionService.getBrokeringCommissionStatus(brokering, brokerCommission);
                boolean testBrokeringCommissionStatus = false;
                BrokerCommission.When when = null;
                int maxCount = 0;
                boolean fromMember = generated.isFromMember();
                if (fromMember) {
                    if (crossPayment) {
                        feeAmount = brokerCommission.getAmount();
                    } else {
                        commissionContract = this.commissionService.getActiveBrokerCommissionContract(brokering, brokerCommission);
                        if (commissionContract != null) {
                            feeAmount = commissionContract.getAmount();
                        } else {
                            if (brokeringCommissionStatus == null) return null;
                            if (brokeringCommissionStatus.getPeriod().getEnd() != null) {
                                return null;
                            }
                            testBrokeringCommissionStatus = true;
                            when = brokeringCommissionStatus.getWhen();
                            if (when != BrokerCommission.When.ALWAYS) {
                                maxCount = brokeringCommissionStatus.getMaxCount();
                            }
                            feeAmount = brokeringCommissionStatus.getAmount();
                        }
                    }
                } else {
                    testBrokeringCommissionStatus = true;
                    when = brokerCommission.getWhen();
                    if (when != BrokerCommission.When.ALWAYS) {
                        maxCount = brokerCommission.getCount();
                    }
                    feeAmount = brokeringCommissionStatus.getAmount();
                }
                feeChargeType = TransactionFee.ChargeType.from(feeAmount.getType());
                feeValue = feeAmount.getValue();
                if (testBrokeringCommissionStatus) {
                    DefaultBrokerCommission defaultBrokerCommission;
                    if (fromMember && (defaultBrokerCommission = this.commissionService.getDefaultBrokerCommission(broker, brokerCommission)) != null && defaultBrokerCommission.isSuspended()) {
                        return null;
                    }
                    if (brokeringCommissionStatus.getPeriod().getEnd() != null) {
                        return null;
                    }
                    if (when == BrokerCommission.When.COUNT) {
                        int count = brokeringCommissionStatus.getTotal().getCount();
                        if (count >= maxCount) {
                            return null;
                        }
                        if (count == maxCount - 1 && !simulation) {
                            brokeringCommissionStatus = this.commissionService.closeBrokeringCommissionStatus(brokeringCommissionStatus);
                        }
                    }
                    if (when == BrokerCommission.When.DAYS) {
                        Calendar begin = brokeringCommissionStatus.getPeriod().getBegin();
                        Calendar maxDay = new TimePeriod(maxCount, TimePeriod.Field.DAYS).add(begin);
                        if (Calendar.getInstance().after(maxDay)) {
                            return null;
                        }
                    }
                }
                if (!simulation && !crossPayment && commissionContract == null) {
                    brokeringCommissionStatus.setTotal(brokeringCommissionStatus.getTotal().add(transferAmount));
                    this.commissionService.updateBrokeringCommissionStatus(brokeringCommissionStatus);
                }
            }
        }
        if (fromOwner == null || toOwner == null) {
            return null;
        }
        if (fromOwner instanceof Member && fromOwner.equals(toOwner)) {
            return null;
        }
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        try {
            fromAccount = this.accountService.getAccount(new AccountDTO(fromOwner, generated.getFrom()), new Relationship[0]);
            toAccount = this.accountService.getAccount(new AccountDTO(toOwner, generated.getTo()), new Relationship[0]);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
        if (fromAccount.equals(toAccount)) {
            return null;
        }
        BigDecimal amount = BigDecimal.ZERO;
        Currency currency = fromAccount.getType().getCurrency();
        switch (feeChargeType) {
            case FIXED: {
                amount = feeValue;
                break;
            }
            case PERCENTAGE: {
                amount = Amount.percentage(feeValue).apply(transferAmount);
                break;
            }
            case A_RATE: 
            case MIXED_A_D_RATES: {
                if (rawARateParam == null) break;
                feeValue = this.rateService.getARatedFeePercentage(fee, rawARateParam, rawDRateParam, date);
                fee.setAmountForRates(Amount.percentage(feeValue));
                amount = Amount.percentage(feeValue).apply(transferAmount);
                break;
            }
            case D_RATE: {
                if (rawDRateParam == null) break;
                RatesDTO setOfUnits = RatesDTO.createSetOfUnitsForMerge(transferAmount, rawDRateParam, currency);
                setOfUnits.setDate(params.getDate());
                BigDecimal result = this.rateService.getDRateConversionResult(setOfUnits);
                amount = transferAmount.subtract(result);
                MathContext mc = new MathContext(6);
                feeValue = amount.multiply(new BigDecimal(100)).divide(transferAmount, mc);
                fee.setAmountForRates(Amount.percentage(feeValue));
            }
        }
        amount = localSettings.round(amount);
        if (!params.isShowZeroFees() && amount.compareTo(BigDecimal.ZERO) <= 0) {
            return null;
        }
        String description = fee.getGeneratedTransferType().getDescription();
        UnitsConverter unitsConverter = localSettings.getUnitsConverter(generated.getFrom().getCurrency().getPattern());
        NumberConverter<BigDecimal> numberConverter = localSettings.getNumberConverter();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("amount", unitsConverter.toString(amount));
        values.put("transfer", unitsConverter.toString(transferAmount));
        values.put("original_amount", values.get("transfer"));
        switch (feeChargeType) {
            case FIXED: {
                values.put("fee", unitsConverter.toString(feeValue));
                break;
            }
            case PERCENTAGE: {
                values.put("fee", numberConverter.toString(feeValue) + "%");
                break;
            }
            case A_RATE: {
                values.put("fee", numberConverter.toString(feeValue) + "%");
                BigDecimal aRate = this.getRoundedARate(date, rawARateParam, localSettings);
                values.put("a_rate", aRate);
                break;
            }
            case MIXED_A_D_RATES: {
                values.put("fee", numberConverter.toString(feeValue) + "%");
                BigDecimal aRate1 = this.getRoundedARate(date, rawARateParam, localSettings);
                values.put("a_rate", aRate1);
            }
            case D_RATE: {
                RatesDTO ratesDTO = new RatesDTO();
                ratesDTO.setExpirationDate(rawDRateParam);
                ratesDTO.setDate(date);
                ratesDTO.setCurrency(currency);
                BigDecimal dRate = this.rateService.dateToRate(ratesDTO).getdRate();
                dRate = localSettings.round(dRate);
                values.put("d_rate", dRate);
            }
        }
        values.put("fee_amount", values.get("fee"));
        values.put("member", fromAccount.getOwnerName());
        Transfer feeTransfer = new Transfer();
        feeTransfer.setFrom(fromAccount);
        feeTransfer.setTo(toAccount);
        feeTransfer.setAmount(amount);
        feeTransfer.setDescription(MessageProcessingHelper.processVariables(description, values));
        feeTransfer.setType(generated);
        feeTransfer.setTransactionFee(fee);
        if (commissionContract == null) return feeTransfer;
        feeTransfer.setBrokerCommissionContract(commissionContract);
        return feeTransfer;
    }

    @Override
    public Collection<TransactionFee.ChargeType> getPossibleChargeType(TransferType originalTransferType, TransactionFee.Nature feeNature) {
        Collection<TransactionFee.ChargeType> chargeTypes = Arrays.asList(TransactionFee.ChargeType.FIXED, TransactionFee.ChargeType.PERCENTAGE);
        TransferType transferType = this.fetchService.fetch(originalTransferType, TransferType.Relationships.FROM, TransferType.Relationships.TO);
        if (feeNature == TransactionFee.Nature.SIMPLE && transferType.isFromMember() && transferType.isToSystem() && !transferType.getTo().isLimited()) {
            Currency currency = transferType.getCurrency();
            boolean allowARate = currency.isEnableARate();
            boolean allowDRate = currency.isEnableDRate();
            chargeTypes = EnumSet.allOf(TransactionFee.ChargeType.class);
            if (!allowARate) {
                chargeTypes.remove(TransactionFee.ChargeType.A_RATE);
                chargeTypes.remove(TransactionFee.ChargeType.MIXED_A_D_RATES);
            }
            if (!allowDRate) {
                chargeTypes.remove(TransactionFee.ChargeType.D_RATE);
            }
        }
        return chargeTypes;
    }

    @Override
    public Collection<TransactionFee.Subject> getPossibleSubjects(TransferType originalTransferType, TransactionFee.Nature nature) {
        originalTransferType = this.fetchService.fetch(originalTransferType, TransferType.Relationships.FROM, TransferType.Relationships.TO);
        switch (nature) {
            case SIMPLE: {
                if (originalTransferType.isFromSystem()) {
                    if (originalTransferType.isToSystem()) {
                        return Collections.singleton(TransactionFee.Subject.SYSTEM);
                    }
                    return EnumSet.of(TransactionFee.Subject.SYSTEM, TransactionFee.Subject.DESTINATION, TransactionFee.Subject.DESTINATION_BROKER, TransactionFee.Subject.FIXED_MEMBER);
                }
                if (originalTransferType.isToSystem()) {
                    return EnumSet.of(TransactionFee.Subject.SYSTEM, TransactionFee.Subject.SOURCE, TransactionFee.Subject.SOURCE_BROKER, TransactionFee.Subject.FIXED_MEMBER);
                }
                return EnumSet.allOf(TransactionFee.Subject.class);
            }
            case BROKER: {
                return EnumSet.of(TransactionFee.Subject.SYSTEM, TransactionFee.Subject.SOURCE, TransactionFee.Subject.DESTINATION);
            }
        }
        throw new IllegalArgumentException("Unexpected transaction fee nature: " + nature);
    }

    @Override
    public List<TransactionFeeVO> getTransactionFeeVOs(TransactionFeePreviewDTO preview) {
        Map<TransactionFee, BigDecimal> fees = preview.getFees();
        return this.paymentHelper.toTransactionFeeVOs(fees);
    }

    @Override
    public TransactionFee load(Long id, Relationship ... fetch) {
        return (TransactionFee)this.transactionFeeDao.load(id, fetch);
    }

    @Override
    public TransactionFeePreviewDTO preview(AccountOwner from, AccountOwner to, TransferType transferType, BigDecimal amount) {
        RatesResultDTO rates = new RatesResultDTO();
        if ((transferType = this.fetchService.fetch(transferType, new Relationship[0])).isHavingRatedFees()) {
            Account fromAccount = this.accountService.getAccount(new AccountDTO(from, transferType.getFrom()), new Relationship[0]);
            rates = this.rateService.getRatesForTransferFrom(fromAccount, amount, null);
        }
        return this.preview(from, to, transferType, amount, rates);
    }

    @Override
    public TransactionFeePreviewDTO preview(AccountOwner from, AccountOwner to, TransferType transferType, BigDecimal amount, RatesResultDTO rates) {
        Calendar processDate;
        Calendar rawARate = rates.getEmissionDate();
        Calendar rawDRate = rates.getExpirationDate();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        if (from == null) {
            from = LoggedUser.accountOwner();
        }
        boolean showZeroFees = rates instanceof RatesPreviewDTO && ((RatesPreviewDTO)rates).isGraph();
        Account fromAccount = this.accountService.getAccount(new AccountDTO(from, transferType.getFrom()), new Relationship[0]);
        Account toAccount = this.accountService.getAccount(new AccountDTO(to, transferType.getTo()), new Relationship[0]);
        BigDecimal finalAmount = amount;
        LinkedHashMap<TransactionFee, BigDecimal> map = new LinkedHashMap<TransactionFee, BigDecimal>();
        transferType = this.fetchService.fetch(transferType, TransferType.Relationships.TRANSACTION_FEES);
        Collection<? extends TransactionFee> fees = transferType.getTransactionFees();
        Calendar calendar = processDate = rates != null && rates.getDate() != null ? rates.getDate() : Calendar.getInstance();
        if (fees != null && !fees.isEmpty()) {
            for (TransactionFee transactionFee : fees) {
                if (!this.shouldPreviewFee(from, to, amount, transactionFee)) continue;
                BuildTransferWithFeesDTO buildParams = new BuildTransferWithFeesDTO(processDate, fromAccount, toAccount, amount, transactionFee, true);
                buildParams.setEmissionDate(rawARate);
                buildParams.setExpirationDate(rawDRate);
                buildParams.setShowZeroFees(showZeroFees);
                Transfer generatedTransfer = this.buildTransfer(buildParams);
                if (generatedTransfer == null) continue;
                BigDecimal feeAmount = generatedTransfer.getAmount();
                map.put(transactionFee, feeAmount);
                if (!transactionFee.isDeductAmount()) continue;
                finalAmount = finalAmount.subtract(feeAmount);
            }
        }
        TransactionFeePreviewForRatesDTO result = new TransactionFeePreviewForRatesDTO();
        result.setFees(map);
        result.setFinalAmount(localSettings.round(finalAmount));
        result.setAmount(localSettings.round(amount));
        result.setARate(rates.getaRate());
        result.setDRate(rates.getdRate());
        return result;
    }

    @Override
    public TransactionFeePreviewDTO preview(Invoice invoice) {
        TransferType transferType = invoice.getTransferType();
        if (transferType == null) {
            return null;
        }
        return this.preview(invoice.getTo(), invoice.getFrom(), transferType, invoice.getAmount());
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            TransactionFee transactionFee = this.load(id, new Relationship[0]);
            if (!(transactionFee instanceof BrokerCommission)) continue;
            BrokerCommission brokerCommission = (BrokerCommission)transactionFee;
            BrokeringCommissionStatusQuery query = new BrokeringCommissionStatusQuery();
            query.setBrokerCommission(brokerCommission);
            query.setAlreadyCharged(true);
            query.setPageForCount();
            List<BrokeringCommissionStatus> brokeringCommissionStatusList = this.brokeringCommissionStatusDao.search(query);
            if (PageHelper.getTotalCount(brokeringCommissionStatusList) > 0) {
                throw new DaoException();
            }
            query = new BrokeringCommissionStatusQuery();
            query.setBrokerCommission(brokerCommission);
            brokeringCommissionStatusList = this.brokeringCommissionStatusDao.search(query);
            for (BrokeringCommissionStatus brokeringCommissionStatus : brokeringCommissionStatusList) {
                this.brokeringCommissionStatusDao.delete(brokeringCommissionStatus.getId());
            }
            DefaultBrokerCommissionQuery defaultBrokerCommissionQuery = new DefaultBrokerCommissionQuery();
            defaultBrokerCommissionQuery.setBrokerCommission(brokerCommission);
            defaultBrokerCommissionQuery.setSetByBroker(true);
            defaultBrokerCommissionQuery.setPageForCount();
            List<DefaultBrokerCommission> defaultBrokerCommissions = this.defaultBrokerCommissionDao.search(defaultBrokerCommissionQuery);
            if (PageHelper.getTotalCount(defaultBrokerCommissions) > 0) {
                throw new DaoException();
            }
            defaultBrokerCommissionQuery = new DefaultBrokerCommissionQuery();
            defaultBrokerCommissionQuery.setBrokerCommission(brokerCommission);
            defaultBrokerCommissions = this.defaultBrokerCommissionDao.search(defaultBrokerCommissionQuery);
            for (DefaultBrokerCommission defaultBrokerCommission : defaultBrokerCommissions) {
                this.defaultBrokerCommissionDao.delete(defaultBrokerCommission.getId());
            }
        }
        return this.transactionFeeDao.delete(ids);
    }

    @Override
    public BrokerCommission save(BrokerCommission brokerCommission) {
        this.preSave(brokerCommission);
        if (brokerCommission.isAllBrokerGroups()) {
            brokerCommission.setBrokerGroups(null);
        }
        this.validate(brokerCommission);
        if (brokerCommission.isTransient()) {
            if ((brokerCommission = this.transactionFeeDao.insert(brokerCommission)).isFromMember()) {
                this.commissionService.createDefaultBrokerCommissions(brokerCommission);
            } else {
                this.commissionService.createBrokeringCommissionStatus(brokerCommission);
            }
        } else {
            BrokerCommission savedBrokerCommission = (BrokerCommission)this.transactionFeeDao.load(brokerCommission.getId(), BrokerCommission.Relationships.BROKER_GROUPS);
            this.fetchService.removeFromCache(savedBrokerCommission);
            brokerCommission = this.transactionFeeDao.update(brokerCommission);
            if (brokerCommission.isFromMember()) {
                this.commissionService.updateDefaultBrokerCommissions(brokerCommission, savedBrokerCommission);
            } else {
                this.commissionService.updateBrokeringCommissionStatus(brokerCommission, savedBrokerCommission);
            }
        }
        return brokerCommission;
    }

    @Override
    public SimpleTransactionFee save(SimpleTransactionFee fee, SimpleTransactionFee.ARateRelation aRateRelation) {
        this.preSave(fee);
        if (Arrays.asList(TransactionFee.ChargeType.A_RATE, TransactionFee.ChargeType.D_RATE, TransactionFee.ChargeType.MIXED_A_D_RATES).contains(fee.getChargeType())) {
            fee.setDeductAmount(true);
        }
        this.validate(fee, aRateRelation);
        if (fee.getReceiver() != TransactionFee.Subject.FIXED_MEMBER) {
            fee.setToFixedMember(null);
        }
        fee = fee.isTransient() ? this.transactionFeeDao.insert(fee) : this.transactionFeeDao.update(fee);
        return fee;
    }

    public List<TransactionFee> search(TransactionFeeQuery query) {
        return this.transactionFeeDao.search(query);
    }

    @Override
    public List<TransferType> searchGeneratedTransferTypes(TransactionFee fee, boolean allowAnyAccount, boolean onlyFromSystem) {
        TransferTypeQuery generatedQuery = this.buildGeneratedTypeQuery(fee, allowAnyAccount);
        if (onlyFromSystem) {
            generatedQuery.setFromNature(AccountType.Nature.SYSTEM);
        }
        return this.transferTypeService.search(generatedQuery);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setBrokeringCommissionStatusDao(BrokeringCommissionStatusDAO brokeringCommissionStatusDao) {
        this.brokeringCommissionStatusDao = brokeringCommissionStatusDao;
    }

    public void setBrokeringServiceLocal(BrokeringServiceLocal brokeringService) {
        this.brokeringService = brokeringService;
    }

    public void setCommissionServiceLocal(CommissionServiceLocal commissionService) {
        this.commissionService = commissionService;
    }

    public void setDefaultBrokerCommissionDao(DefaultBrokerCommissionDAO defaultBrokerCommissionDao) {
        this.defaultBrokerCommissionDao = defaultBrokerCommissionDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setPaymentHelper(PaymentHelper paymentHelper) {
        this.paymentHelper = paymentHelper;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionFeeDao(TransactionFeeDAO dao) {
        this.transactionFeeDao = dao;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(BrokerCommission brokerCommission) {
        this.getValidator(brokerCommission).validate(brokerCommission);
    }

    @Override
    public void validate(SimpleTransactionFee transactionFee, SimpleTransactionFee.ARateRelation aRateRelation) {
        this.getValidator(transactionFee, aRateRelation).validate(transactionFee);
    }

    protected boolean shouldPreviewFee(AccountOwner from, AccountOwner to, BigDecimal amount, TransactionFee fee) {
        if (fee.getPayer() == TransactionFee.Subject.SOURCE || from.equals(fee.getFromFixedMember())) {
            return true;
        }
        return fee.getPayer() == TransactionFee.Subject.SYSTEM && from instanceof SystemAccountOwner;
    }

    private Member brokerOf(AccountOwner owner) {
        if (owner instanceof Member) {
            return ((Member)owner).getBroker();
        }
        return null;
    }

    private TransferTypeQuery buildGeneratedTypeQuery(TransactionFee fee, boolean allowAnyAccount) {
        TransferType originalTransferType = this.fetchService.fetch(fee.getOriginalTransferType(), TransferType.Relationships.FROM, TransferType.Relationships.TO);
        AccountType fromAccountType = originalTransferType.getFrom();
        AccountType toAccountType = originalTransferType.getTo();
        TransferTypeQuery generatedQuery = new TransferTypeQuery();
        generatedQuery.setContext(TransactionContext.ANY);
        switch (fee.getPayer()) {
            case SYSTEM: {
                generatedQuery.setFromNature(AccountType.Nature.SYSTEM);
                break;
            }
            case SOURCE: {
                if (allowAnyAccount) {
                    generatedQuery.setFromNature(fromAccountType.getNature());
                    break;
                }
                generatedQuery.setFromAccountType(fromAccountType);
                break;
            }
            case DESTINATION: {
                if (allowAnyAccount) {
                    generatedQuery.setFromNature(toAccountType.getNature());
                    break;
                }
                generatedQuery.setFromAccountType(toAccountType);
                break;
            }
            case FIXED_MEMBER: {
                if (allowAnyAccount) {
                    generatedQuery.setFromNature(AccountType.Nature.MEMBER);
                    break;
                }
                generatedQuery.setFromAccountType(fromAccountType);
                break;
            }
            case SOURCE_BROKER: 
            case DESTINATION_BROKER: {
                generatedQuery.setFromNature(AccountType.Nature.MEMBER);
            }
        }
        switch (fee.getNature()) {
            case SIMPLE: {
                switch (((SimpleTransactionFee)fee).getReceiver()) {
                    case SYSTEM: {
                        generatedQuery.setToNature(AccountType.Nature.SYSTEM);
                        break;
                    }
                    case SOURCE: {
                        if (allowAnyAccount) {
                            generatedQuery.setToNature(fromAccountType.getNature());
                            break;
                        }
                        generatedQuery.setToAccountType(fromAccountType);
                        break;
                    }
                    case DESTINATION: {
                        if (allowAnyAccount) {
                            generatedQuery.setToNature(toAccountType.getNature());
                            break;
                        }
                        generatedQuery.setToAccountType(toAccountType);
                        break;
                    }
                    case FIXED_MEMBER: {
                        if (allowAnyAccount) {
                            generatedQuery.setToNature(AccountType.Nature.MEMBER);
                            break;
                        }
                        generatedQuery.setToAccountType(toAccountType);
                        break;
                    }
                    case SOURCE_BROKER: 
                    case DESTINATION_BROKER: {
                        generatedQuery.setToNature(AccountType.Nature.MEMBER);
                    }
                }
                break;
            }
            case BROKER: {
                generatedQuery.setToNature(AccountType.Nature.MEMBER);
            }
        }
        return generatedQuery;
    }

    private boolean doTests(TransactionFee fee, BigDecimal transferAmount, Account from, Account to) {
        AccountOwner originalToAccountOwner;
        if (!fee.isEnabled()) {
            return false;
        }
        BigDecimal initialAmount = fee.getInitialAmount();
        if (initialAmount != null && transferAmount.compareTo(initialAmount) < 0) {
            return false;
        }
        BigDecimal finalAmount = fee.getFinalAmount();
        if (finalAmount != null && transferAmount.compareTo(finalAmount) > 0) {
            return false;
        }
        AccountOwner originalFromAccountOwner = from.getOwner();
        if (originalFromAccountOwner instanceof Member && !fee.isFromAllGroups()) {
            Member fromMember = this.fetchService.fetch((Member)originalFromAccountOwner, Element.Relationships.GROUP);
            MemberGroup fromGroup = fromMember.getMemberGroup();
            if (!fee.getFromGroups().contains(fromGroup)) {
                return false;
            }
        }
        if ((originalToAccountOwner = to.getOwner()) instanceof Member && !fee.isToAllGroups()) {
            Member toMember = this.fetchService.fetch((Member)originalToAccountOwner, Element.Relationships.GROUP);
            MemberGroup toGroup = toMember.getMemberGroup();
            if (!fee.getToGroups().contains(toGroup)) {
                return false;
            }
        }
        return true;
    }

    private Validator getBasicValidator(TransactionFee fee) {
        Validator validator = new Validator("transactionFee");
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(1000);
        validator.property("chargeType").required();
        Validator.Property value = validator.property("value");
        if (fee.getChargeType() != null) {
            switch (fee.getChargeType()) {
                case PERCENTAGE: {
                    value.required().positiveNonZero().lessEquals(100);
                    break;
                }
                case FIXED: {
                    value.required().positiveNonZero();
                }
            }
        }
        validator.property("originalTransferType").required();
        validator.property("generatedTransferType").required();
        validator.property("payer").required();
        if (fee.getPayer() == TransactionFee.Subject.FIXED_MEMBER) {
            validator.property("fromFixedMember").key("transactionFee.fromFixedMember.name").required();
        }
        return validator;
    }

    private AccountOwner getOwner(TransactionFee.Subject subject, Member fixedMember, Account from, Account to) {
        switch (subject) {
            case SYSTEM: {
                return SystemAccountOwner.instance();
            }
            case SOURCE: {
                return from.getOwner();
            }
            case DESTINATION: {
                return to.getOwner();
            }
            case FIXED_MEMBER: {
                return fixedMember;
            }
            case SOURCE_BROKER: {
                return this.brokerOf(from.getOwner());
            }
            case DESTINATION_BROKER: {
                return this.brokerOf(to.getOwner());
            }
        }
        return null;
    }

    private BigDecimal getRoundedARate(Calendar date, Calendar rawARateParam, LocalSettings localSettings) {
        RatesDTO ratesDTO = new RatesDTO();
        ratesDTO.setEmissionDate(rawARateParam);
        ratesDTO.setDate(date);
        BigDecimal aRate = this.rateService.dateToRate(ratesDTO).getaRate();
        aRate = localSettings.round(aRate);
        return aRate;
    }

    private Validator getValidator(BrokerCommission commission) {
        Validator validator = this.getBasicValidator(commission);
        validator.property("maxFixedValue").positiveNonZero();
        validator.property("maxPercentageValue").positiveNonZero();
        validator.property("when").required();
        validator.property("count").add(new CountValidation());
        validator.property("chargeType").anyOf(TransactionFee.ChargeType.FIXED, TransactionFee.ChargeType.PERCENTAGE);
        validator.property("payer").anyOf(TransactionFee.Subject.SYSTEM, TransactionFee.Subject.SOURCE, TransactionFee.Subject.DESTINATION);
        TransactionFee.Subject payer = commission.getPayer();
        if (payer == TransactionFee.Subject.SOURCE) {
            validator.property("whichBroker").anyOf(BrokerCommission.WhichBroker.SOURCE);
        } else if (payer == TransactionFee.Subject.DESTINATION) {
            validator.property("whichBroker").anyOf(BrokerCommission.WhichBroker.DESTINATION);
        }
        if (commission.getInitialAmount() != null && commission.getFinalAmount() != null) {
            Validator.Property initialAmount = validator.property("initialAmount");
            BigDecimal finalAmount = commission.getFinalAmount();
            initialAmount.comparable(finalAmount, "<=", new ValidationError("errors.greaterThan", this.messageResolver.message("transactionFee.finalAmount", new Object[0])));
        }
        return validator;
    }

    private Validator getValidator(SimpleTransactionFee fee, SimpleTransactionFee.ARateRelation arateRelation) {
        TransferType originalTransferType = this.fetchService.fetch(fee.getOriginalTransferType(), RelationshipHelper.nested(TransferType.Relationships.FROM, AccountType.Relationships.CURRENCY));
        Validator validator = this.getBasicValidator(fee);
        validator.property("receiver").required();
        if (fee.getReceiver() == TransactionFee.Subject.FIXED_MEMBER) {
            validator.property("toFixedMember").key("transactionFee.toFixedMember.name").required();
        }
        validator.general(new PayerAndReceiverValidation());
        EnumSet<TransactionFee.ChargeType> allowedChargeTypes = EnumSet.allOf(TransactionFee.ChargeType.class);
        Currency currency = originalTransferType.getCurrency();
        if (!currency.isEnableARate()) {
            allowedChargeTypes.remove(TransactionFee.ChargeType.A_RATE);
            allowedChargeTypes.remove(TransactionFee.ChargeType.MIXED_A_D_RATES);
        }
        if (!currency.isEnableDRate()) {
            allowedChargeTypes.remove(TransactionFee.ChargeType.D_RATE);
            allowedChargeTypes.remove(TransactionFee.ChargeType.MIXED_A_D_RATES);
        }
        ARatedFeeDTO dto = new ARatedFeeDTO(fee);
        validator = this.rateService.applyARateFieldsValidation(validator, dto, arateRelation);
        validator.property("chargeType").anyOf(allowedChargeTypes);
        if (fee.getInitialAmount() != null && fee.getFinalAmount() != null) {
            Validator.Property initialAmount = validator.property("initialAmount");
            BigDecimal finalAmount = fee.getFinalAmount();
            initialAmount.comparable(finalAmount, "<=", new ValidationError("errors.greaterThan", this.messageResolver.message("transactionFee.finalAmount", new Object[0])));
        }
        return validator;
    }

    private void preSave(TransactionFee transactionFee) {
        if (transactionFee.isFromAllGroups()) {
            transactionFee.setFromGroups(null);
        }
        if (transactionFee.isToAllGroups()) {
            transactionFee.setToGroups(null);
        }
        if (transactionFee.getPayer() != TransactionFee.Subject.FIXED_MEMBER) {
            transactionFee.setFromFixedMember(null);
        }
    }

    private static class PayerAndReceiverValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -1969165853079125625L;

        private PayerAndReceiverValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            SimpleTransactionFee fee = (SimpleTransactionFee)object;
            TransactionFee.Subject payer = fee.getPayer();
            TransactionFee.Subject receiver = fee.getReceiver();
            if ((payer == TransactionFee.Subject.SOURCE || payer == TransactionFee.Subject.DESTINATION) && payer == receiver) {
                return new ValidationError("transactionFee.error.samePayerAndReceiver", new Object[0]);
            }
            return null;
        }
    }

    public class GeneratedTransferTypeValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 1616929350799341483L;

        @Override
        public ValidationError validate(Object object) {
            TransactionFee fee = (TransactionFee)object;
            TransferType generatedType = TransactionFeeServiceImpl.this.fetchService.fetch(fee.getGeneratedTransferType(), TransferType.Relationships.FROM);
            fee.setGeneratedTransferType(generatedType);
            if (fee.isTransient()) {
                return null;
            }
            TransactionFee savedFee = TransactionFeeServiceImpl.this.load(fee.getId(), TransactionFee.Relationships.GENERATED_TRANSFER_TYPE);
            TransferType savedGeneratedType = savedFee.getGeneratedTransferType();
            if (savedFee.getNature() == TransactionFee.Nature.BROKER && !savedFee.isFromSystem() && !generatedType.equals(savedGeneratedType)) {
                return new ValidationError("transactionFee.error.cannotChangeGeneratedType", new Object[0]);
            }
            if (savedFee.isFromSystem() && !fee.isFromSystem()) {
                return new ValidationError("transactionFee.erro.fromSystemGeneratedTypeRequired", new Object[0]);
            }
            return null;
        }
    }

    public class CountValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -8075223146818925038L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            BrokerCommission commission = (BrokerCommission)object;
            BrokerCommission.When when = commission.getWhen();
            if (when == BrokerCommission.When.COUNT || when == BrokerCommission.When.DAYS) {
                return RequiredValidation.instance().validate(object, property, value);
            }
            return null;
        }
    }
}

