/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.PermissionCheck;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeePreviewDTO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeService;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.webservices.model.TransactionFeeVO;
import org.apache.commons.collections.CollectionUtils;

public class TransactionFeeServiceSecurity
extends BaseServiceSecurity
implements TransactionFeeService {
    private TransactionFeeServiceLocal transactionFeeService;
    private TransferTypeServiceLocal transferTypeService;
    private InvoiceServiceLocal invoiceService;
    private PaymentServiceLocal paymentService;
    private GroupServiceLocal groupService;

    @Override
    public Collection<TransactionFee.ChargeType> getPossibleChargeType(TransferType originalTransferType, TransactionFee.Nature feeNature) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transactionFeeService.getPossibleChargeType(originalTransferType, feeNature);
    }

    @Override
    public Collection<TransactionFee.Subject> getPossibleSubjects(TransferType originalTransferType, TransactionFee.Nature nature) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transactionFeeService.getPossibleSubjects(originalTransferType, nature);
    }

    @Override
    public List<TransactionFeeVO> getTransactionFeeVOs(TransactionFeePreviewDTO preview) {
        Map<TransactionFee, BigDecimal> fees = preview.getFees();
        if (fees == null) {
            return null;
        }
        for (TransactionFee k : fees.keySet()) {
            this.checkView(k);
        }
        return this.transactionFeeService.getTransactionFeeVOs(preview);
    }

    @Override
    public TransactionFee load(Long id, Relationship ... fetch) {
        TransactionFee fee = this.transactionFeeService.load(id, fetch);
        this.checkView(fee);
        return fee;
    }

    @Override
    public TransactionFeePreviewDTO preview(AccountOwner from, AccountOwner to, TransferType transferType, BigDecimal amount) {
        if (!this.paymentService.canMakePayment(from, to, transferType)) {
            throw new PermissionDeniedException();
        }
        return this.transactionFeeService.preview(from, to, transferType, amount);
    }

    @Override
    public TransactionFeePreviewDTO preview(Invoice invoice) {
        if (!this.invoiceService.canAccept(invoice)) {
            throw new PermissionDeniedException();
        }
        return this.transactionFeeService.preview(invoice);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transactionFeeService.remove(ids);
    }

    @Override
    public BrokerCommission save(BrokerCommission brokerCommission) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        this.checkTransactionFee(brokerCommission);
        return this.transactionFeeService.save(brokerCommission);
    }

    @Override
    public SimpleTransactionFee save(SimpleTransactionFee transactionFee, SimpleTransactionFee.ARateRelation aRateRelation) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        this.checkTransactionFee(transactionFee);
        return this.transactionFeeService.save(transactionFee, aRateRelation);
    }

    @Override
    public List<? extends TransactionFee> search(TransactionFeeQuery query) {
        if (query.getMemberGroup() != null) {
            PermissionHelper.checkContains(this.permissionService.getManagedMemberGroups(), query.getMemberGroup());
        }
        if (query.getBrokerGroup() != null) {
            PermissionHelper.checkContains(this.permissionService.getManagedMemberGroups(), query.getBrokerGroup());
        }
        this.checkView(null);
        return this.transactionFeeService.search(query);
    }

    @Override
    public List<TransferType> searchGeneratedTransferTypes(TransactionFee fee, boolean allowAnyAccount, boolean onlyFromSystem) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transactionFeeService.searchGeneratedTransferTypes(fee, allowAnyAccount, onlyFromSystem);
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setTransactionFeeServiceLocal(TransactionFeeServiceLocal transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(BrokerCommission brokerCommission) {
        this.transactionFeeService.validate(brokerCommission);
    }

    @Override
    public void validate(SimpleTransactionFee transactionFee, SimpleTransactionFee.ARateRelation aRateRelation) {
        this.transactionFeeService.validate(transactionFee, aRateRelation);
    }

    private void checkGeneratedTransferType(TransactionFee transactionFee) {
        TransferType generatedTransferType = this.transferTypeService.load(transactionFee.getGeneratedTransferType().getId(), new Relationship[0]);
        transactionFee.setGeneratedTransferType(generatedTransferType);
        List<TransferType> allowedGeneratedTransferTypes = !transactionFee.isTransient() && transactionFee.isFromSystem() ? this.transactionFeeService.searchGeneratedTransferTypes(transactionFee, true, true) : this.transactionFeeService.searchGeneratedTransferTypes(transactionFee, true, false);
        PermissionHelper.checkContains(allowedGeneratedTransferTypes, transactionFee.getGeneratedTransferType());
    }

    private void checkGroups(TransactionFee transactionFee) {
        BrokerCommission brokerCommission;
        TransferType transferType = this.fetchService.fetch(transactionFee.getOriginalTransferType(), TransferType.Relationships.FROM, TransferType.Relationships.TO);
        if (transferType.isFromMember() && !transactionFee.isFromAllGroups() && CollectionUtils.isNotEmpty(transactionFee.getFromGroups())) {
            this.checkGroups(transferType, transactionFee.getFromGroups(), false, true);
        }
        if (transferType.isToMember() && !transactionFee.isToAllGroups() && CollectionUtils.isNotEmpty(transactionFee.getToGroups())) {
            this.checkGroups(transferType, transactionFee.getToGroups(), false, false);
        }
        if (transactionFee.getNature() == TransactionFee.Nature.BROKER && !(brokerCommission = (BrokerCommission)transactionFee).isAllBrokerGroups() && CollectionUtils.isNotEmpty(brokerCommission.getBrokerGroups())) {
            this.checkGroups(transferType, brokerCommission.getBrokerGroups(), true, null);
        }
    }

    private void checkGroups(TransferType transferType, Collection<? extends MemberGroup> groups, boolean activeBrokersOnly, Boolean from) {
        GroupQuery groupQuery = new GroupQuery();
        if (activeBrokersOnly) {
            groupQuery.setNature(Group.Nature.BROKER);
            groupQuery.setOnlyActive(true);
        } else {
            groupQuery.setNatures(Group.Nature.MEMBER, Group.Nature.BROKER);
        }
        groupQuery.setStatus(Group.Status.NORMAL);
        if (from != null) {
            groupQuery.setMemberAccountType((MemberAccountType)(from != false ? transferType.getFrom() : transferType.getTo()));
        }
        List<? extends Group> allowedGroups = this.groupService.search(groupQuery);
        PermissionHelper.checkSelection(allowedGroups, groups);
    }

    private void checkReadOnlyValues(TransactionFee modifiedTF) {
        if (modifiedTF.isPersistent()) {
            TransactionFee savedTF = this.load(modifiedTF.getId(), new Relationship[0]);
            PermissionHelper.checkEquals(savedTF.getOriginalTransferType(), modifiedTF.getOriginalTransferType());
            PermissionHelper.checkEquals(savedTF.getPayer(), modifiedTF.getPayer());
            if (savedTF.getNature() == TransactionFee.Nature.SIMPLE) {
                SimpleTransactionFee modifiedSTF = (SimpleTransactionFee)modifiedTF;
                SimpleTransactionFee savedSTF = (SimpleTransactionFee)savedTF;
                PermissionHelper.checkEquals(savedSTF.getReceiver(), modifiedSTF.getReceiver());
                PermissionHelper.checkEquals(savedSTF.getFromFixedMember(), modifiedSTF.getFromFixedMember());
                PermissionHelper.checkEquals(savedSTF.getToFixedMember(), modifiedSTF.getToFixedMember());
            } else if (savedTF.getNature() == TransactionFee.Nature.BROKER) {
                BrokerCommission modifiedBC = (BrokerCommission)modifiedTF;
                BrokerCommission savedBC = (BrokerCommission)savedTF;
                if (!savedTF.getGeneratedTransferType().isFromSystem()) {
                    PermissionHelper.checkEquals(savedTF.getGeneratedTransferType(), modifiedTF.getGeneratedTransferType());
                }
                PermissionHelper.checkEquals(savedBC.getWhichBroker(), modifiedBC.getWhichBroker());
            }
        }
    }

    private void checkSubjects(TransactionFee transactionFee) {
        Collection<TransactionFee.Subject> possibleSubjects = this.transactionFeeService.getPossibleSubjects(transactionFee.getOriginalTransferType(), transactionFee.getNature());
        PermissionHelper.checkContains(possibleSubjects, transactionFee.getPayer());
        if (transactionFee.getNature() == TransactionFee.Nature.SIMPLE) {
            TransactionFee.Subject receiver = ((SimpleTransactionFee)transactionFee).getReceiver();
            PermissionHelper.checkContains(possibleSubjects, receiver);
        }
    }

    private void checkTransactionFee(TransactionFee transactionFee) {
        Member toFixedMember;
        this.checkReadOnlyValues(transactionFee);
        if (transactionFee.getFromFixedMember() != null) {
            this.permissionService.checkManages(transactionFee.getFromFixedMember());
        }
        if (transactionFee.getNature() == TransactionFee.Nature.SIMPLE && (toFixedMember = ((SimpleTransactionFee)transactionFee).getToFixedMember()) != null) {
            this.permissionService.checkManages(toFixedMember);
        }
        this.checkGroups(transactionFee);
        this.checkGeneratedTransferType(transactionFee);
        this.checkSubjects(transactionFee);
        PermissionHelper.checkContains(this.transactionFeeService.getPossibleChargeType(transactionFee.getOriginalTransferType(), transactionFee.getNature()), transactionFee.getChargeType());
    }

    private void checkView(TransactionFee fee) {
        PermissionCheck check = this.permissionService.permission().admin(AdminMemberPermission.BROKERINGS_MANAGE_COMMISSIONS, AdminSystemPermission.ACCOUNTS_VIEW).broker(BrokerPermission.MEMBERS_MANAGE_DEFAULTS, BrokerPermission.MEMBERS_MANAGE_CONTRACTS);
        boolean hasPermission = check.hasPermission();
        if (!hasPermission) {
            if (fee != null) {
                MemberGroup mGroup;
                Collection<MemberGroupAccountSettings> mgaccSettings;
                AccountType fromAccType = fee.getOriginalTransferType().getFrom();
                AccountOwner accountOwner = LoggedUser.accountOwner();
                if (accountOwner instanceof Member && (mgaccSettings = (mGroup = ((Member)accountOwner).getMemberGroup()).getAccountSettings()) != null) {
                    for (MemberGroupAccountSettings mgaccSetting : mGroup.getAccountSettings()) {
                        if (!mgaccSetting.getAccountType().equals(fromAccType)) continue;
                        return;
                    }
                }
            }
            throw new PermissionDeniedException();
        }
    }
}

