/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.dao.accounts.transactions.AuthorizationLevelDAO;
import nl.strohalm.cyclos.dao.accounts.transactions.TransferTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.transactions.AuthorizationLevel;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferListener;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.PaymentServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.exceptions.HasPendingPaymentsException;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PositiveNonZeroValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.model.TransferTypeVO;
import nl.strohalm.cyclos.webservices.utils.AccountHelper;
import org.apache.commons.collections.CollectionUtils;

public class TransferTypeServiceImpl
implements TransferTypeServiceLocal {
    private static final float PRECISION_DELTA = 1.0E-4f;
    private AuthorizationLevelDAO authorizationLevelDao;
    private FetchServiceLocal fetchService;
    private TransferTypeDAO transferTypeDao;
    private PaymentServiceLocal paymentService;
    private AccountServiceLocal accountService;
    private GroupServiceLocal groupService;
    private PermissionServiceLocal permissionService;
    private AccountHelper accountHelper;

    @Override
    public Collection<TransferType> getAllowedTTs(Element element) {
        element = this.fetchService.fetch(element, RelationshipHelper.nested(Element.Relationships.GROUP, Group.Relationships.TRANSFER_TYPES), RelationshipHelper.nested(Element.Relationships.GROUP, AdminGroup.Relationships.TRANSFER_TYPES_AS_MEMBER), RelationshipHelper.nested(Element.Relationships.GROUP, Group.Relationships.CONVERSION_SIMULATION_TTS));
        Group group = element.getGroup();
        HashSet<TransferType> allowed = new HashSet<TransferType>();
        CollectionUtils.addAll(allowed, group.getConversionSimulationTTs().iterator());
        if (group instanceof AdminGroup) {
            CollectionUtils.addAll(allowed, ((AdminGroup)group).getTransferTypesAsMember().iterator());
        } else if (group instanceof BrokerGroup) {
            CollectionUtils.addAll(allowed, ((BrokerGroup)group).getTransferTypesAsMember().iterator());
        }
        if (group instanceof OperatorGroup) {
            OperatorGroup operatorGroup = (OperatorGroup)group;
            group = this.fetchService.fetch(operatorGroup.getMember().getGroup(), Group.Relationships.TRANSFER_TYPES);
        }
        CollectionUtils.addAll(allowed, group.getTransferTypes().iterator());
        if (group instanceof MemberGroup) {
            MemberGroup memberGroup = (MemberGroup)group;
            Collection<AccountFee> accountFees = memberGroup.getAccountFees();
            for (AccountFee accountFee : accountFees) {
                allowed.add(accountFee.getTransferType());
            }
        }
        return allowed;
    }

    @Override
    public List<TransferType> getAuthorizableTTs() {
        TransferTypeQuery query = new TransferTypeQuery();
        query.setAuthorizable(true);
        if (!this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_VIEW)) {
            query.setPossibleTransferTypes(this.getAllowedTTs((Element)LoggedUser.element()));
        }
        return this.search(query);
    }

    @Override
    public List<TransferType> getConversionTTs() {
        TransferTypeQuery ttQuery = this.makeConversionTransferTypeQuery();
        return this.search(ttQuery);
    }

    @Override
    public List<TransferType> getConversionTTs(AccountType fromAccountType) {
        TransferTypeQuery ttQuery = this.makeConversionTransferTypeQuery();
        ArrayList<AccountType> accountTypes = new ArrayList<AccountType>(1);
        accountTypes.add(fromAccountType);
        ttQuery.setFromAccountTypes(accountTypes);
        return this.search(ttQuery);
    }

    @Override
    public List<TransferType> getConversionTTs(Currency currency) {
        TransferTypeQuery ttQuery = this.makeConversionTransferTypeQuery();
        ttQuery.setCurrency(currency);
        return this.search(ttQuery);
    }

    @Override
    public List<TransferType> getPaymentAndSelfPaymentTTs() {
        if (!(LoggedUser.element() instanceof Administrator)) {
            throw new IllegalArgumentException("Expected an administrator logged user");
        }
        AdminGroup group = (AdminGroup)this.fetchService.fetch(((Element)LoggedUser.element()).getGroup(), AdminGroup.Relationships.VIEW_INFORMATION_OF);
        TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
        transferTypeQuery.setFromOrToAccountTypes(group.getViewInformationOf());
        if (!this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_VIEW)) {
            transferTypeQuery.setPossibleTransferTypes(this.getAllowedTTs((Element)LoggedUser.element()));
        }
        List<TransferType> transferTypes = this.search(transferTypeQuery);
        Iterator<TransferType> iterator = transferTypes.iterator();
        while (iterator.hasNext()) {
            TransferType tt = iterator.next();
            TransferType.Context ttContext = tt.getContext();
            if (ttContext.isPayment() || ttContext.isSelfPayment()) continue;
            iterator.remove();
        }
        return transferTypes;
    }

    @Override
    public List<TransferType> getPosibleTTsForAccountFee(MemberAccountType accountType, AccountFee.PaymentDirection paymentDirection) {
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setContext(TransactionContext.ANY);
        switch (paymentDirection) {
            case TO_MEMBER: {
                ttQuery.setFromNature(AccountType.Nature.SYSTEM);
                ttQuery.setToAccountType(accountType);
                break;
            }
            case TO_SYSTEM: {
                ttQuery.setFromAccountType(accountType);
                ttQuery.setToNature(AccountType.Nature.SYSTEM);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this.search(ttQuery);
    }

    @Override
    public TransferTypeVO getTransferTypeVO(Long transferTypeId, boolean extended) {
        if (transferTypeId == null) {
            return null;
        }
        TransferType tt = this.load(transferTypeId, new Relationship[0]);
        if (extended) {
            return this.accountHelper.toDetailedVO(tt);
        }
        return this.accountHelper.toVO(tt);
    }

    @Override
    public List<TransferType> listARatedTTs() {
        List<TransferType> conversionTTs = this.getConversionTTs();
        ArrayList<TransferType> result = new ArrayList<TransferType>(conversionTTs.size());
        for (TransferType tt : conversionTTs) {
            if (!tt.isHavingAratedFees()) continue;
            result.add(tt);
        }
        return result;
    }

    @Override
    public TransferType load(Long id, Relationship ... fetch) {
        return (TransferType)this.transferTypeDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.transferTypeDao.delete(ids);
    }

    @Override
    public TransferType save(TransferType transferType) {
        TransferType.Context context;
        this.validate(transferType);
        if (transferType.getContext().isSelfPayment() && transferType.getFrom().getClass() == AccountType.Nature.SYSTEM.getType() && transferType.getTo().getClass() == AccountType.Nature.MEMBER.getType()) {
            context = new TransferType.Context();
            context.setPayment(true);
            transferType.setContext(context);
        } else if (transferType.getContext().isPayment() && transferType.getFrom().getClass() == AccountType.Nature.SYSTEM.getType() && transferType.getTo().getClass() == AccountType.Nature.SYSTEM.getType()) {
            context = new TransferType.Context();
            context.setSelfPayment(true);
            transferType.setContext(context);
        }
        if (!transferType.isLoanType()) {
            transferType.setLoan(null);
        }
        if (transferType.isTransient()) {
            if (transferType.isRequiresFeedback()) {
                transferType.setFeedbackEnabledSince(Calendar.getInstance());
            }
            return this.transferTypeDao.insert(transferType);
        }
        TransferType current = this.load(transferType.getId(), TransferType.Relationships.PAYMENT_FILTERS, TransferType.Relationships.LINKED_CUSTOM_FIELDS);
        transferType.setPaymentFilters(new ArrayList<PaymentFilter>(current.getPaymentFilters()));
        transferType.setLinkedCustomFields(new ArrayList<PaymentCustomField>(current.getLinkedCustomFields()));
        if (current.isRequiresAuthorization() && !transferType.isRequiresAuthorization()) {
            TransferQuery query = new TransferQuery();
            query.setPageForCount();
            query.setTransferType(transferType);
            query.setRequiresAuthorization(true);
            query.setStatus(Payment.Status.PENDING);
            int payments = PageHelper.getTotalCount(this.paymentService.search(query));
            if (payments > 0) {
                throw new HasPendingPaymentsException();
            }
        }
        if (current.isRequiresFeedback() && !transferType.isRequiresFeedback()) {
            transferType.setFeedbackEnabledSince(null);
        } else if (!current.isRequiresFeedback() && transferType.isRequiresFeedback()) {
            transferType.setFeedbackEnabledSince(Calendar.getInstance());
        } else {
            transferType.setFeedbackEnabledSince(current.getFeedbackEnabledSince());
        }
        transferType = this.transferTypeDao.update(transferType);
        Collection<AuthorizationLevel> authorizationLevels = transferType.getAuthorizationLevels();
        if (!transferType.isRequiresAuthorization() && !CollectionUtils.isEmpty(authorizationLevels)) {
            for (AuthorizationLevel authorizationLevel : authorizationLevels) {
                this.authorizationLevelDao.delete(authorizationLevel.getId());
            }
        }
        return transferType;
    }

    @Override
    public List<TransferType> search(TransferTypeQuery query) {
        Group group = this.fetchService.fetch(query.getGroup(), RelationshipHelper.nested(OperatorGroup.Relationships.MEMBER, Element.Relationships.GROUP));
        if (group instanceof OperatorGroup) {
            OperatorGroup operatorGroup = (OperatorGroup)group;
            query.setGroup(operatorGroup.getMember().getGroup());
        }
        TransferTypeQuery finalQuery = (TransferTypeQuery)query.clone();
        finalQuery.setUsePriority(false);
        if (query.isUsePriority()) {
            query.setPriority(true);
            query.setPageForCount();
            int totalCount = PageHelper.getTotalCount(this.transferTypeDao.search(query));
            finalQuery.setPriority(totalCount > 0);
        }
        if (query.getFromOwner() instanceof Member) {
            Member member = this.fetchService.fetch((Member)query.getFromOwner(), RelationshipHelper.nested(Element.Relationships.GROUP, MemberGroup.Relationships.ACCOUNT_SETTINGS));
            ArrayList<AccountType> accountTypes = new ArrayList<AccountType>();
            List<? extends Account> accounts = this.accountService.getAccounts(member, new Relationship[0]);
            for (Account account : accounts) {
                boolean hidden;
                block7: {
                    hidden = false;
                    try {
                        MemberGroupAccountSettings accountSettings = this.groupService.loadAccountSettings(member.getGroup().getId(), account.getType().getId(), new Relationship[0]);
                        if (!accountSettings.isHideWhenNoCreditLimit() || !(Math.abs(account.getCreditLimit().floatValue()) < 1.0E-4f)) break block7;
                        hidden = true;
                    }
                    catch (EntityNotFoundException e) {
                        continue;
                    }
                }
                if (hidden) continue;
                accountTypes.add(account.getType());
            }
            if (CollectionUtils.isNotEmpty(finalQuery.getFromAccountTypes())) {
                accountTypes.retainAll(finalQuery.getFromAccountTypes());
            }
            finalQuery.setFromAccountTypes(accountTypes);
        }
        return this.transferTypeDao.search(finalQuery);
    }

    public void setAccountHelper(AccountHelper accountHelper) {
        this.accountHelper = accountHelper;
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAuthorizationLevelDao(AuthorizationLevelDAO authorizationLevelDao) {
        this.authorizationLevelDao = authorizationLevelDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setPaymentServiceLocal(PaymentServiceLocal paymentService) {
        this.paymentService = paymentService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setTransferTypeDao(TransferTypeDAO dao) {
        this.transferTypeDao = dao;
    }

    @Override
    public void validate(TransferType transferType) {
        if (transferType.isLoanType()) {
            this.getLoanValidator().validate(transferType);
        } else {
            this.getValidator().validate(transferType);
        }
    }

    private Validator createValidator() {
        Validator validator = new Validator("transferType");
        validator.property("name").required().maxLength(100);
        validator.property("description").required().maxLength(1000);
        validator.property("confirmationMessage").maxLength(4000);
        validator.property("from").required();
        validator.property("to").required().add(new DestinationAccountTypeValidator());
        validator.property("maxAmountPerDay").positiveNonZero();
        validator.property("minAmount").positiveNonZero();
        validator.property("feedbackExpirationTime.number").key("transferType.feedbackExpirationTime").add(new FeedbackValidator(RequiredValidation.instance())).add(new FeedbackValidator(PositiveNonZeroValidation.instance()));
        validator.property("feedbackExpirationTime.field").key("transferType.feedbackExpirationTime").add(new FeedbackValidator(RequiredValidation.instance()));
        validator.property("feedbackReplyExpirationTime.number").key("transferType.feedbackReplyExpirationTime").add(new FeedbackValidator(RequiredValidation.instance())).add(new FeedbackValidator(PositiveNonZeroValidation.instance()));
        validator.property("feedbackReplyExpirationTime.field").key("transferType.feedbackReplyExpirationTime").add(new FeedbackValidator(RequiredValidation.instance()));
        validator.property("defaultFeedbackComments").add(new FeedbackValidator(RequiredValidation.instance()));
        validator.property("defaultFeedbackLevel").add(new FeedbackValidator(RequiredValidation.instance()));
        validator.property("transferListenerClass").instanceOf(TransferListener.class);
        validator.general(new MaxMinAmountValidator());
        return validator;
    }

    private Validator getLoanValidator() {
        Validator loanValidator = this.createValidator();
        Validator nestedValidator = new Validator("loan", "loan");
        loanValidator.chained(nestedValidator);
        nestedValidator.property("repaymentType").add(new PropertyValidation(){
            private static final long serialVersionUID = -3441031471188004677L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                TransferType repayment;
                LoanParameters lp = (LoanParameters)object;
                ValidationError error = null;
                if (lp != null && lp.getType() != null && (error = RequiredValidation.instance().validate(object, name, value)) == null && ((repayment = TransferTypeServiceImpl.this.fetchService.fetch((TransferType)value, TransferType.Relationships.FROM, TransferType.Relationships.TO)).isFromSystem() || !repayment.isToSystem())) {
                    error = new InvalidError();
                }
                return error;
            }
        });
        nestedValidator.property("repaymentDays").positiveNonZero().add(new PropertyValidation(){
            private static final long serialVersionUID = -3665200579172755969L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                LoanParameters lp = (LoanParameters)object;
                if (lp != null && lp.getType() == Loan.Type.SINGLE_PAYMENT) {
                    return RequiredValidation.instance().validate(object, name, value);
                }
                return null;
            }
        });
        nestedValidator.property("grantFee").positiveNonZero();
        nestedValidator.property("grantFeeRepaymentType").add(new LoanWithInterestRepaymentTypeValidator("grantFee", true));
        nestedValidator.property("monthlyInterest").positiveNonZero();
        nestedValidator.property("monthlyInterestRepaymentType").add(new LoanWithInterestRepaymentTypeValidator("monthlyInterest", true));
        nestedValidator.property("expirationFee").positiveNonZero();
        nestedValidator.property("expirationFeeRepaymentType").add(new LoanWithInterestRepaymentTypeValidator("expirationFee", true));
        nestedValidator.property("expirationDailyInterest").positiveNonZero();
        nestedValidator.property("expirationDailyInterestRepaymentType").add(new LoanWithInterestRepaymentTypeValidator("expirationDailyInterest", true));
        return loanValidator;
    }

    private Validator getValidator() {
        return this.createValidator();
    }

    private TransferTypeQuery makeConversionTransferTypeQuery() {
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setContext(TransactionContext.PAYMENT);
        ttQuery.setFromNature(AccountType.Nature.MEMBER);
        ttQuery.setToNature(AccountType.Nature.SYSTEM);
        ttQuery.setToLimitType(AccountType.LimitType.UNLIMITED);
        return ttQuery;
    }

    private final class MaxMinAmountValidator
    implements GeneralValidation {
        private static final long serialVersionUID = -7872725176651230479L;

        private MaxMinAmountValidator() {
        }

        @Override
        public ValidationError validate(Object object) {
            TransferType tt = (TransferType)object;
            BigDecimal minAmount = tt.getMinAmount();
            BigDecimal maxAmountPerDay = tt.getMaxAmountPerDay();
            if (minAmount != null && maxAmountPerDay != null && minAmount.compareTo(maxAmountPerDay) > 0) {
                return new ValidationError("transferType.error.minMaxPerDayAmount", new Object[0]);
            }
            return null;
        }
    }

    private final class LoanWithInterestRepaymentTypeValidator
    implements PropertyValidation {
        private static final long serialVersionUID = -3441031471188004677L;
        private final String property;
        private final boolean toSystem;

        public LoanWithInterestRepaymentTypeValidator(String property, boolean toSystem) {
            this.property = property;
            this.toSystem = toSystem;
        }

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            LoanParameters loan = (LoanParameters)object;
            TransferType repayment = TransferTypeServiceImpl.this.fetchService.fetch((TransferType)value, TransferType.Relationships.FROM, TransferType.Relationships.TO);
            ValidationError error = null;
            if (loan.getType() == Loan.Type.WITH_INTEREST) {
                Object related = PropertyHelper.get(loan, this.property);
                boolean required = false;
                if (related instanceof Amount) {
                    Amount amount = (Amount)related;
                    required = amount != null && amount.getValue() != null && amount.getValue().compareTo(BigDecimal.ZERO) == 1;
                } else if (related instanceof BigDecimal) {
                    BigDecimal f = (BigDecimal)related;
                    boolean bl = required = f != null && f.compareTo(BigDecimal.ZERO) == 1;
                }
                if (required && (error = RequiredValidation.instance().validate(object, name, value)) == null) {
                    if (this.toSystem && (repayment.isFromSystem() || !repayment.isToSystem())) {
                        error = new InvalidError();
                    } else if (!(this.toSystem || repayment.isFromSystem() && !repayment.isToSystem())) {
                        error = new InvalidError();
                    }
                }
            }
            return error;
        }
    }

    private class FeedbackValidator
    implements PropertyValidation {
        private static final long serialVersionUID = 2435741054912450932L;
        private final PropertyValidation validation;

        public FeedbackValidator(PropertyValidation validation) {
            this.validation = validation;
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            TransferType tt = (TransferType)object;
            if (tt.isRequiresFeedback()) {
                return this.validation.validate(object, property, value);
            }
            return null;
        }
    }

    private final class DestinationAccountTypeValidator
    implements PropertyValidation {
        private static final long serialVersionUID = -1068050406929695757L;

        private DestinationAccountTypeValidator() {
        }

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            Currency destinationAccountTypeCurrency;
            TransferType transferType = (TransferType)object;
            AccountType from = TransferTypeServiceImpl.this.fetchService.fetch(transferType.getFrom(), AccountType.Relationships.CURRENCY);
            AccountType to = (AccountType)value;
            Currency sourceAccountTypeCurrency = from.getCurrency();
            if (!sourceAccountTypeCurrency.equals(destinationAccountTypeCurrency = (to = TransferTypeServiceImpl.this.fetchService.fetch(to, AccountType.Relationships.CURRENCY)).getCurrency())) {
                return new ValidationError("transferType.error.invalidDestinationType", new Object[0]);
            }
            if (from != null && to != null) {
                if (from.equals(to) && from.getNature() == AccountType.Nature.SYSTEM) {
                    return new InvalidError();
                }
                if (transferType.isLoanType() && (from.getNature() == AccountType.Nature.MEMBER || to.getNature() == AccountType.Nature.SYSTEM)) {
                    return new InvalidError();
                }
            }
            return null;
        }
    }
}

