/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.transfertypes;

import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeService;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.webservices.model.TransferTypeVO;

public class TransferTypeServiceSecurity
extends BaseServiceSecurity
implements TransferTypeService {
    private TransferTypeServiceLocal transferTypeService;

    @Override
    public List<TransferType> getAuthorizableTTs() {
        this.permissionService.permission().admin(AdminMemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).check();
        return this.transferTypeService.getAuthorizableTTs();
    }

    @Override
    public List<TransferType> getPaymentAndSelfPaymentTTs() {
        this.permissionService.permission().admin(AdminMemberPermission.PREFERENCES_MANAGE_NOTIFICATIONS).check();
        return this.transferTypeService.getPaymentAndSelfPaymentTTs();
    }

    @Override
    public List<TransferType> getPosibleTTsForAccountFee(MemberAccountType accountType, AccountFee.PaymentDirection paymentDirection) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transferTypeService.getPosibleTTsForAccountFee(accountType, paymentDirection);
    }

    @Override
    public TransferTypeVO getTransferTypeVO(Long transferTypeId, boolean extended) {
        if (transferTypeId == null) {
            return null;
        }
        return this.transferTypeService.getTransferTypeVO(transferTypeId, extended);
    }

    @Override
    public List<TransferType> listARatedTTs() {
        return this.transferTypeService.listARatedTTs();
    }

    @Override
    public TransferType load(Long id, Relationship ... fetch) {
        TransferType tt = this.transferTypeService.load(id, fetch);
        if (!this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_VIEW) && !this.transferTypeService.getAllowedTTs((Element)LoggedUser.element()).contains(tt)) {
            throw new PermissionDeniedException();
        }
        return tt;
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transferTypeService.remove(ids);
    }

    @Override
    public TransferType save(TransferType transferType) {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
        return this.transferTypeService.save(transferType);
    }

    @Override
    public List<TransferType> search(TransferTypeQuery query) {
        AccountOwner fromOrToOwner;
        AccountOwner toOwner;
        AccountOwner fromOwner = query.getFromOwner();
        if (fromOwner instanceof Member) {
            this.permissionService.checkRelatesTo((Member)fromOwner);
        }
        if ((toOwner = query.getToOwner()) instanceof Member) {
            this.permissionService.checkRelatesTo((Member)toOwner);
        }
        if ((fromOrToOwner = query.getFromOrToOwner()) instanceof Member) {
            this.permissionService.checkRelatesTo((Member)fromOrToOwner);
        }
        if (!this.hasPermission(AdminSystemPermission.ACCOUNTS_VIEW)) {
            if (LoggedUser.isWebService()) {
                ServiceClient client = LoggedUser.serviceClient();
                HashSet<TransferType> possible = new HashSet<TransferType>();
                possible.addAll(client.getDoPaymentTypes());
                possible.addAll(client.getReceivePaymentTypes());
                possible.addAll(client.getChargebackPaymentTypes());
                query.setPossibleTransferTypes(possible);
            } else {
                HashSet<TransferType> possible = new HashSet<TransferType>();
                if (fromOwner instanceof Member) {
                    Member fromMember = (Member)fromOwner;
                    possible.addAll(this.transferTypeService.getAllowedTTs(fromMember));
                }
                if (LoggedUser.hasUser()) {
                    Object loggedElement = LoggedUser.element();
                    possible.addAll(this.transferTypeService.getAllowedTTs((Element)loggedElement));
                }
                query.setPossibleTransferTypes(possible);
            }
        }
        return this.transferTypeService.search(query);
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(TransferType transferType) {
        this.transferTypeService.validate(transferType);
    }
}

