/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.servlets;

import com.google.code.kaptcha.Producer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.utils.SpringHelper;

public class CaptchaServlet
extends HttpServlet {
    private static final long serialVersionUID = -7876504189381958457L;
    private Producer captchaProducer;

    public static boolean checkChallenge(HttpServletRequest request, String challenge) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        try {
            return challenge.equalsIgnoreCase((String)session.getAttribute("KAPTCHA_SESSION_KEY"));
        }
        catch (Exception e) {
            return false;
        }
    }

    public void init() throws ServletException {
        SpringHelper.injectBeans(this.getServletContext(), (Object)this);
    }

    @Inject
    public void setCaptchaProducer(Producer captchaProducer) {
        this.captchaProducer = captchaProducer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        String challenge = this.captchaProducer.createText();
        session.setAttribute("KAPTCHA_SESSION_KEY", (Object)challenge);
        BufferedImage image = this.captchaProducer.createImage(challenge);
        response.setContentType("image/png");
        ImageIO.write((RenderedImage)image, "png", (OutputStream)response.getOutputStream());
        response.flushBuffer();
    }
}

