/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.servlets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.CyclosConfiguration;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import nl.strohalm.cyclos.utils.customizedfile.ImageChangeListener;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ImageByIdServlet
extends HttpServlet {
    public static final String ROOT_CACHE_PATH = "/pages/images/cache";
    public static final String IMAGES_CACHE_PATH = "/pages/images/cache/images";
    public static final String THUMBNAILS_CACHE_PATH = "/pages/images/cache/thumbnails";
    private static final long serialVersionUID = 7494480285703279642L;
    private static final Log LOG = LogFactory.getLog(ImageByIdServlet.class);
    private ImageService imageService;
    private TransactionHelper transactionHelper;
    private boolean isThumbnail;
    private boolean useCache;
    private CustomizationHelper customizationHelper;
    private File cacheDir;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = this.getServletContext();
        SpringHelper.injectBeans(context, (Object)this);
        this.isThumbnail = "true".equals(config.getInitParameter("thumbnail"));
        try {
            this.useCache = "true".equals(CyclosConfiguration.getCyclosProperties().getProperty("cyclos.imageDiskCache.enable", "true"));
        }
        catch (Exception e) {
            this.useCache = false;
        }
        if (this.useCache) {
            this.cacheDir = new File(this.getServletContext().getRealPath(this.isThumbnail ? THUMBNAILS_CACHE_PATH : IMAGES_CACHE_PATH));
            LOG.debug((Object)("Using disk cache for " + (this.isThumbnail ? "thumbnails" : "images") + " at " + this.cacheDir.getAbsolutePath()));
        }
        SpringHelper.bean(context, CustomizedFileHandler.class).addImageChangeListener(new ImageChangeListener(){

            @Override
            public void onImageChanged(Image image) {
                File file = new File(ImageByIdServlet.this.cacheDir, image.getId().toString());
                ImageByIdServlet.this.customizationHelper.deleteFile(file);
            }
        });
    }

    @Inject
    public void setCustomizationHelper(CustomizationHelper customizationHelper) {
        this.customizationHelper = customizationHelper;
    }

    @Inject
    public void setImageService(ImageService imageService) {
        this.imageService = imageService;
    }

    @Inject
    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long id;
        try {
            id = Long.parseLong(request.getParameter("id"));
        }
        catch (Exception e) {
            response.sendError(400);
            return;
        }
        ImageDescriptor image = null;
        image = this.useCache ? this.readFromFile(request, response, id) : this.readFromDB(request, response, id);
        image.write();
    }

    private DBImageDescriptor readFromDB(HttpServletRequest request, HttpServletResponse response, long id) {
        return new DBImageDescriptor(request, response, id);
    }

    private FileImageDescriptor readFromFile(HttpServletRequest request, HttpServletResponse response, long id) {
        File file = new File(this.cacheDir, String.valueOf(id));
        if (!file.exists()) {
            new DBImageDescriptor(request, response, id).writeIntoFile(file);
        }
        return new FileImageDescriptor(request, response, file);
    }

    private abstract class ImageDescriptor {
        private HttpServletRequest request;
        private HttpServletResponse response;

        private ImageDescriptor(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        protected void sendError(int code) {
            try {
                this.response.sendError(code);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void setContentLength(long length) {
            this.response.setContentLength((int)length);
        }

        protected void setContentType(String contentType) {
            this.response.setContentType(contentType);
        }

        protected boolean setLastModified(long lastModified) {
            long ifModifiedSince = this.request.getDateHeader("If-Modified-Since");
            if (ifModifiedSince > 0L && lastModified <= ifModifiedSince) {
                this.response.setStatus(304);
                return false;
            }
            this.response.setDateHeader("Last-Modified", lastModified);
            return true;
        }

        protected abstract void write() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeContents(InputStream in) {
            try {
                this.response.setStatus(200);
                IOUtils.copy((InputStream)in, (OutputStream)this.response.getOutputStream());
                this.response.flushBuffer();
            }
            catch (Exception e) {
                this.sendError(500);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private class FileImageDescriptor
    extends ImageDescriptor {
        private final File file;

        private FileImageDescriptor(HttpServletRequest request, HttpServletResponse response, File file) {
            super(request, response);
            this.file = file;
        }

        @Override
        public void write() throws IOException {
            if (!this.setLastModified(this.file.lastModified())) {
                return;
            }
            try {
                this.setContentType(ImageHelper.ImageType.getByContent(this.file).getContentType());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setContentLength(this.file.length());
            try {
                this.writeContents(new FileInputStream(this.file));
            }
            catch (FileNotFoundException e) {
                this.sendError(404);
            }
        }
    }

    private class DBImageDescriptor
    extends ImageDescriptor {
        private final long id;

        private DBImageDescriptor(HttpServletRequest request, HttpServletResponse response, long id) {
            super(request, response);
            this.id = id;
        }

        @Override
        public void write() throws IOException {
            ImageByIdServlet.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    status.setRollbackOnly();
                    try {
                        Image image = ImageByIdServlet.this.imageService.load(DBImageDescriptor.this.id, new Relationship[0]);
                        if (!DBImageDescriptor.this.setLastModified(image.getLastModified().getTimeInMillis())) {
                            return;
                        }
                        DBImageDescriptor.this.setContentType(image.getContentType());
                        InputStream in = (ImageByIdServlet.this.isThumbnail ? image.getThumbnail() : image.getImage()).getBinaryStream();
                        DBImageDescriptor.this.writeContents(in);
                    }
                    catch (EntityNotFoundException e) {
                        DBImageDescriptor.this.sendError(404);
                    }
                    catch (Exception e) {
                        DBImageDescriptor.this.sendError(500);
                    }
                }
            });
        }

        public boolean writeIntoFile(final File file) {
            return ImageByIdServlet.this.transactionHelper.runInCurrentThread(new TransactionCallback<Boolean>(){

                public Boolean doInTransaction(TransactionStatus status) {
                    status.setRollbackOnly();
                    try {
                        Image image = ImageByIdServlet.this.imageService.load(DBImageDescriptor.this.id, new Relationship[0]);
                        InputStream in = (ImageByIdServlet.this.isThumbnail ? image.getThumbnail() : image.getImage()).getBinaryStream();
                        file.getParentFile().mkdirs();
                        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(file));
                        file.setLastModified(image.getLastModified().getTimeInMillis());
                        return true;
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            });
        }
    }
}

