/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.servlets;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.utils.ClassHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.ResponseHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.WebImageHelper;
import nl.strohalm.cyclos.utils.customizedfile.CustomizedFileHandler;
import nl.strohalm.cyclos.utils.customizedfile.ImageChangeListener;
import org.apache.commons.lang.StringUtils;

public class ImageByNameServlet
extends HttpServlet {
    private static final long serialVersionUID = 8368765800788965163L;
    private ServletContext context;
    private Image.Nature nature;
    private File imagePath;
    private File thumbnailPath;
    private final Map<String, String> resolvedNames = new HashMap<String, String>();
    private WebImageHelper webImageHelper;
    private ResponseHelper responseHelper;

    public synchronized void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = this.getServletContext();
        this.webImageHelper = SpringHelper.bean(this.context, WebImageHelper.class);
        this.responseHelper = SpringHelper.bean(this.context, ResponseHelper.class);
        SpringHelper.bean(this.context, CustomizedFileHandler.class).addImageChangeListener(new ImageChangeListener(){

            @Override
            public void onImageChanged(Image image) {
                if (ImageByNameServlet.this.nature.equals(image.getNature())) {
                    ImageByNameServlet.this.removeFromCache(image.getName());
                }
            }
        });
        String natureParameter = config.getInitParameter("nature");
        try {
            this.nature = Image.Nature.valueOf(natureParameter);
        }
        catch (Exception e) {
            this.context.log("Invalid nature for " + ClassHelper.getClassName(((Object)((Object)this)).getClass()) + ": " + natureParameter);
        }
        this.imagePath = this.webImageHelper.imagePath(this.nature);
        this.thumbnailPath = this.webImageHelper.thumbnailPath(this.nature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        Map<String, String> map = this.resolvedNames;
        synchronized (map) {
            Iterator<Map.Entry<String, String>> iterator = this.resolvedNames.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String current = entry.getKey();
                if (!name.equals(current) && !name.startsWith(current + ".")) continue;
                iterator.remove();
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.render(request, response);
        }
        catch (Exception e) {
            return;
        }
    }

    private void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        File file = this.resolveFile(request);
        if (file == null) {
            response.sendError(404);
        } else {
            ImageHelper.ImageType type;
            try {
                type = ImageHelper.ImageType.getByFileName(file.getName());
            }
            catch (Exception e) {
                type = null;
            }
            this.write(request, response, file, type);
        }
    }

    private File resolveFile(boolean thumbnail, String name) {
        if (name == null) {
            return null;
        }
        File file = new File(thumbnail ? this.thumbnailPath : this.imagePath, name);
        if (!file.exists()) {
            throw new IllegalArgumentException("Invalid image file: " + file);
        }
        return file;
    }

    private File resolveFile(HttpServletRequest request) {
        boolean thumbnail = "true".equals(request.getParameter("thumbnail"));
        String name = this.resolveName(request);
        return this.resolveFile(thumbnail, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveName(HttpServletRequest request) {
        String name = request.getParameter("image");
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        Map<String, String> map = this.resolvedNames;
        synchronized (map) {
            String resolved = this.resolvedNames.get(name);
            if (resolved == null) {
                File path = this.webImageHelper.imagePath(this.nature);
                for (String image : path.list()) {
                    if (!image.equals(name) && !image.startsWith(name + ".")) continue;
                    resolved = image;
                    break;
                }
                this.resolvedNames.put(name, resolved);
            }
            return resolved;
        }
    }

    private void write(HttpServletRequest request, HttpServletResponse response, File file, ImageHelper.ImageType type) throws IOException {
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifModifiedSince > 0L && file.lastModified() <= ifModifiedSince) {
            response.setStatus(304);
            return;
        }
        if (type != null) {
            response.setContentType(type.getContentType());
        }
        this.responseHelper.writeFile(response, file);
        response.flushBuffer();
    }
}

