/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.File;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.setup.Setup;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;

public class Arguments {
    static Options buildOptions(Locale locale) {
        ResourceBundle bundle = Setup.getResourceBundle(locale);
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)bundle.getString("arg.help"));
        options.addOption(OptionBuilder.create((char)'?'));
        OptionBuilder.withLongOpt((String)"force");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)bundle.getString("arg.force"));
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"database");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)bundle.getString("arg.create-data-base"));
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"script");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.withDescription((String)bundle.getString("arg.export-script"));
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"basic-data");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)bundle.getString("arg.create-basic-data"));
        options.addOption(OptionBuilder.create((char)'b'));
        OptionBuilder.withLongOpt((String)"initial-data");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)bundle.getString("arg.create-initial-data"));
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.withLongOpt((String)"sms-data");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)bundle.getString("arg.create-sms-data"));
        options.addOption(OptionBuilder.create((char)'m'));
        return options;
    }

    static Setup buildSetupFromArguments(Locale locale, String ... args) {
        CommandLine commandLine = null;
        Options options = Arguments.buildOptions(locale);
        try {
            commandLine = new PosixParser().parse(options, args);
        }
        catch (ParseException e) {
            Arguments.printHelp(options);
        }
        Setup setup = new Setup();
        setup.setCreateDataBase(commandLine.hasOption('d'));
        boolean createScript = commandLine.hasOption('s');
        String exportTo = StringUtils.trimToNull((String)commandLine.getOptionValue('s'));
        if (createScript && exportTo == null) {
            exportTo = "cyclos.ddl";
        }
        setup.setExportScriptTo(exportTo == null ? null : new File(exportTo));
        setup.setCreateInitialData(commandLine.hasOption('i'));
        setup.setCreateBasicData(commandLine.hasOption('b'));
        setup.setCreateSmsData(commandLine.hasOption('m'));
        if (!setup.isValid() || commandLine.hasOption('?')) {
            Arguments.printHelp(options);
        }
        setup.setForce(commandLine.hasOption('f'));
        return setup;
    }

    static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.defaultSyntaxPrefix = "";
        formatter.defaultLongOptPrefix = " --";
        PrintWriter printWriter = new PrintWriter(Setup.getOut());
        formatter.printHelp(printWriter, 74, Setup.getResourceBundle().getString("help.header") + ":\n", "", options, 1, 3, "", false);
        printWriter.flush();
        System.exit(1);
    }
}

