/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.CyclosConfiguration;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BasicPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.ModuleType;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.entities.Application;
import nl.strohalm.cyclos.entities.access.AdminUser;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.ChannelPrincipal;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BasicGroupSettings;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.settings.MessageSettings;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.entities.sms.SmsType;
import nl.strohalm.cyclos.setup.Setup;
import nl.strohalm.cyclos.setup.Version;
import nl.strohalm.cyclos.setup.VersionHistoryReader;
import nl.strohalm.cyclos.utils.HashHandler;
import nl.strohalm.cyclos.utils.conversion.LocaleConverter;
import nl.strohalm.cyclos.webservices.sms.SmsTypeCode;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CreateBasicData
implements Runnable {
    private static List<Permission> unwantedAccountAdminPermissions = Arrays.asList(AdminMemberPermission.MEMBERS_IMPORT, AdminMemberPermission.ADS_IMPORT);
    private static List<Permission> unwantedAdminPermissions;
    private static List<Permission> unwantedMemberPermissions;
    private final ResourceBundle bundle;
    private Properties cyclosProperties;
    private final Session session;
    private final boolean setupOnly;
    private final Locale locale;
    private AdminGroup systemAdmins;

    public static void createChannels(Session session, ResourceBundle bundle) {
        List<Channel> builtinChannels = CreateBasicData.getBuiltinChannels(bundle);
        for (Channel channel : builtinChannels) {
            Number count = (Number)session.createQuery("select count(*) from Channel c where c.internalName = :name").setString("name", channel.getInternalName()).uniqueResult();
            if (count.intValue() != 0) continue;
            session.save((Object)channel);
        }
    }

    public static void createSettings(Session session, ResourceBundle bundle, Locale locale, Properties cyclosProperties) {
        CreateBasicData.createSetting(session, Setting.Type.LOCAL, "charset", "UTF-8");
        CreateBasicData.createSetting(session, Setting.Type.LOCAL, "language", LocaleConverter.instance().toString(locale));
        CreateBasicData.createSetting(session, Setting.Type.LOCAL, "applicationUsername", bundle.getString("settings.local.application-name"));
        CreateBasicData.createSetting(session, Setting.Type.LOCAL, "defaultExternalPaymentDescription", bundle.getString("settings.local.default-external-payment-description"));
        CreateBasicData.createSetting(session, Setting.Type.LOCAL, "chargebackDescription", bundle.getString("settings.local.chargeback-description"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "invitationSubject", bundle.getString("settings.mail.invitation.subject"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "invitationMessage", bundle.getString("settings.mail.invitation.message"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "activationSubject", bundle.getString("settings.mail.activation.subject"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "activationMessageWithoutPassword", bundle.getString("settings.mail.activationWithoutPassword.message"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "activationMessageWithPassword", bundle.getString("settings.mail.activationWithPassword.message"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "resetPasswordSubject", bundle.getString("settings.mail.reset-password.subject"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "resetPasswordMessage", bundle.getString("settings.mail.reset-password.message"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "mailValidationSubject", bundle.getString("settings.mail.mail-validation.subject"));
        CreateBasicData.createSetting(session, Setting.Type.MAIL_TRANSLATION, "mailValidationMessage", bundle.getString("settings.mail.mail-validation.message"));
        for (MessageSettings.MessageSettingsEnum messageSetting : MessageSettings.MessageSettingsEnum.values()) {
            if (messageSetting.messageSettingKey() != null) {
                try {
                    String body = bundle.getString(messageSetting.messageSettingKey());
                    CreateBasicData.createSetting(session, Setting.Type.MESSAGE, messageSetting.messageSettingName(), body);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (messageSetting.subjectSettingKey() != null) {
                try {
                    String subject = bundle.getString(messageSetting.subjectSettingKey());
                    CreateBasicData.createSetting(session, Setting.Type.MESSAGE, messageSetting.subjectSettingName(), subject);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (messageSetting.smsSettingKey() == null) continue;
            try {
                String sms = bundle.getString(messageSetting.smsSettingKey());
                CreateBasicData.createSetting(session, Setting.Type.MESSAGE, messageSetting.smsSettingName(), sms);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String defaultLogDir = cyclosProperties.getProperty("cyclos.default.logDir", "%t");
        String defaultLogPrefix = cyclosProperties.getProperty("cyclos.default.logPrefix", "cyclos_");
        CreateBasicData.createSetting(session, Setting.Type.LOG, "traceFile", defaultLogDir + "/" + defaultLogPrefix + "trace%g.log");
        CreateBasicData.createSetting(session, Setting.Type.LOG, "transactionFile", defaultLogDir + "/" + defaultLogPrefix + "transactions%g.log");
        CreateBasicData.createSetting(session, Setting.Type.LOG, "accountFeeFile", defaultLogDir + "/" + defaultLogPrefix + "account_fees%g.log");
        CreateBasicData.createSetting(session, Setting.Type.LOG, "scheduledTaskFile", defaultLogDir + "/" + defaultLogPrefix + "scheduled_task%g.log");
        CreateBasicData.createSetting(session, Setting.Type.LOG, "webServiceFile", defaultLogDir + "/" + defaultLogPrefix + "webservices%g.log");
        CreateBasicData.createSetting(session, Setting.Type.LOG, "restFile", defaultLogDir + "/" + defaultLogPrefix + "rest%g.log");
    }

    public static List<Channel> getBuiltinChannels(ResourceBundle bundle) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        channels.add(CreateBasicData.buildChannel(bundle, "web", Channel.Principal.USER, Channel.Credentials.DEFAULT));
        channels.add(CreateBasicData.buildChannel(bundle, "rest", Channel.Principal.USER, Channel.Credentials.DEFAULT));
        channels.add(CreateBasicData.buildChannel(bundle, "wap2", Channel.Principal.USER, Channel.Credentials.DEFAULT));
        channels.add(CreateBasicData.buildChannel(bundle, "wap1", Channel.Principal.USER, Channel.Credentials.DEFAULT));
        channels.add(CreateBasicData.buildChannel(bundle, "webshop", Channel.Principal.USER, Channel.Credentials.DEFAULT));
        channels.add(CreateBasicData.buildChannel(bundle, "posweb", Channel.Principal.USER, Channel.Credentials.PIN));
        channels.add(CreateBasicData.buildChannel(bundle, "pos", Channel.Principal.USER, Channel.Credentials.PIN));
        return channels;
    }

    public static List<SmsType> getBuiltinSmsTypes(ResourceBundle bundle) {
        ArrayList<SmsType> smsTypes = new ArrayList<SmsType>();
        try {
            for (SmsTypeCode smsTypeCode : SmsTypeCode.values()) {
                smsTypes.add(CreateBasicData.buildSmsType(bundle, smsTypeCode));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return smsTypes;
    }

    private static Channel buildChannel(ResourceBundle resourceBundle, String internalName, Channel.Principal principal, Channel.Credentials credentials) {
        Channel channel = new Channel();
        channel.setInternalName(internalName);
        channel.setDisplayName(resourceBundle.getString("channel." + internalName));
        channel.setCredentials(credentials);
        ChannelPrincipal cp = new ChannelPrincipal();
        cp.setChannel(channel);
        cp.setPrincipal(principal);
        channel.setPrincipals(Collections.singleton(cp));
        return channel;
    }

    private static SmsType buildSmsType(ResourceBundle resourceBundle, SmsTypeCode smsTypeCode) {
        SmsType smsType = new SmsType();
        smsType.setCode(smsTypeCode.code());
        smsType.setOrder(smsTypeCode.ordinal());
        return smsType;
    }

    static void associateGroupToChannel(Channel channel, MemberGroup memberGroup) {
        Collection<Channel> channels = memberGroup.getChannels();
        if (channels == null) {
            channels = new ArrayList<Channel>();
            memberGroup.setChannels(channels);
        }
        channels.add(channel);
        Collection<Channel> defaultChannels = memberGroup.getDefaultChannels();
        if (defaultChannels == null) {
            defaultChannels = new ArrayList<Channel>();
            memberGroup.setDefaultChannels(defaultChannels);
        }
        defaultChannels.add(channel);
    }

    static void createSetting(Session session, Setting.Type type, String name, String value) {
        String newValue = StringUtils.trimToEmpty((String)value);
        Setting setting = (Setting)session.createQuery("from Setting s where s.type=:type and s.name=:name").setParameter("type", (Object)type).setParameter("name", (Object)name).uniqueResult();
        if (setting == null) {
            setting = new Setting();
            setting.setType(type);
            setting.setName(name);
        } else if (StringUtils.isNotEmpty((String)setting.getValue())) {
            return;
        }
        if (!newValue.equals(setting.getValue())) {
            setting.setValue(value);
            session.saveOrUpdate((Object)setting);
        }
    }

    public CreateBasicData(Setup setup, boolean setupOnly) {
        this.setupOnly = setupOnly;
        this.session = setup.getSession();
        this.bundle = setup.getBundle();
        try {
            this.cyclosProperties = CyclosConfiguration.getCyclosProperties();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.locale = setup.getLocale() == null ? Locale.getDefault() : setup.getLocale();
    }

    @Override
    public void run() {
        if (this.session.createCriteria(Application.class).uniqueResult() != null) {
            Setup.out.println(this.bundle.getString("basic-data.error.already"));
            return;
        }
        Setup.out.println(this.bundle.getString("basic-data.start"));
        this.createApplication();
        this.createChannels();
        this.createSmsTypes();
        if (!this.setupOnly) {
            this.createGroups();
            this.createAdministrator();
        }
        CreateBasicData.createSettings(this.session, this.bundle, this.locale, this.cyclosProperties);
        this.session.flush();
        Setup.out.println(this.bundle.getString("basic-data.end"));
    }

    private void associateDefaultChannels(MemberGroup group) {
        this.associateGroupToChannel("web", group);
        this.associateGroupToChannel("rest", group);
        this.associateGroupToChannel("wap2", group);
    }

    private void associateGroupToChannel(String channelStr, MemberGroup memberGroup) {
        Channel channel = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)channelStr)).uniqueResult();
        CreateBasicData.associateGroupToChannel(channel, memberGroup);
    }

    private void createAdministrator() {
        HashHandler hashHandler = new HashHandler();
        AdminUser user = new AdminUser();
        user.setSalt(hashHandler.newSalt());
        user.setUsername("admin");
        user.setPassword(hashHandler.hash(user.getSalt(), "1234"));
        user.setPasswordDate(Calendar.getInstance());
        Administrator administrator = new Administrator();
        administrator.setEmail("admin@mail.nl");
        administrator.setName("Administrator");
        administrator.setCreationDate(Calendar.getInstance());
        administrator.setGroup(this.systemAdmins);
        administrator.setUser(user);
        this.session.save((Object)administrator);
    }

    private void createApplication() {
        Version currentVersion = new VersionHistoryReader().read().getCurrent();
        Application application = new Application();
        application.setVersion(currentVersion.getLabel());
        application.setAccountStatusEnabledSince(Calendar.getInstance());
        application.setPasswordHash(Application.PasswordHash.SHA2_SALT);
        application.setOnline(true);
        this.session.save((Object)application);
    }

    private void createChannels() {
        CreateBasicData.createChannels(this.session, this.bundle);
    }

    private <G extends Group> G createGroup(Class<G> groupClass, Group.Status status, String keyPart, ModuleType ... moduleTypes) {
        Group group = null;
        try {
            group = (Group)groupClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        group.setStatus(status);
        group.setName(this.bundle.getString("group." + keyPart + ".name"));
        group.setDescription(this.bundle.getString("group." + keyPart + ".description"));
        group.getBasicSettings().setPasswordPolicy(BasicGroupSettings.PasswordPolicy.NONE);
        this.session.save((Object)group);
        if (moduleTypes != null && moduleTypes.length > 0) {
            if (group.getPermissions() == null) {
                group.setPermissions(new HashSet<Permission>());
            }
            for (ModuleType moduleType : moduleTypes) {
                for (Module module : moduleType.getModules()) {
                    group.getPermissions().addAll(module.getPermissions());
                }
            }
            this.session.flush();
        }
        return (G)group;
    }

    private void createGroups() {
        this.systemAdmins = this.createGroup(AdminGroup.class, Group.Status.NORMAL, "system-admins", ModuleType.BASIC, ModuleType.ADMIN_SYSTEM, ModuleType.ADMIN_ADMIN, ModuleType.ADMIN_MEMBER);
        this.removeUnwantedAdminPermissions(this.systemAdmins);
        AdminGroup accountAdmins = this.createGroup(AdminGroup.class, Group.Status.NORMAL, "account-admins", ModuleType.BASIC, ModuleType.ADMIN_MEMBER);
        this.removeUnwantedAdminPermissions(accountAdmins);
        this.removeUnwantedAccountAdminPermissions(accountAdmins);
        this.createGroup(AdminGroup.class, Group.Status.NORMAL, "disabled-admins", new ModuleType[0]);
        this.createGroup(AdminGroup.class, Group.Status.REMOVED, "removed-admins", new ModuleType[0]);
        MemberGroup fullMembers = this.createGroup(MemberGroup.class, Group.Status.NORMAL, "full-members", ModuleType.BASIC, ModuleType.MEMBER);
        fullMembers.setActive(true);
        fullMembers.getMemberSettings().setEmailValidation(new HashSet<MemberGroupSettings.EmailValidation>(Arrays.asList(MemberGroupSettings.EmailValidation.USER)));
        this.removeUnwantedMemberPermissions(fullMembers);
        this.associateDefaultChannels(fullMembers);
        MemberGroup inactiveMembers = this.createGroup(MemberGroup.class, Group.Status.NORMAL, "inactive-members", new ModuleType[0]);
        inactiveMembers.setInitialGroup(true);
        MemberGroup disabledMembers = this.createGroup(MemberGroup.class, Group.Status.NORMAL, "disabled-members", new ModuleType[0]);
        MemberGroup removedMembers = this.createGroup(MemberGroup.class, Group.Status.REMOVED, "removed-members", new ModuleType[0]);
        BrokerGroup fullBrokers = this.createGroup(BrokerGroup.class, Group.Status.NORMAL, "full-brokers", ModuleType.BASIC, ModuleType.MEMBER, ModuleType.BROKER);
        fullBrokers.setActive(true);
        this.removeUnwantedMemberPermissions(fullBrokers);
        this.associateDefaultChannels(fullBrokers);
        BrokerGroup disabledBrokers = this.createGroup(BrokerGroup.class, Group.Status.NORMAL, "disabled-brokers", new ModuleType[0]);
        BrokerGroup removedBrokers = this.createGroup(BrokerGroup.class, Group.Status.REMOVED, "removed-brokers", new ModuleType[0]);
        List<MemberGroup> allMemberGroups = Arrays.asList(fullMembers, inactiveMembers, disabledMembers, removedMembers, fullBrokers, disabledBrokers, removedBrokers);
        this.systemAdmins.setManagesGroups(new ArrayList<MemberGroup>(allMemberGroups));
        accountAdmins.setManagesGroups(new ArrayList<MemberGroup>(allMemberGroups));
        this.systemAdmins.setViewConnectedAdminsOf(Arrays.asList(this.systemAdmins, accountAdmins));
        accountAdmins.setViewConnectedAdminsOf(Arrays.asList(this.systemAdmins, accountAdmins));
        fullMembers.setCanViewAdsOfGroups(Arrays.asList(fullMembers, fullBrokers));
        fullMembers.setCanViewProfileOfGroups(Arrays.asList(fullMembers, fullBrokers));
        fullBrokers.setCanViewAdsOfGroups(Arrays.asList(fullMembers, fullBrokers));
        fullBrokers.setCanViewProfileOfGroups(Arrays.asList(fullMembers, fullBrokers));
    }

    private void createSmsTypes() {
        List<SmsType> builtinSmsTypes = CreateBasicData.getBuiltinSmsTypes(this.bundle);
        for (SmsType smsType : builtinSmsTypes) {
            this.session.save((Object)smsType);
        }
    }

    private void removeUnwantedAccountAdminPermissions(AdminGroup group) {
        Iterator<Permission> iterator = group.getPermissions().iterator();
        while (iterator.hasNext()) {
            if (!unwantedAccountAdminPermissions.contains(iterator.next())) continue;
            iterator.remove();
        }
    }

    private void removeUnwantedAdminPermissions(AdminGroup group) {
        Iterator<Permission> iterator = group.getPermissions().iterator();
        while (iterator.hasNext()) {
            if (!unwantedAdminPermissions.contains(iterator.next())) continue;
            iterator.remove();
        }
    }

    private void removeUnwantedMemberPermissions(MemberGroup group) {
        Iterator<Permission> iterator = group.getPermissions().iterator();
        while (iterator.hasNext()) {
            if (!unwantedMemberPermissions.contains(iterator.next())) continue;
            iterator.remove();
        }
    }

    static {
        List<Permission> unwantedAdminPermissionsList = Arrays.asList(BasicPermission.BASIC_INVITE_MEMBER, AdminMemberPermission.ACCESS_DISCONNECT_OPERATOR, AdminMemberPermission.ACCOUNTS_AUTHORIZED_INFORMATION, AdminMemberPermission.GUARANTEES_CANCEL_CERTIFICATIONS_AS_MEMBER, AdminMemberPermission.GUARANTEES_CANCEL_GUARANTEES_AS_MEMBER, AdminMemberPermission.GUARANTEES_ACCEPT_GUARANTEES_AS_MEMBER, AdminMemberPermission.INVOICES_SEND_AS_MEMBER_TO_MEMBER, AdminMemberPermission.INVOICES_SEND_AS_MEMBER_TO_SYSTEM, AdminMemberPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER, AdminMemberPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM, AdminMemberPermission.INVOICES_DENY_AS_MEMBER, AdminMemberPermission.INVOICES_CANCEL_AS_MEMBER, AdminMemberPermission.MEMBERS_CHANGE_USERNAME, AdminMemberPermission.PAYMENTS_AUTHORIZE, AdminMemberPermission.PAYMENTS_PAYMENT_WITH_DATE, AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, AdminMemberPermission.PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, AdminMemberPermission.PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER, AdminMemberPermission.PAYMENTS_CANCEL_SCHEDULED_AS_MEMBER, AdminMemberPermission.PAYMENTS_BLOCK_SCHEDULED_AS_MEMBER, AdminMemberPermission.LOANS_GRANT_WITH_DATE, AdminMemberPermission.LOANS_REPAY_WITH_DATE, AdminMemberPermission.LOANS_VIEW_AUTHORIZED, AdminMemberPermission.BROKERINGS_MANAGE_COMMISSIONS, AdminSystemPermission.ACCOUNTS_AUTHORIZED_INFORMATION, AdminSystemPermission.PAYMENTS_AUTHORIZE, AdminSystemPermission.PAYMENTS_CANCEL, AdminSystemPermission.REPORTS_SMS_LOGS, AdminSystemPermission.STATUS_VIEW_CONNECTED_OPERATORS);
        unwantedAdminPermissions = new ArrayList<Permission>();
        unwantedAdminPermissions.addAll(unwantedAdminPermissionsList);
        unwantedAdminPermissions.addAll(Module.ADMIN_MEMBER_DOCUMENTS.getPermissions());
        unwantedAdminPermissions.addAll(Module.ADMIN_MEMBER_GUARANTEES.getPermissions());
        unwantedAdminPermissions.addAll(Module.ADMIN_MEMBER_POS.getPermissions());
        unwantedAdminPermissions.addAll(Module.ADMIN_MEMBER_SMS.getPermissions());
        unwantedAdminPermissions.addAll(Module.SYSTEM_GUARANTEE_TYPES.getPermissions());
        List<Permission> unwantedMemberPermissionsList = Arrays.asList(BasicPermission.BASIC_INVITE_MEMBER, MemberPermission.PAYMENTS_PAYMENT_TO_SELF, MemberPermission.PAYMENTS_REQUEST, MemberPermission.INVOICES_SEND_TO_SYSTEM, MemberPermission.ACCOUNT_AUTHORIZED_INFORMATION, MemberPermission.PAYMENTS_AUTHORIZE, MemberPermission.PAYMENTS_CANCEL_AUTHORIZED, MemberPermission.PAYMENTS_CANCEL_SCHEDULED, MemberPermission.PREFERENCES_MANAGE_RECEIPT_PRINTER_SETTINGS, BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_MEMBER, BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SELF, BrokerPermission.MEMBER_PAYMENTS_PAYMENT_AS_MEMBER_TO_SYSTEM, BrokerPermission.MEMBER_PAYMENTS_CANCEL_AUTHORIZED_AS_MEMBER, BrokerPermission.MEMBER_PAYMENTS_CANCEL_SCHEDULED_AS_MEMBER, BrokerPermission.MEMBER_PAYMENTS_BLOCK_SCHEDULED_AS_MEMBER, BrokerPermission.INVOICES_SEND_AS_MEMBER_TO_MEMBER, BrokerPermission.INVOICES_SEND_AS_MEMBER_TO_SYSTEM, BrokerPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_MEMBER, BrokerPermission.INVOICES_ACCEPT_AS_MEMBER_FROM_SYSTEM, BrokerPermission.INVOICES_DENY_AS_MEMBER, BrokerPermission.INVOICES_CANCEL_AS_MEMBER, BrokerPermission.MEMBERS_CHANGE_USERNAME, BrokerPermission.MEMBERS_CHANGE_NAME, BrokerPermission.ACCOUNTS_AUTHORIZED_INFORMATION);
        unwantedMemberPermissions = new ArrayList<Permission>();
        unwantedMemberPermissions.addAll(unwantedMemberPermissionsList);
        unwantedMemberPermissions.addAll(Module.MEMBER_DOCUMENTS.getPermissions());
        unwantedMemberPermissions.addAll(Module.MEMBER_GUARANTEES.getPermissions());
        unwantedMemberPermissions.addAll(Module.MEMBER_OPERATORS.getPermissions());
        unwantedMemberPermissions.addAll(Module.MEMBER_SMS.getPermissions());
        unwantedMemberPermissions.addAll(Module.BROKER_DOCUMENTS.getPermissions());
        unwantedMemberPermissions.addAll(Module.BROKER_MEMBER_SMS.getPermissions());
    }
}

