/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.AccountLock;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.MemberGroupAccountSettings;
import nl.strohalm.cyclos.entities.accounts.SystemAccount;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.fees.account.AccountFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.SimpleTransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.loans.Loan;
import nl.strohalm.cyclos.entities.accounts.loans.LoanParameters;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.Validation;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.entities.members.messages.MessageCategory;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.setup.Setup;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.TimePeriod;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CreateInitialData
implements Runnable {
    private final ResourceBundle bundle;
    private Currency units;
    private SystemAccountType community;
    private SystemAccountType debit;
    private MemberAccountType member;
    private SystemAccountType organization;
    private final Session session;
    private final Map<String, AccountType> systemTypes;
    private SystemAccountType voucher;
    private TransferType trade;
    private TransferType mobileTrade;
    private TransferType externalTrade;
    private TransferType liquidityTaxPayment;
    private TransferType contributionPayment;
    private TransferType transactionTaxPayment;
    private TransferType brokerCommissionPayment;
    private TransferType initialCredit;
    private TransferType loan;
    private TransferType loanRepayment;
    private TransferType moneyConversion;
    private Collection<TransferType> systemToSystem;
    private Collection<TransferType> systemToMember;
    private Collection<TransferType> memberToSystem;
    private Collection<TransferType> memberVoucher;
    private Collection<TransferType> memberDebit;
    private Collection<TransferType> memberCommunity;
    private Collection<TransferType> memberOrganization;
    private Collection<TransferType> debitCommunity;
    private Collection<TransferType> debitOrganization;
    private Collection<TransferType> debitVoucher;
    private Collection<TransferType> organizationVaucher;
    private Collection<TransferType> organizationCommunity;
    private Collection<TransferType> communityVaucher;
    private AdminGroup systemAdmins;
    private AdminGroup accountAdmins;
    private MemberGroup fullMembers;
    private MemberGroup inactiveMembers;
    private MemberGroup demoMembers;
    private BrokerGroup fullBrokers;
    private Collection<AdminGroup> enabledAdminGroups;
    private Collection<MemberGroup> enabledMemberGroups;

    public CreateInitialData(Setup setup) {
        this.session = setup.getSession();
        this.bundle = setup.getBundle();
        this.systemTypes = new LinkedHashMap<String, AccountType>();
    }

    @Override
    public void run() {
        Setup.out.println(this.bundle.getString("initial-data.start"));
        this.session.clear();
        this.systemAdmins = (AdminGroup)this.session.createCriteria(AdminGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.system-admins.name"))).uniqueResult();
        this.accountAdmins = (AdminGroup)this.session.createCriteria(AdminGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.account-admins.name"))).uniqueResult();
        this.fullMembers = (MemberGroup)this.session.createCriteria(MemberGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.full-members.name"))).uniqueResult();
        this.inactiveMembers = (MemberGroup)this.session.createCriteria(MemberGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.inactive-members.name"))).uniqueResult();
        this.fullBrokers = (BrokerGroup)this.session.createCriteria(BrokerGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.full-brokers.name"))).uniqueResult();
        this.enabledAdminGroups = Arrays.asList(this.systemAdmins, this.accountAdmins);
        this.enabledMemberGroups = Arrays.asList(this.fullMembers, this.fullBrokers);
        this.createCurrencies();
        this.createSystemAccountTypes();
        this.createMemberAccountTypes();
        this.createSystemAccounts();
        this.createTransferTypes();
        this.createFees();
        this.createAccountFees();
        this.createPaymentFilters();
        this.createMemberAccountSettings();
        this.createExampleAdCategory();
        this.createExampleMessageCategory();
        this.createCustomFields();
        this.createRemarks();
        this.session.flush();
        Setup.out.println(this.bundle.getString("initial-data.end"));
    }

    private void addPossibleValues(CustomField field, String ... keys) {
        for (String key : keys) {
            CustomFieldPossibleValue pv = new CustomFieldPossibleValue();
            pv.setField(field);
            pv.setValue(this.bundle.getString(key));
            this.session.save((Object)pv);
        }
    }

    private void associateTransferTypeToGroups(TransferType transferType, Collection<MemberGroup> memberGroups) {
        for (MemberGroup memberGroup : memberGroups) {
            memberGroup.getTransferTypes().add(transferType);
        }
    }

    private void createAccountFees() {
        AccountFee contribution = new AccountFee();
        contribution.setName(this.bundle.getString("tax.contribution.name"));
        contribution.setDescription(this.bundle.getString("tax.contribution.description"));
        contribution.setAccountType(this.member);
        contribution.setChargeMode(AccountFee.ChargeMode.FIXED);
        contribution.setPaymentDirection(AccountFee.PaymentDirection.TO_SYSTEM);
        contribution.setAmount(new BigDecimal(5));
        contribution.setRunMode(AccountFee.RunMode.SCHEDULED);
        contribution.setRecurrence(new TimePeriod(1, TimePeriod.Field.MONTHS));
        contribution.setEnabled(false);
        contribution.setDay((byte)1);
        contribution.setHour((byte)3);
        contribution.setInvoiceMode(AccountFee.InvoiceMode.NOT_ENOUGH_CREDITS);
        contribution.setTransferType(this.contributionPayment);
        contribution.setGroups(new HashSet<MemberGroup>(this.enabledMemberGroups));
        this.session.save((Object)contribution);
        AccountFee liquidity = new AccountFee();
        liquidity.setName(this.bundle.getString("tax.liquidity.name"));
        liquidity.setDescription(this.bundle.getString("tax.liquidity.description"));
        liquidity.setAccountType(this.member);
        liquidity.setChargeMode(AccountFee.ChargeMode.VOLUME_PERCENTAGE);
        liquidity.setPaymentDirection(AccountFee.PaymentDirection.TO_SYSTEM);
        liquidity.setAmount(new BigDecimal(1));
        liquidity.setRunMode(AccountFee.RunMode.SCHEDULED);
        liquidity.setRecurrence(new TimePeriod(1, TimePeriod.Field.MONTHS));
        liquidity.setEnabled(false);
        liquidity.setDay((byte)1);
        liquidity.setHour((byte)1);
        liquidity.setInvoiceMode(AccountFee.InvoiceMode.NEVER);
        liquidity.setTransferType(this.liquidityTaxPayment);
        liquidity.setGroups(new HashSet<MemberGroup>(this.enabledMemberGroups));
        this.session.save((Object)liquidity);
    }

    private void createCurrencies() {
        this.units = new Currency();
        this.units.setName("Units");
        this.units.setPattern("#amount# units");
        this.units.setSymbol("units");
        this.session.save((Object)this.units);
    }

    private void createCustomFields() {
        List<MemberGroup> memberGroups = Arrays.asList(this.fullMembers, this.demoMembers, this.inactiveMembers, this.fullBrokers);
        MemberCustomField birthday = new MemberCustomField();
        birthday.setName(this.bundle.getString("field.birthday"));
        birthday.setInternalName("birthday");
        birthday.setControl(CustomField.Control.TEXT);
        birthday.setSize(CustomField.Size.SMALL);
        birthday.setType(CustomField.Type.DATE);
        birthday.setMemberCanHide(true);
        birthday.setOrder(0);
        birthday.setIndexing(MemberCustomField.Indexing.NONE);
        birthday.setShowInPrint(true);
        birthday.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)birthday);
        MemberCustomField gender = new MemberCustomField();
        gender.setName(this.bundle.getString("field.gender"));
        gender.setInternalName("gender");
        gender.setControl(CustomField.Control.RADIO);
        gender.setSize(CustomField.Size.LARGE);
        gender.setType(CustomField.Type.ENUMERATED);
        gender.setMemberCanHide(true);
        gender.setOrder(1);
        gender.setShowInPrint(true);
        gender.setGroups(new ArrayList<MemberGroup>(memberGroups));
        gender.setIndexing(MemberCustomField.Indexing.NONE);
        this.session.save((Object)gender);
        this.addPossibleValues(gender, "field.gender.male", "field.gender.female");
        MemberCustomField address = new MemberCustomField();
        address.setName(this.bundle.getString("field.address"));
        address.setInternalName("address");
        address.setControl(CustomField.Control.TEXT);
        address.setSize(CustomField.Size.LARGE);
        address.setType(CustomField.Type.STRING);
        address.setMemberCanHide(true);
        address.setOrder(2);
        address.setIndexing(MemberCustomField.Indexing.MEMBERS_AND_ADS);
        address.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)address);
        MemberCustomField postalCode = new MemberCustomField();
        postalCode.setName(this.bundle.getString("field.postalCode"));
        postalCode.setInternalName("postalCode");
        postalCode.setControl(CustomField.Control.TEXT);
        postalCode.setSize(CustomField.Size.LARGE);
        postalCode.setType(CustomField.Type.STRING);
        postalCode.setMemberCanHide(true);
        postalCode.setOrder(3);
        postalCode.setIndexing(MemberCustomField.Indexing.NONE);
        postalCode.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)postalCode);
        MemberCustomField city = new MemberCustomField();
        city.setName(this.bundle.getString("field.city"));
        city.setInternalName("city");
        city.setControl(CustomField.Control.TEXT);
        city.setSize(CustomField.Size.LARGE);
        city.setType(CustomField.Type.STRING);
        city.setMemberCanHide(true);
        city.setOrder(4);
        city.setIndexing(MemberCustomField.Indexing.MEMBERS_AND_ADS);
        city.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)city);
        MemberCustomField area = new MemberCustomField();
        area.setName(this.bundle.getString("field.area"));
        area.setInternalName("area");
        area.setControl(CustomField.Control.SELECT);
        area.setType(CustomField.Type.ENUMERATED);
        area.setMemberCanHide(true);
        area.setOrder(5);
        area.setGroups(new ArrayList<MemberGroup>(memberGroups));
        area.setIndexing(MemberCustomField.Indexing.MEMBERS_AND_ADS);
        this.session.save((Object)area);
        this.addPossibleValues(area, "area.name");
        MemberCustomField phone = new MemberCustomField();
        phone.setName(this.bundle.getString("field.phone"));
        phone.setInternalName("phone");
        phone.setControl(CustomField.Control.TEXT);
        phone.setSize(CustomField.Size.LARGE);
        phone.setType(CustomField.Type.STRING);
        phone.setMemberCanHide(true);
        phone.setOrder(6);
        phone.setIndexing(MemberCustomField.Indexing.NONE);
        phone.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)phone);
        MemberCustomField mobilePhone = new MemberCustomField();
        mobilePhone.setName(this.bundle.getString("field.mobilePhone"));
        mobilePhone.setInternalName("mobilePhone");
        mobilePhone.setControl(CustomField.Control.TEXT);
        mobilePhone.setSize(CustomField.Size.LARGE);
        mobilePhone.setType(CustomField.Type.STRING);
        mobilePhone.setMemberCanHide(true);
        mobilePhone.setOrder(7);
        mobilePhone.setIndexing(MemberCustomField.Indexing.NONE);
        mobilePhone.setGroups(new ArrayList<MemberGroup>(memberGroups));
        mobilePhone.setValidation(new Validation(false, true));
        this.session.save((Object)mobilePhone);
        MemberCustomField fax = new MemberCustomField();
        fax.setName(this.bundle.getString("field.fax"));
        fax.setInternalName("fax");
        fax.setControl(CustomField.Control.TEXT);
        fax.setSize(CustomField.Size.LARGE);
        fax.setType(CustomField.Type.STRING);
        fax.setMemberCanHide(true);
        fax.setOrder(8);
        fax.setIndexing(MemberCustomField.Indexing.NONE);
        fax.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)fax);
        MemberCustomField url = new MemberCustomField();
        url.setName(this.bundle.getString("field.url"));
        url.setInternalName("url");
        url.setControl(CustomField.Control.TEXT);
        url.setSize(CustomField.Size.LARGE);
        url.setType(CustomField.Type.URL);
        url.setMemberCanHide(true);
        url.setOrder(9);
        url.setIndexing(MemberCustomField.Indexing.NONE);
        url.setGroups(new ArrayList<MemberGroup>(memberGroups));
        this.session.save((Object)url);
        PaymentCustomField loanIdentifier = new PaymentCustomField();
        loanIdentifier.setTransferType(this.loan);
        loanIdentifier.setName(this.bundle.getString("field.loanIdentifier"));
        loanIdentifier.setInternalName("identifier");
        loanIdentifier.setControl(CustomField.Control.TEXT);
        loanIdentifier.setSize(CustomField.Size.SMALL);
        loanIdentifier.setType(CustomField.Type.STRING);
        loanIdentifier.setSearchAccess(PaymentCustomField.Access.FROM_ACCOUNT);
        loanIdentifier.setOrder(0);
        this.session.save((Object)loanIdentifier);
    }

    private void createExampleAdCategory() {
        AdCategory category = new AdCategory();
        category.setActive(true);
        category.setName(this.bundle.getString("ad-category.name"));
        this.session.save((Object)category);
    }

    private void createExampleMessageCategory() {
        ArrayList<MessageCategory> allCategories = new ArrayList<MessageCategory>();
        MessageCategory support = new MessageCategory();
        support.setName(this.bundle.getString("message-category.support.name"));
        this.session.save((Object)support);
        allCategories.add(support);
        MessageCategory administration = new MessageCategory();
        administration.setName(this.bundle.getString("message-category.administration.name"));
        this.session.save((Object)administration);
        allCategories.add(administration);
        MessageCategory loanRequest = new MessageCategory();
        loanRequest.setName(this.bundle.getString("message-category.loan-request.name"));
        this.session.save((Object)loanRequest);
        allCategories.add(loanRequest);
        this.systemAdmins.setMessageCategories(new ArrayList<MessageCategory>(allCategories));
        this.accountAdmins.setMessageCategories(new ArrayList<MessageCategory>(allCategories));
        this.fullMembers.setMessageCategories(new ArrayList<MessageCategory>(allCategories));
        this.fullBrokers.setMessageCategories(new ArrayList<MessageCategory>(allCategories));
    }

    private void createFees() {
        SimpleTransactionFee transactionTax = new SimpleTransactionFee();
        transactionTax.setName(this.bundle.getString("fee.transaction-tax.name"));
        transactionTax.setDescription(this.bundle.getString("fee.transaction-tax.description"));
        transactionTax.setOriginalTransferType(this.trade);
        transactionTax.setGeneratedTransferType(this.transactionTaxPayment);
        transactionTax.setAmount(Amount.fixed(new BigDecimal(5)));
        transactionTax.setEnabled(false);
        transactionTax.setPayer(TransactionFee.Subject.SOURCE);
        transactionTax.setReceiver(TransactionFee.Subject.SYSTEM);
        this.session.save((Object)transactionTax);
        BrokerCommission brokerCommission = new BrokerCommission();
        brokerCommission.setName(this.bundle.getString("fee.broker-commission.name"));
        brokerCommission.setDescription(this.bundle.getString("fee.broker-commission.description"));
        brokerCommission.setOriginalTransferType(this.trade);
        brokerCommission.setGeneratedTransferType(this.brokerCommissionPayment);
        brokerCommission.setAmount(Amount.percentage(new BigDecimal(2.5)));
        brokerCommission.setEnabled(false);
        brokerCommission.setPayer(TransactionFee.Subject.SYSTEM);
        brokerCommission.setWhichBroker(BrokerCommission.WhichBroker.SOURCE);
        brokerCommission.setWhen(BrokerCommission.When.COUNT);
        brokerCommission.setCount(20);
        this.session.save((Object)brokerCommission);
    }

    private void createMemberAccountSettings() {
        MemberGroupAccountSettings mgas = new MemberGroupAccountSettings();
        for (MemberGroup group : this.enabledMemberGroups) {
            mgas = new MemberGroupAccountSettings();
            mgas.setAccountType(this.member);
            mgas.setDefault(true);
            mgas.setDefaultCreditLimit(BigDecimal.ZERO);
            mgas.setGroup(group);
            mgas.setInitialCreditTransferType(this.initialCredit);
            mgas.setInitialCredit(BigDecimal.ZERO);
            mgas.setLowUnits(new BigDecimal(20));
            mgas.setLowUnitsMessage(this.bundle.getString("account.member.low-units"));
            this.session.save((Object)mgas);
        }
    }

    private void createMemberAccountTypes() {
        this.member = new MemberAccountType();
        this.member.setCurrency(this.units);
        this.member.setName(this.bundle.getString("account.member.name"));
        this.member.setDescription(this.bundle.getString("account.member.description"));
        this.session.save((Object)this.member);
    }

    private void createPaymentFilter(AccountType accountType, String key, Object ... arguments) {
        PaymentFilter filter = new PaymentFilter();
        filter.setAccountType(accountType);
        String name = this.bundle.getString("payment-filter." + key);
        filter.setName(name);
        filter.setDescription(name);
        filter.setShowInAccountHistory(true);
        filter.setShowInReports(true);
        HashSet<TransferType> transferTypes = new HashSet<TransferType>();
        for (Object object : arguments) {
            if (object instanceof TransferType) {
                transferTypes.add((TransferType)object);
                continue;
            }
            if (object instanceof Collection) {
                transferTypes.addAll((Collection)object);
                continue;
            }
            throw new IllegalArgumentException("Invalid argument passed to createPaymentFilter: " + object);
        }
        filter.setTransferTypes(transferTypes);
        HashSet<SystemGroup> groups = new HashSet<SystemGroup>();
        if (accountType instanceof SystemAccountType) {
            groups.addAll(this.enabledAdminGroups);
        } else {
            groups.addAll(this.enabledMemberGroups);
        }
        filter.setGroups(groups);
        this.session.save((Object)filter);
    }

    private void createPaymentFilters() {
        this.createPaymentFilter(this.member, "member-payments", this.trade, this.mobileTrade, this.externalTrade);
        this.createPaymentFilter(this.member, "member-loans", this.loan, this.loanRepayment);
        this.createPaymentFilter(this.member, "member-fees", this.liquidityTaxPayment, this.contributionPayment, this.transactionTaxPayment);
        this.createPaymentFilter(this.member, "member-commission", this.brokerCommissionPayment);
        this.createPaymentFilter(this.member, "member-voucher", this.memberVoucher);
        this.createPaymentFilter(this.member, "member-system", this.memberToSystem);
        this.createPaymentFilter(this.debit, "debit-community", this.debitCommunity);
        this.createPaymentFilter(this.debit, "debit-voucher", this.debitVoucher);
        this.createPaymentFilter(this.debit, "debit-organization", this.debitOrganization);
        this.createPaymentFilter(this.debit, "debit-member", this.memberDebit);
        this.createPaymentFilter(this.community, "community-voucher", this.communityVaucher);
        this.createPaymentFilter(this.community, "community-debit", this.debitCommunity);
        this.createPaymentFilter(this.community, "community-organization", this.organizationCommunity);
        this.createPaymentFilter(this.community, "community-contribution", this.contributionPayment);
        this.createPaymentFilter(this.community, "community-liquidity", this.liquidityTaxPayment);
        this.createPaymentFilter(this.community, "community-broker", this.brokerCommissionPayment);
        this.createPaymentFilter(this.community, "community-loan", this.loan, this.loanRepayment);
        this.createPaymentFilter(this.community, "community-member", this.memberCommunity);
        this.createPaymentFilter(this.voucher, "voucher-debit", this.debitVoucher);
        this.createPaymentFilter(this.voucher, "voucher-community", this.communityVaucher);
        this.createPaymentFilter(this.voucher, "voucher-organization", this.organizationVaucher);
        this.createPaymentFilter(this.voucher, "voucher-member", this.memberVoucher);
        this.createPaymentFilter(this.organization, "organization-debit", this.debitOrganization);
        this.createPaymentFilter(this.organization, "organization-community", this.organizationCommunity);
        this.createPaymentFilter(this.organization, "organization-voucher", this.organizationVaucher);
        this.createPaymentFilter(this.organization, "organization-member", this.memberOrganization);
    }

    private MemberRecordType createRemarks() {
        List allGroups = this.session.createCriteria(Group.class).list();
        MemberRecordType memberRecordType = new MemberRecordType();
        memberRecordType.setName(this.bundle.getString("remarks.name"));
        memberRecordType.setLabel(this.bundle.getString("remarks.label"));
        memberRecordType.setDescription(this.bundle.getString("remarks.description"));
        memberRecordType.setGroups(allGroups);
        memberRecordType.setViewableByAdminGroups(this.enabledAdminGroups);
        memberRecordType.setViewableByBrokerGroups(Collections.singletonList(this.fullBrokers));
        memberRecordType.setLayout(MemberRecordType.Layout.FLAT);
        memberRecordType.setShowMenuItem(true);
        this.session.save((Object)memberRecordType);
        this.systemAdmins.getViewAdminRecordTypes().add(memberRecordType);
        this.systemAdmins.getCreateAdminRecordTypes().add(memberRecordType);
        this.systemAdmins.getViewMemberRecordTypes().add(memberRecordType);
        this.systemAdmins.getCreateMemberRecordTypes().add(memberRecordType);
        this.accountAdmins.getViewMemberRecordTypes().add(memberRecordType);
        this.accountAdmins.getCreateMemberRecordTypes().add(memberRecordType);
        this.fullBrokers.getBrokerMemberRecordTypes().add(memberRecordType);
        this.fullBrokers.getBrokerCreateMemberRecordTypes().add(memberRecordType);
        MemberRecordCustomField commentsField = new MemberRecordCustomField();
        commentsField.setName(this.bundle.getString("remarks.comments"));
        commentsField.setInternalName(this.bundle.getString("remarks.comments.internalName"));
        commentsField.setDescription(this.bundle.getString("remarks.comments.description"));
        commentsField.setType(CustomField.Type.STRING);
        commentsField.setControl(CustomField.Control.TEXTAREA);
        commentsField.setSize(CustomField.Size.FULL);
        commentsField.setShowInList(true);
        commentsField.setValidation(new Validation(true));
        commentsField.setOrder(0);
        commentsField.setMemberRecordType(memberRecordType);
        commentsField.setBrokerAccess(MemberRecordCustomField.Access.EDITABLE);
        this.session.save((Object)commentsField);
        return memberRecordType;
    }

    private SystemAccount createSystemAccount(SystemAccountType type) {
        SystemAccount account = new SystemAccount();
        account.setCreditLimit(type.getCreditLimit());
        account.setCreationDate(Calendar.getInstance());
        account.setType(type);
        account.setOwnerName(type.getName());
        this.session.save((Object)account);
        this.session.save((Object)new AccountLock(account));
        type.setAccount(account);
        return account;
    }

    private void createSystemAccounts() {
        this.createSystemAccount(this.debit);
        this.createSystemAccount(this.community);
        this.createSystemAccount(this.voucher);
        this.createSystemAccount(this.organization);
    }

    private void createSystemAccountTypes() {
        this.debit = new SystemAccountType();
        this.debit.setCreditLimit(null);
        this.debit.setName(this.bundle.getString("account.debit.name"));
        this.debit.setDescription(this.bundle.getString("account.debit.description"));
        this.debit.setCurrency(this.units);
        this.session.save((Object)this.debit);
        this.systemTypes.put("debit", this.debit);
        this.community = new SystemAccountType();
        this.community.setCurrency(this.units);
        this.community.setName(this.bundle.getString("account.community.name"));
        this.community.setDescription(this.bundle.getString("account.community.description"));
        this.community.setCreditLimit(BigDecimal.ZERO);
        this.session.save((Object)this.community);
        this.systemTypes.put("community", this.community);
        this.voucher = new SystemAccountType();
        this.voucher.setCurrency(this.units);
        this.voucher.setName(this.bundle.getString("account.voucher.name"));
        this.voucher.setDescription(this.bundle.getString("account.voucher.description"));
        this.voucher.setCreditLimit(BigDecimal.ZERO);
        this.session.save((Object)this.voucher);
        this.systemTypes.put("voucher", this.voucher);
        this.organization = new SystemAccountType();
        this.organization.setCurrency(this.units);
        this.organization.setName(this.bundle.getString("account.organization.name"));
        this.organization.setDescription(this.bundle.getString("account.organization.description"));
        this.organization.setCreditLimit(BigDecimal.ZERO);
        this.session.save((Object)this.organization);
        this.systemTypes.put("organization", this.organization);
        List allSystemAccountTypes = this.session.createCriteria(SystemAccountType.class).list();
        this.systemAdmins.setViewInformationOf(new ArrayList<SystemAccountType>(allSystemAccountTypes));
        this.accountAdmins.setViewInformationOf(new ArrayList<SystemAccountType>(allSystemAccountTypes));
    }

    private void createTransferTypes() {
        AccountType from;
        Channel web = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"web")).uniqueResult();
        this.memberDebit = new ArrayList<TransferType>();
        this.memberCommunity = new ArrayList<TransferType>();
        this.memberOrganization = new ArrayList<TransferType>();
        this.memberVoucher = new ArrayList<TransferType>();
        this.debitCommunity = new ArrayList<TransferType>();
        this.debitOrganization = new ArrayList<TransferType>();
        this.debitVoucher = new ArrayList<TransferType>();
        this.organizationVaucher = new ArrayList<TransferType>();
        this.organizationCommunity = new ArrayList<TransferType>();
        this.communityVaucher = new ArrayList<TransferType>();
        this.systemToSystem = new ArrayList<TransferType>();
        for (Map.Entry<String, AccountType> fromEntry : this.systemTypes.entrySet()) {
            String fromName = fromEntry.getKey();
            from = fromEntry.getValue();
            for (Map.Entry<String, AccountType> toEntry : this.systemTypes.entrySet()) {
                String toName = toEntry.getKey();
                AccountType to = toEntry.getValue();
                if (from.equals(to)) continue;
                TransferType tt = new TransferType();
                tt.setName(this.bundle.getString("transfer-type." + fromName + "-" + toName + ".name"));
                tt.setDescription(this.bundle.getString("transfer-type." + fromName + "-" + toName + ".description"));
                tt.getContext().setSelfPayment(true);
                tt.setFrom(from);
                tt.setTo(to);
                this.session.save((Object)tt);
                this.systemAdmins.getTransferTypes().add(tt);
                this.systemToSystem.add(tt);
                if (from == this.debit && to == this.community || from == this.community && to == this.debit) {
                    this.debitCommunity.add(tt);
                    continue;
                }
                if (from == this.debit && to == this.voucher || from == this.voucher && to == this.debit) {
                    this.debitVoucher.add(tt);
                    continue;
                }
                if (from == this.debit && to == this.organization || from == this.organization && to == this.debit) {
                    this.debitOrganization.add(tt);
                    continue;
                }
                if (from == this.organization && to == this.voucher || from == this.voucher && to == this.organization) {
                    this.organizationVaucher.add(tt);
                    continue;
                }
                if (from == this.organization && to == this.community || from == this.community && to == this.organization) {
                    this.organizationCommunity.add(tt);
                    continue;
                }
                if ((from != this.community || to != this.voucher) && (from != this.voucher || to != this.community)) continue;
                this.communityVaucher.add(tt);
            }
        }
        this.trade = new TransferType();
        this.trade.setName(this.bundle.getString("transfer-type.trade.name"));
        this.trade.setDescription(this.bundle.getString("transfer-type.trade.description"));
        this.trade.getContext().setPayment(true);
        this.trade.setFrom(this.member);
        this.trade.setTo(this.member);
        this.trade.setMaxAmountPerDay(new BigDecimal(1000));
        this.trade.setChannels(Collections.singletonList(web));
        this.trade.setAllowsScheduledPayments(true);
        this.setFeedbackParameters(this.trade);
        this.session.save((Object)this.trade);
        this.associateTransferTypeToGroups(this.trade, this.enabledMemberGroups);
        this.systemToMember = new ArrayList<TransferType>();
        for (Map.Entry<String, AccountType> entry : this.systemTypes.entrySet()) {
            String name = entry.getKey();
            from = entry.getValue();
            TransferType tt = new TransferType();
            tt.setName(this.bundle.getString("transfer-type." + name + "-member.name"));
            tt.setDescription(this.bundle.getString("transfer-type." + name + "-member.description"));
            tt.getContext().setPayment(true);
            tt.setFrom(from);
            tt.setTo(this.member);
            tt.setChannels(Collections.singletonList(web));
            this.session.save((Object)tt);
            this.systemAdmins.getTransferTypes().add(tt);
            this.systemToMember.add(tt);
            if (from == this.debit) {
                this.memberDebit.add(tt);
                continue;
            }
            if (from == this.community) {
                this.memberCommunity.add(tt);
                continue;
            }
            if (from == this.organization) {
                this.memberOrganization.add(tt);
                continue;
            }
            if (from != this.voucher) continue;
            this.memberVoucher.add(tt);
        }
        LinkedHashMap<String, AccountType> toSystem = new LinkedHashMap<String, AccountType>(this.systemTypes);
        toSystem.remove("debit");
        this.memberToSystem = new ArrayList<TransferType>();
        for (Map.Entry entry : toSystem.entrySet()) {
            String name = (String)entry.getKey();
            AccountType to = (AccountType)entry.getValue();
            TransferType tt = new TransferType();
            tt.setName(this.bundle.getString("transfer-type.member-" + name + ".name"));
            tt.setDescription(this.bundle.getString("transfer-type.member-" + name + ".description"));
            tt.getContext().setPayment(true);
            tt.setFrom(this.member);
            tt.setTo(to);
            tt.setChannels(Collections.singletonList(web));
            this.session.save((Object)tt);
            this.associateTransferTypeToGroups(tt, this.enabledMemberGroups);
            this.memberToSystem.add(tt);
            if (to == this.community) {
                this.memberCommunity.add(tt);
                continue;
            }
            if (to == this.organization) {
                this.memberOrganization.add(tt);
                continue;
            }
            if (to != this.voucher) continue;
            this.memberVoucher.add(tt);
        }
        this.loanRepayment = new TransferType();
        this.loanRepayment.setName(this.bundle.getString("transfer-type.loan-repayment.name"));
        this.loanRepayment.setDescription(this.bundle.getString("transfer-type.loan-repayment.description"));
        this.loanRepayment.setFrom(this.member);
        this.loanRepayment.setTo(this.debit);
        this.session.save((Object)this.loanRepayment);
        this.loan = new TransferType();
        this.loan.setName(this.bundle.getString("transfer-type.loan.name"));
        this.loan.setDescription(this.bundle.getString("transfer-type.loan.description"));
        this.loan.setFrom(this.debit);
        this.loan.setTo(this.member);
        this.loan.setContext(TransferType.Context.payment());
        LoanParameters loanParameters = new LoanParameters();
        this.loan.setLoan(loanParameters);
        loanParameters.setType(Loan.Type.SINGLE_PAYMENT);
        loanParameters.setRepaymentType(this.loanRepayment);
        loanParameters.setRepaymentDays(30);
        this.session.save((Object)this.loan);
        this.systemAdmins.getTransferTypes().add(this.loan);
        this.memberDebit.add(this.loan);
        this.initialCredit = new TransferType();
        this.initialCredit.setName(this.bundle.getString("transfer-type.initial-credit.name"));
        this.initialCredit.setDescription(this.bundle.getString("transfer-type.initial-credit.description"));
        this.initialCredit.setFrom(this.debit);
        this.initialCredit.setTo(this.member);
        this.session.save((Object)this.initialCredit);
        this.memberDebit.add(this.initialCredit);
        this.moneyConversion = new TransferType();
        this.moneyConversion.setName(this.bundle.getString("transfer-type.money-conversion.name"));
        this.moneyConversion.setDescription(this.bundle.getString("transfer-type.money-conversion.description"));
        this.moneyConversion.setFrom(this.debit);
        this.moneyConversion.setTo(this.member);
        this.moneyConversion.getContext().setPayment(true);
        this.session.save((Object)this.moneyConversion);
        this.systemAdmins.getTransferTypes().add(this.moneyConversion);
        this.transactionTaxPayment = new TransferType();
        this.transactionTaxPayment.setName(this.bundle.getString("transfer-type.transaction-tax-payment.name"));
        this.transactionTaxPayment.setDescription(this.bundle.getString("transfer-type.transaction-tax-payment.description"));
        this.transactionTaxPayment.setFrom(this.member);
        this.transactionTaxPayment.setTo(this.community);
        this.session.save((Object)this.transactionTaxPayment);
        this.brokerCommissionPayment = new TransferType();
        this.brokerCommissionPayment.setName(this.bundle.getString("transfer-type.broker-commission-payment.name"));
        this.brokerCommissionPayment.setDescription(this.bundle.getString("transfer-type.broker-commission-payment.description"));
        this.brokerCommissionPayment.setFrom(this.community);
        this.brokerCommissionPayment.setTo(this.member);
        this.session.save((Object)this.brokerCommissionPayment);
        this.contributionPayment = new TransferType();
        this.contributionPayment.setName(this.bundle.getString("transfer-type.contribution-payment.name"));
        this.contributionPayment.setDescription(this.bundle.getString("transfer-type.contribution-payment.description"));
        this.contributionPayment.setFrom(this.member);
        this.contributionPayment.setTo(this.community);
        this.session.save((Object)this.contributionPayment);
        this.liquidityTaxPayment = new TransferType();
        this.liquidityTaxPayment.setName(this.bundle.getString("transfer-type.liquidity-tax-payment.name"));
        this.liquidityTaxPayment.setDescription(this.bundle.getString("transfer-type.liquidity-tax-payment.description"));
        this.liquidityTaxPayment.setFrom(this.member);
        this.liquidityTaxPayment.setTo(this.community);
        this.session.save((Object)this.liquidityTaxPayment);
        Channel restChannel = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"rest")).uniqueResult();
        Channel wap2Channel = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"wap2")).uniqueResult();
        Channel wap1Channel = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"wap1")).uniqueResult();
        ArrayList<Channel> mobileChannels = new ArrayList<Channel>();
        mobileChannels.add(restChannel);
        mobileChannels.add(wap2Channel);
        mobileChannels.add(wap1Channel);
        this.mobileTrade = new TransferType();
        this.mobileTrade.setName(this.bundle.getString("transfer-type.mobile-trade.name"));
        this.mobileTrade.setDescription(this.bundle.getString("transfer-type.mobile-trade.description"));
        this.mobileTrade.setFrom(this.member);
        this.mobileTrade.setTo(this.member);
        this.mobileTrade.getContext().setPayment(true);
        this.mobileTrade.setChannels(mobileChannels);
        this.mobileTrade.setMaxAmountPerDay(new BigDecimal(500));
        this.mobileTrade.setGroups(new HashSet<MemberGroup>(this.enabledMemberGroups));
        this.setFeedbackParameters(this.mobileTrade);
        this.session.save((Object)this.mobileTrade);
        this.associateTransferTypeToGroups(this.mobileTrade, this.enabledMemberGroups);
        Channel poswebChannel = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"posweb")).uniqueResult();
        Channel webshopChannel = (Channel)this.session.createCriteria(Channel.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"webshop")).uniqueResult();
        List<Channel> externalTradeTransferChannels = Arrays.asList(webshopChannel, poswebChannel);
        this.externalTrade = new TransferType();
        this.externalTrade.setName(this.bundle.getString("transfer-type.external-trade.name"));
        this.externalTrade.setDescription(this.bundle.getString("transfer-type.external-trade.description"));
        this.externalTrade.setFrom(this.member);
        this.externalTrade.setTo(this.member);
        this.externalTrade.setChannels(externalTradeTransferChannels);
        this.externalTrade.getContext().setPayment(true);
        this.externalTrade.setMaxAmountPerDay(new BigDecimal(500));
        this.externalTrade.setGroups(new HashSet<MemberGroup>(this.enabledMemberGroups));
        this.session.save((Object)this.externalTrade);
        this.associateTransferTypeToGroups(this.externalTrade, this.enabledMemberGroups);
    }

    private void setFeedbackParameters(TransferType transferType) {
        transferType.setRequiresFeedback(true);
        transferType.setDefaultFeedbackComments(this.bundle.getString("transfer-type.feedback.default-comments"));
        transferType.setDefaultFeedbackLevel(Reference.Level.NEUTRAL);
        transferType.setFeedbackEnabledSince(Calendar.getInstance());
        transferType.setFeedbackExpirationTime(new TimePeriod(2, TimePeriod.Field.WEEKS));
        transferType.setFeedbackReplyExpirationTime(new TimePeriod(2, TimePeriod.Field.WEEKS));
    }
}

