/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.access.ChannelPrincipal;
import nl.strohalm.cyclos.entities.accounts.MemberAccountType;
import nl.strohalm.cyclos.entities.accounts.SystemAccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.PaymentFilter;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.infotexts.InfoText;
import nl.strohalm.cyclos.entities.members.messages.Message;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.entities.services.ServiceOperation;
import nl.strohalm.cyclos.entities.settings.Setting;
import nl.strohalm.cyclos.setup.CreateBasicData;
import nl.strohalm.cyclos.setup.Setup;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class CreateSmsData
implements Runnable {
    private final ResourceBundle bundle;
    private final Session session;
    private MemberGroup fullMembers;
    private MemberGroup inactiveMembers;
    private BrokerGroup fullBrokers;
    private Channel smsChannel;
    private TransferType smsTradeTT;
    private TransferType smsChargeTT;
    private MemberCustomField mobileCustomField;
    private MemberAccountType memberAccType;
    private SystemAccountType organizationAccType;
    private Collection<MemberGroup> enabledMemberGroups;

    public CreateSmsData(Setup setup) {
        this.session = setup.getSession();
        this.bundle = setup.getBundle();
    }

    @Override
    public void run() {
        Setup.out.println(this.bundle.getString("sms-data.start"));
        this.fullMembers = (MemberGroup)this.session.createCriteria(MemberGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.full-members.name"))).uniqueResult();
        this.inactiveMembers = (MemberGroup)this.session.createCriteria(MemberGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.inactive-members.name"))).uniqueResult();
        this.fullBrokers = (BrokerGroup)this.session.createCriteria(BrokerGroup.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("group.full-brokers.name"))).uniqueResult();
        this.enabledMemberGroups = Arrays.asList(this.fullMembers, this.fullBrokers);
        this.mobileCustomField = (MemberCustomField)this.session.createCriteria(MemberCustomField.class).add((Criterion)Restrictions.eq((String)"internalName", (Object)"mobilePhone")).uniqueResult();
        this.memberAccType = (MemberAccountType)this.session.createCriteria(MemberAccountType.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("account.member.name"))).uniqueResult();
        this.organizationAccType = (SystemAccountType)this.session.createCriteria(SystemAccountType.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("account.organization.name"))).uniqueResult();
        this.createChannel();
        this.createTransfers();
        this.createServiceClient();
        this.createLocalSettings();
        this.creatInfoText();
        this.updateMemberGroup();
        this.updatePaymentFilter();
        this.customizeFullMembersGroup();
        this.customizeInactiveMembersGroup();
        this.session.flush();
        Setup.out.println(this.bundle.getString("sms-data.end"));
    }

    private void createChannel() {
        ArrayList<ChannelPrincipal> principals = new ArrayList<ChannelPrincipal>();
        this.smsChannel = new Channel();
        this.smsChannel.setDisplayName("SMS");
        this.smsChannel.setInternalName("sms");
        this.smsChannel.setCredentials(Channel.Credentials.PIN);
        this.smsChannel.setPaymentRequestWebServiceUrl("http://localhost:8080/sms/services/paymentRequest");
        this.smsChannel.setPrincipals(principals);
        ChannelPrincipal userPrincipal = new ChannelPrincipal();
        userPrincipal.setChannel(this.smsChannel);
        userPrincipal.setPrincipal(Channel.Principal.USER);
        userPrincipal.setDefault(true);
        principals.add(userPrincipal);
        ChannelPrincipal mobilePrincipal = new ChannelPrincipal();
        mobilePrincipal.setChannel(this.smsChannel);
        mobilePrincipal.setPrincipal(Channel.Principal.CUSTOM_FIELD);
        mobilePrincipal.setCustomField(this.mobileCustomField);
        principals.add(mobilePrincipal);
        this.session.save((Object)this.smsChannel);
        this.session.save((Object)userPrincipal);
        this.session.save((Object)mobilePrincipal);
    }

    private void createLocalSettings() {
        CreateBasicData.createSetting(this.session, Setting.Type.LOCAL, "cyclosId", "cyclos");
        CreateBasicData.createSetting(this.session, Setting.Type.LOCAL, "smsEnabled", "true");
        CreateBasicData.createSetting(this.session, Setting.Type.LOCAL, "smsCustomFieldId", this.mobileCustomField.getId().toString());
        CreateBasicData.createSetting(this.session, Setting.Type.LOCAL, "smsChannelName", this.smsChannel.getInternalName());
        CreateBasicData.createSetting(this.session, Setting.Type.LOCAL, "sendSmsWebServiceUrl", "http://localhost:8080/sms/services/smsSender");
    }

    private void createServiceClient() {
        ServiceClient client = new ServiceClient();
        client.setName(this.bundle.getString("service-client.controller.name"));
        client.setHostname("127.0.0.1");
        client.setAddressBegin("127.000.000.001");
        client.setAddressEnd("127.000.000.001");
        client.setChannel(this.smsChannel);
        client.setCredentialsRequired(true);
        client.setIgnoreRegistrationValidations(true);
        client.setDoPaymentTypes(Collections.singleton(this.smsTradeTT));
        client.setChargebackPaymentTypes(Collections.singleton(this.smsTradeTT));
        client.setManageGroups(new HashSet<MemberGroup>(this.enabledMemberGroups));
        HashSet<ServiceOperation> permissions = new HashSet<ServiceOperation>();
        permissions.add(ServiceOperation.DO_PAYMENT);
        permissions.add(ServiceOperation.CHARGEBACK);
        permissions.add(ServiceOperation.MEMBERS);
        permissions.add(ServiceOperation.MANAGE_MEMBERS);
        permissions.add(ServiceOperation.ACCOUNT_DETAILS);
        permissions.add(ServiceOperation.ACCESS);
        permissions.add(ServiceOperation.SMS);
        permissions.add(ServiceOperation.INFO_TEXTS);
        client.setPermissions(permissions);
        this.session.save((Object)client);
    }

    private void createTransfers() {
        this.smsTradeTT = new TransferType();
        this.smsTradeTT.setName(this.bundle.getString("transfer-type.sms-trade.name"));
        this.smsTradeTT.setDescription(this.bundle.getString("transfer-type.sms-trade.description"));
        this.smsTradeTT.setFrom(this.memberAccType);
        this.smsTradeTT.setTo(this.memberAccType);
        this.smsTradeTT.getContext().setPayment(true);
        this.smsTradeTT.setChannels(Collections.singleton(this.smsChannel));
        this.smsTradeTT.setAllowSmsNotification(true);
        this.smsTradeTT.setGroups(new HashSet<MemberGroup>(this.enabledMemberGroups));
        this.session.save((Object)this.smsTradeTT);
        this.smsChargeTT = new TransferType();
        this.smsChargeTT.setName(this.bundle.getString("transfer-type.sms-charge.name"));
        this.smsChargeTT.setDescription(this.bundle.getString("transfer-type.sms-charge.description"));
        this.smsChargeTT.setFrom(this.memberAccType);
        this.smsChargeTT.setTo(this.organizationAccType);
        this.session.save((Object)this.smsChargeTT);
    }

    private void creatInfoText() {
        InfoText info = new InfoText();
        info.setAliases(Collections.singleton("info"));
        info.setBody(this.bundle.getString("info-text.sample.body"));
        info.setSubject(this.bundle.getString("info-text.sample.subject"));
        info.setEnabled(true);
        this.session.save((Object)info);
    }

    private void customizeFullMembersGroup() {
        this.fullMembers.setInitialGroup(true);
        this.fullMembers.getPermissions().add(MemberPermission.SMS_VIEW);
    }

    private void customizeInactiveMembersGroup() {
        this.inactiveMembers.setInitialGroup(false);
    }

    private void updateMemberGroup() {
        for (MemberGroup mGrp : this.enabledMemberGroups) {
            CreateBasicData.associateGroupToChannel(this.smsChannel, mGrp);
            Collection<Message.Type> smsMessages = mGrp.getDefaultSmsMessages();
            if (smsMessages == null) {
                smsMessages = new ArrayList<Message.Type>();
                mGrp.setDefaultSmsMessages(smsMessages);
            }
            smsMessages.add(Message.Type.PAYMENT);
            ArrayList<Message.Type> smsMessageTypes = new ArrayList<Message.Type>(Arrays.asList(Message.Type.values()));
            CollectionUtils.filter(smsMessageTypes, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Message.Type type = (Message.Type)object;
                    switch (type) {
                        case FROM_MEMBER: 
                        case FROM_ADMIN_TO_MEMBER: 
                        case FROM_ADMIN_TO_GROUP: {
                            return false;
                        }
                    }
                    return true;
                }
            });
            mGrp.setSmsMessages(smsMessageTypes);
            mGrp.setDefaultAllowChargingSms(true);
            mGrp.setDefaultAcceptFreeMailing(true);
            mGrp.setDefaultAcceptPaidMailing(true);
            MemberGroupSettings mSettings = mGrp.getMemberSettings();
            mSettings.setSmsChargeTransferType(this.smsChargeTT);
            mSettings.setSmsChargeAmount(new BigDecimal(1));
            mGrp.getTransferTypes().add(this.smsTradeTT);
            this.session.save((Object)mGrp);
        }
    }

    private void updatePaymentFilter() {
        PaymentFilter filter = (PaymentFilter)this.session.createCriteria(PaymentFilter.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("payment-filter.member-payments"))).add((Criterion)Restrictions.eq((String)"accountType", (Object)this.memberAccType)).uniqueResult();
        filter.getTransferTypes().add(this.smsTradeTT);
        filter = (PaymentFilter)this.session.createCriteria(PaymentFilter.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.bundle.getString("payment-filter.member-payments"))).add((Criterion)Restrictions.eq((String)"accountType", (Object)this.organizationAccType)).uniqueResult();
        filter.getTransferTypes().add(this.smsChargeTT);
        this.session.save((Object)filter);
    }
}

