/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import nl.strohalm.cyclos.setup.Migration;
import nl.strohalm.cyclos.setup.Setup;
import nl.strohalm.cyclos.setup.TraceableMigration;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.setup.Version;
import nl.strohalm.cyclos.setup.VersionHistory;
import nl.strohalm.cyclos.setup.VersionHistoryReader;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.conversion.LocaleConverter;
import nl.strohalm.cyclos.utils.tasks.TaskRunner;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.DatasourceConnectionProvider;

public class DataBaseConfiguration {
    public static boolean SKIP = false;
    private static final Log LOG = LogFactory.getLog(DataBaseConfiguration.class);
    private final Configuration configuration;
    private SessionFactory sessionFactory;
    private final TaskRunner taskRunner;
    private Class<?> driverToUnregister;

    public DataBaseConfiguration(Configuration configuration, TaskRunner taskRunner) {
        this.configuration = configuration;
        this.taskRunner = taskRunner;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void release() {
        if (this.driverToUnregister != null) {
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            while (drivers.hasMoreElements()) {
                Driver driver = drivers.nextElement();
                if (!this.driverToUnregister.isInstance(driver)) continue;
                try {
                    DriverManager.deregisterDriver(driver);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void run() {
        boolean skipTests;
        final Properties properties = this.configuration.getProperties();
        this.warnTrailingSpaces(properties);
        this.initCommonProperties(properties);
        String skipTestsProperty = StringUtils.trimToNull((String)properties.getProperty("cyclos.database.skipTests"));
        boolean bl = skipTests = SKIP || skipTestsProperty == null || Boolean.valueOf(skipTestsProperty) != false;
        if (skipTests) {
            if (!SKIP && skipTestsProperty == null) {
                LOG.info((Object)"Skipping Cyclos database check, as cyclos.properties doesn't set cyclos.database.skipTests=false");
            }
            return;
        }
        this.taskRunner.handleDatabaseInitialization(new Runnable(){

            @Override
            public void run() {
                DataBaseConfiguration.this.handleDatabase(properties);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDatabase(Properties properties) {
        String dataBaseVersion;
        String dataBaseName;
        String connectionLocation;
        Connection connection;
        String dataSource = StringUtils.trimToNull((String)properties.getProperty("hibernate.connection.datasource"));
        if (dataSource != null) {
            DatasourceConnectionProvider provider = new DatasourceConnectionProvider();
            provider.configure(properties);
            try {
                connection = provider.getConnection();
            }
            catch (SQLException e) {
                String msg = "Error connecting to datasource at " + dataSource;
                LOG.error((Object)msg);
                throw new RuntimeException(msg, e);
            }
            connectionLocation = dataSource;
        } else {
            String driverClass = StringUtils.trimToNull((String)properties.getProperty("hibernate.connection.driver_class"));
            this.validateDriver(driverClass);
            String url = properties.getProperty("hibernate.connection.url");
            String username = properties.getProperty("hibernate.connection.username");
            String password = properties.getProperty("hibernate.connection.password");
            connection = this.validateConnection(url, username, password);
            connectionLocation = url;
        }
        JDBCWrapper jdbc = new JDBCWrapper(connection);
        boolean embedded = Boolean.valueOf(properties.getProperty("cyclos.embedded.enable", "false"));
        boolean dataBaseExists = true;
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            dataBaseName = metaData.getDatabaseProductName();
            dataBaseVersion = metaData.getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error reading database metadata", e);
        }
        try {
            String currentVersion = this.readCurrentVersion(jdbc);
            if (currentVersion != null) {
                LOG.info((Object)String.format("Cyclos database version %s found on %s version %s", currentVersion, dataBaseName, dataBaseVersion));
            }
            boolean bl = dataBaseExists = currentVersion != null;
            if (dataBaseExists) {
                String newVersion;
                boolean autoUpgrade = Boolean.valueOf(properties.getProperty("cyclos.autoSchemaUpgrade.enable", "false"));
                if (autoUpgrade && !currentVersion.equals(newVersion = this.upgradeSchema(currentVersion, jdbc))) {
                    properties.setProperty("cyclos.versionHasChanged", "true");
                }
            } else if (embedded && dataBaseName.toLowerCase().equals("mysql")) {
                try {
                    jdbc.commit();
                    jdbc.execute("alter database character set utf8", new Object[0]);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException e) {}
        }
        if (!dataBaseExists) {
            if (embedded) {
                boolean smsEmbedded = Boolean.valueOf(properties.getProperty("cyclos.embedded.sms.enable", "false"));
                LOG.info((Object)"Database is empty. Running setup to populate it");
                this.sessionFactory = this.configuration.buildSessionFactory();
                Locale locale = LocaleConverter.instance().valueOf(properties.getProperty("cyclos.embedded.locale", "en_US"));
                Setup setup = new Setup(this.configuration, this.sessionFactory);
                setup.setLocale(locale);
                setup.setCreateDataBase(true);
                setup.setCreateBasicData(true);
                setup.setCreateInitialData(true);
                setup.setCreateSmsData(smsEmbedded);
                setup.setForce(true);
                setup.execute();
            } else {
                throw new RuntimeException("Cyclos database not found at " + connectionLocation);
            }
        }
    }

    private void initCommonProperties(Properties properties) {
        String url;
        boolean secondLevelCacheEnabled;
        if (StringUtils.isEmpty((String)properties.getProperty("hibernate.connection.isolation"))) {
            properties.setProperty("hibernate.connection.isolation", "2");
        }
        if ((secondLevelCacheEnabled = Boolean.parseBoolean(properties.getProperty("hibernate.cache.use_second_level_cache", "false"))) && StringUtils.isEmpty((String)properties.getProperty("hibernate.cache.region.factory_class"))) {
            properties.setProperty("hibernate.cache.region.factory_class", "net.sf.ehcache.hibernate.EhCacheRegionFactory");
        }
        if ((url = StringUtils.trimToNull((String)properties.getProperty("hibernate.connection.url"))) != null && url.toLowerCase().startsWith("jdbc:mysql:")) {
            if (!url.contains("useUnicode")) {
                url = url + (url.contains("?") ? "&" : "?") + "useUnicode=true";
            }
            if (!url.contains("characterEncoding")) {
                url = url + (url.contains("?") ? "&" : "?") + "characterEncoding=utf8";
            }
            properties.setProperty("hibernate.connection.url", url);
        }
    }

    private String readCurrentVersion(JDBCWrapper jdbc) {
        try {
            return jdbc.readScalarAsString("select version from application", new Object[0]);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private String upgradeSchema(String originalVersion, JDBCWrapper jdbc) {
        String databaseName;
        String currentVersion = originalVersion;
        VersionHistory history = new VersionHistoryReader().read();
        List<Version> intermediateVersions = history.upgrade(originalVersion);
        if (intermediateVersions == null) {
            LOG.warn((Object)("Unknown version on database: " + originalVersion));
            return originalVersion;
        }
        try {
            databaseName = jdbc.getConnection().getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new RuntimeException("Error reading database name", e);
        }
        for (Version version : intermediateVersions) {
            String newVersion = version.getLabel();
            List<String> statements = version.getStatements(databaseName);
            LOG.info((Object)String.format("Upgrading schema from version %s to version %s", currentVersion, newVersion));
            if (CollectionUtils.isNotEmpty(statements)) {
                int executedOk = 0;
                int totalUpdatedRows = 0;
                for (String statement : statements) {
                    try {
                        int updatedRows = jdbc.execute(statement, new Object[0]);
                        LOG.info((Object)String.format("Statement executed: %s", statement));
                        if (updatedRows > 0) {
                            LOG.info((Object)("Updated rows: " + updatedRows));
                            totalUpdatedRows += updatedRows;
                        }
                        ++executedOk;
                    }
                    catch (SQLException e) {
                        LOG.warn((Object)String.format("Error applying automatic schema upgrade on version %s when executing statement [%s]: %s", newVersion, statement, e.getMessage()));
                    }
                }
                String msg = "Statements executed (ok / total): " + executedOk + " / " + statements.size() + ".";
                if (totalUpdatedRows == 0) {
                    msg = msg + " None of the executed statements has modified data.";
                }
                LOG.info((Object)msg);
            }
            LOG.info((Object)"Executing migrations...");
            try {
                List<Class<Migration>> migrations = version.getMigrations(databaseName);
                if (CollectionUtils.isNotEmpty(migrations)) {
                    int executedOk = 0;
                    int totalUpdatedRows = 0;
                    for (Class<Migration> clazz : migrations) {
                        Migration migration;
                        LOG.info((Object)String.format("Executing migration class %s", clazz.getName()));
                        try {
                            migration = clazz.newInstance();
                        }
                        catch (Exception e) {
                            LOG.warn((Object)String.format("Error instantiating the migration class %s", clazz.getName()), (Throwable)e);
                            continue;
                        }
                        try {
                            if (migration instanceof UntraceableMigration) {
                                ((UntraceableMigration)migration).execute(jdbc);
                            } else {
                                int updatedRows = ((TraceableMigration)migration).execute(jdbc);
                                if (updatedRows > 0) {
                                    LOG.info((Object)("Updated rows: " + updatedRows));
                                    totalUpdatedRows += updatedRows;
                                }
                            }
                            ++executedOk;
                        }
                        catch (Exception e) {
                            LOG.warn((Object)String.format("Error upgrading to version %s when executing migration: %s", newVersion, e.getMessage()));
                            LOG.debug((Object)e);
                        }
                    }
                    String msg = "Migrations executed (ok / total): " + executedOk + " / " + migrations.size() + ".";
                    if (totalUpdatedRows == 0) {
                        msg = msg + " None of the executed migrations has modified data.";
                    }
                    LOG.info((Object)msg);
                }
                try {
                    jdbc.commit();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Error while committing", (Throwable)e);
                }
            }
            catch (Exception e) {
                try {
                    jdbc.rollback();
                }
                catch (SQLException e1) {
                    LOG.warn((Object)"Error while rolling back", (Throwable)e1);
                }
            }
            List<String> removedTranslationKeys = version.getRemovedTranslationKeys();
            if (CollectionUtils.isNotEmpty(removedTranslationKeys)) {
                for (String key : removedTranslationKeys) {
                    key = StringUtils.trimToEmpty((String)key);
                    try {
                        int deletedRows = jdbc.execute("delete from translation_messages where msg_key = ?", key);
                        if (deletedRows > 0) {
                            LOG.info((Object)String.format("Removing unused translation message: %s", key));
                            continue;
                        }
                        LOG.info((Object)String.format("Unused translation message: %s was not found in the database", key));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)String.format("Error removing unused translation message: %s", key), (Throwable)e);
                    }
                }
                try {
                    jdbc.commit();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Error while committing", (Throwable)e);
                }
            }
            currentVersion = newVersion;
            try {
                jdbc.execute("update application set version = ?", currentVersion);
                jdbc.commit();
            }
            catch (SQLException e) {
                LOG.warn((Object)String.format("Error while updating the current version table to %s", currentVersion), (Throwable)e);
                try {
                    jdbc.rollback();
                }
                catch (SQLException e1) {
                    LOG.warn((Object)"Error while rolling back", (Throwable)e1);
                }
            }
        }
        if (!originalVersion.equals(currentVersion)) {
            LOG.info((Object)String.format("The database has been upgraded to version %s", currentVersion));
        }
        return currentVersion;
    }

    private Connection validateConnection(String url, String username, String password) {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, username, password);
            connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            String msg = "Error connecting to database at " + url;
            LOG.error((Object)msg);
            throw new RuntimeException(msg, e);
        }
        return connection;
    }

    private void validateDriver(String driverClass) {
        try {
            Class<?> clazz = Class.forName(driverClass);
            if (!Driver.class.isAssignableFrom(clazz)) {
                throw new Exception();
            }
            this.driverToUnregister = clazz;
        }
        catch (Exception e) {
            String msg = "Illegal JDBC driver class on cyclos.properties: " + driverClass;
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
    }

    private void warnTrailingSpaces(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            if (key.equals("line.separator") || value.trim().equals(value)) continue;
            LOG.warn((Object)("Property '" + key + "' has trailing spaces. Its value is : '" + value + "'"));
        }
    }
}

