/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.File;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.setup.Setup;
import org.apache.commons.lang.SystemUtils;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;

public class ExportScript
implements Runnable {
    private final ResourceBundle bundle;
    private final Configuration configuration;
    private File exportTo;

    public ExportScript(Setup setup, File exportTo) {
        if (exportTo == null) {
            throw new IllegalArgumentException("No file for the script");
        }
        this.configuration = setup.getConfiguration();
        this.bundle = setup.getBundle();
        this.exportTo = exportTo;
    }

    @Override
    public void run() {
        File dir;
        if (!this.exportTo.isAbsolute()) {
            this.exportTo = new File(SystemUtils.getUserDir(), this.exportTo.getPath());
        }
        if (this.exportTo.isDirectory()) {
            this.exportTo = new File(this.exportTo, "cyclos.ddl");
        }
        if (!(dir = this.exportTo.getParentFile()).exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Could not create directory: " + dir);
        }
        String fileName = this.exportTo.getAbsolutePath();
        Setup.out.println(this.bundle.getString("export-script.start"));
        SchemaExport schemaExport = new SchemaExport(this.configuration);
        schemaExport.setDelimiter(";");
        schemaExport.setOutputFile(fileName);
        schemaExport.create(true, false);
        Setup.out.println(this.bundle.getString("export-script.end") + " " + fileName);
    }
}

