/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.CyclosConfiguration;
import nl.strohalm.cyclos.setup.Arguments;
import nl.strohalm.cyclos.setup.CreateBasicData;
import nl.strohalm.cyclos.setup.CreateDataBase;
import nl.strohalm.cyclos.setup.CreateInitialData;
import nl.strohalm.cyclos.setup.CreateSmsData;
import nl.strohalm.cyclos.setup.DataBaseConfiguration;
import nl.strohalm.cyclos.setup.ExportScript;
import nl.strohalm.cyclos.utils.PropertiesHelper;
import nl.strohalm.cyclos.utils.conversion.LocaleConverter;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Setup {
    public static final String[] SPRING_CONFIG_FILES = new String[]{"/nl/strohalm/cyclos/spring/persistence.xml"};
    public static PrintStream out = System.out;
    private static final String RESOURCE_BUNDLE_BASE_NAME = "nl.strohalm.cyclos.setup.CyclosSetup";
    private ResourceBundle bundle;
    private Configuration configuration;
    private boolean createBasicData;
    private boolean createDataBase;
    private boolean createSetupData;
    private boolean createInitialData;
    private boolean createSmsData;
    private File exportScriptTo;
    private boolean force;
    private Session session;
    private SessionFactory sessionFactory;
    private Locale locale;

    public static PrintStream getOut() {
        return out;
    }

    public static ResourceBundle getResourceBundle() {
        return Setup.getResourceBundle(Locale.getDefault());
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return PropertiesHelper.readBundle(RESOURCE_BUNDLE_BASE_NAME, locale);
    }

    public static void main(String ... args) throws IOException {
        DataBaseConfiguration.SKIP = true;
        Locale locale = Setup.resolveLocale();
        Setup setup = Arguments.buildSetupFromArguments(locale, args);
        setup.locale = locale;
        setup.showInitializing();
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(SPRING_CONFIG_FILES);
        setup.configuration = (Configuration)applicationContext.getBean(Configuration.class);
        setup.sessionFactory = (SessionFactory)applicationContext.getBean(SessionFactory.class);
        setup.execute();
        System.exit(0);
    }

    public static void setOut(PrintStream out) {
        Setup.out = out;
    }

    private static Locale resolveLocale() throws IOException {
        LocaleConverter localeConverter = LocaleConverter.instance();
        Properties cyclosProperties = CyclosConfiguration.getCyclosProperties();
        String defaultLocale = localeConverter.toString(Locale.getDefault());
        String localeStr = cyclosProperties.getProperty("cyclos.embedded.locale", defaultLocale);
        return localeConverter.valueOf(localeStr);
    }

    public Setup() {
    }

    public Setup(Configuration configuration, SessionFactory sessionFactory) {
        this.configuration = configuration;
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        this.checkBundle();
        if (!this.isValid()) {
            throw new IllegalStateException("Nothing to execute");
        }
        if (!this.force && !this.promptConfirm()) {
            return false;
        }
        if (this.configuration == null || this.sessionFactory == null) {
            throw new IllegalStateException("Persistence not configured");
        }
        this.session = this.sessionFactory.openSession();
        Transaction transaction = this.session.beginTransaction();
        try {
            if (this.createDataBase) {
                new CreateDataBase(this).run();
            }
            if (this.exportScriptTo != null) {
                new ExportScript(this, this.exportScriptTo).run();
            }
            if (this.createSetupData) {
                new CreateBasicData(this, true).run();
            }
            if (this.createBasicData) {
                new CreateBasicData(this, false).run();
            }
            if (this.createInitialData) {
                new CreateInitialData(this).run();
            }
            if (this.createSmsData) {
                new CreateSmsData(this).run();
            }
            transaction.commit();
            out.println(this.bundle.getString("setup.end"));
            if (Boolean.getBoolean("cyclos.standalone")) {
                System.out.println(this.bundle.getString("setup.standalone.starting"));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            transaction.rollback();
            e.printStackTrace(out);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.session.close();
            }
            catch (Exception e) {
                out.println("Error closing session: " + e);
            }
        }
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File getExportScriptTo() {
        return this.exportScriptTo;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Session getSession() {
        return this.session;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public boolean isCreateBasicData() {
        return this.createBasicData;
    }

    public boolean isCreateDataBase() {
        return this.createDataBase;
    }

    public boolean isCreateInitialData() {
        return this.createInitialData;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isValid() {
        return this.createDataBase || this.exportScriptTo != null || this.createBasicData || this.createInitialData || this.createSmsData;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setCreateBasicData(boolean createBasicData) {
        this.createBasicData = createBasicData;
    }

    public void setCreateDataBase(boolean createDataBase) {
        this.createDataBase = createDataBase;
    }

    public void setCreateInitialData(boolean createInitialData) {
        this.createInitialData = createInitialData;
    }

    public void setCreateSetupData(boolean createSetupData) {
        this.createSetupData = createSetupData;
    }

    public void setCreateSmsData(boolean createSmsData) {
        this.createSmsData = createSmsData;
    }

    public void setExportScriptTo(File exportScriptTo) {
        this.exportScriptTo = exportScriptTo;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private void checkBundle() {
        if (this.bundle == null) {
            this.bundle = Setup.getResourceBundle(this.locale);
        }
    }

    private boolean promptConfirm() {
        ArrayList<String> executedOperations = new ArrayList<String>();
        boolean scriptOnly = false;
        if (this.exportScriptTo != null) {
            scriptOnly = true;
            executedOperations.add(MessageFormat.format(this.bundle.getString("action.export-script"), this.exportScriptTo.getAbsolutePath()));
        }
        if (this.createDataBase) {
            scriptOnly = false;
            executedOperations.add(this.bundle.getString("action.create-data-base"));
        }
        if (this.createBasicData) {
            scriptOnly = false;
            executedOperations.add(this.bundle.getString("action.create-basic-data"));
        }
        if (this.createInitialData) {
            scriptOnly = false;
            executedOperations.add(this.bundle.getString("action.create-initial-data"));
        }
        if (this.createSmsData) {
            scriptOnly = false;
            executedOperations.add(this.bundle.getString("action.create-sms-data"));
        }
        if (scriptOnly) {
            return true;
        }
        String yes = this.bundle.getString("confirm.yes");
        String no = this.bundle.getString("confirm.no");
        out.println(this.bundle.getString("setup.execute") + ": \n * " + StringUtils.join(executedOperations.iterator(), (String)"\n * "));
        out.println(this.bundle.getString("setup.confirm") + " (" + yes + "/" + no + ")");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = reader.readLine();
            if (line == null || line.length() == 0 || !line.equalsIgnoreCase(yes)) {
                out.println(this.bundle.getString("setup.aborted"));
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void showInitializing() {
        this.checkBundle();
        out.println(this.bundle.getString("setup.initializing"));
    }
}

