/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.setup.Migration;
import org.apache.commons.lang.StringUtils;

public class Version
implements Serializable {
    private static final long serialVersionUID = -823920658138712571L;
    private final String label;
    private String description;
    private Map<String, List<String>> statementsByDataBase;
    private Map<String, List<Class<Migration>>> migrationsByDataBase;
    private List<String> newHelps;
    private List<String> removedHelps;
    private List<String> newStaticFiles;
    private List<String> removedStaticFiles;
    private List<String> newTranslationKeys;
    private List<String> removedTranslationKeys;
    private List<String> newSetupKeys;
    private List<String> removedSetupKeys;
    private List<String> newLibraries;
    private List<String> removedLibraries;
    private List<String> newCssClasses;
    private List<String> removedCssClasses;
    private List<String> bugFixes;
    private List<String> enhancements;

    public Version(String label) {
        if (StringUtils.isEmpty((String)label)) {
            throw new IllegalArgumentException("Empty label");
        }
        this.label = label;
    }

    public void addMigration(String database, Class<Migration> clazz) {
        List<Class<Migration>> migrations;
        if (clazz == null) {
            return;
        }
        if (!Migration.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Invalid migration class: " + clazz.getName());
        }
        database = database.toLowerCase();
        if (this.migrationsByDataBase == null) {
            this.migrationsByDataBase = new HashMap<String, List<Class<Migration>>>();
        }
        if ((migrations = this.migrationsByDataBase.get(database)) == null) {
            migrations = new ArrayList<Class<Migration>>();
            this.migrationsByDataBase.put(database, migrations);
        }
        migrations.add(clazz);
    }

    public void addStatements(String database, List<String> statements) {
        List<String> currentStatements;
        if (statements == null || statements.isEmpty()) {
            return;
        }
        database = database.toLowerCase();
        if (this.statementsByDataBase == null) {
            this.statementsByDataBase = new HashMap<String, List<String>>();
        }
        if ((currentStatements = this.statementsByDataBase.get(database)) == null) {
            currentStatements = new ArrayList<String>();
            this.statementsByDataBase.put(database, currentStatements);
        }
        currentStatements.addAll(statements);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version v = (Version)obj;
        return this.label.equals(v.label);
    }

    public List<String> getBugFixes() {
        return this.bugFixes;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getEnhancements() {
        return this.enhancements;
    }

    public String getLabel() {
        return this.label;
    }

    public List<Class<Migration>> getMigrations(String database) {
        database = StringUtils.trimToNull((String)database);
        if (this.migrationsByDataBase == null && database != null) {
            return null;
        }
        for (Map.Entry<String, List<Class<Migration>>> entry : this.migrationsByDataBase.entrySet()) {
            if (!database.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, List<Class<Migration>>> getMigrationsByDataBase() {
        return this.migrationsByDataBase;
    }

    public List<String> getNewCssClasses() {
        return this.newCssClasses;
    }

    public List<String> getNewHelps() {
        return this.newHelps;
    }

    public List<String> getNewLibraries() {
        return this.newLibraries;
    }

    public List<String> getNewSetupKeys() {
        return this.newSetupKeys;
    }

    public List<String> getNewStaticFiles() {
        return this.newStaticFiles;
    }

    public List<String> getNewTranslationKeys() {
        return this.newTranslationKeys;
    }

    public List<String> getRemovedCssClasses() {
        return this.removedCssClasses;
    }

    public List<String> getRemovedHelps() {
        return this.removedHelps;
    }

    public List<String> getRemovedLibraries() {
        return this.removedLibraries;
    }

    public List<String> getRemovedSetupKeys() {
        return this.removedSetupKeys;
    }

    public List<String> getRemovedStaticFiles() {
        return this.removedStaticFiles;
    }

    public List<String> getRemovedTranslationKeys() {
        return this.removedTranslationKeys;
    }

    public List<String> getStatements(String database) {
        database = StringUtils.trimToNull((String)database);
        if (this.statementsByDataBase == null && database != null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : this.statementsByDataBase.entrySet()) {
            if (!database.equalsIgnoreCase(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, List<String>> getStatementsByDataBase() {
        return this.statementsByDataBase;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean sameAs(String label) {
        if ((label = StringUtils.trimToNull((String)label)) == null) {
            return false;
        }
        return this.label.equalsIgnoreCase(label);
    }

    public void setBugFixes(List<String> bugFixes) {
        this.bugFixes = bugFixes;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnhancements(List<String> enhancements) {
        this.enhancements = enhancements;
    }

    public void setMigrationsByDataBase(Map<String, List<Class<Migration>>> migrationsByDataBase) {
        this.migrationsByDataBase = migrationsByDataBase;
    }

    public void setNewCssClasses(List<String> newCssClasses) {
        this.newCssClasses = newCssClasses;
    }

    public void setNewHelps(List<String> newHelps) {
        this.newHelps = newHelps;
    }

    public void setNewLibraries(List<String> newLibraries) {
        this.newLibraries = newLibraries;
    }

    public void setNewSetupKeys(List<String> newSetupKeys) {
        this.newSetupKeys = newSetupKeys;
    }

    public void setNewStaticFiles(List<String> newStaticFiles) {
        this.newStaticFiles = newStaticFiles;
    }

    public void setNewTranslationKeys(List<String> newTranslationKeys) {
        this.newTranslationKeys = newTranslationKeys;
    }

    public void setRemovedCssClasses(List<String> removedCssClasses) {
        this.removedCssClasses = removedCssClasses;
    }

    public void setRemovedHelps(List<String> removedHelps) {
        this.removedHelps = removedHelps;
    }

    public void setRemovedLibraries(List<String> removedLibraries) {
        this.removedLibraries = removedLibraries;
    }

    public void setRemovedSetupKeys(List<String> removedSetupKeys) {
        this.removedSetupKeys = removedSetupKeys;
    }

    public void setRemovedStaticFiles(List<String> removedStaticFiles) {
        this.removedStaticFiles = removedStaticFiles;
    }

    public void setRemovedTranslationKeys(List<String> removedTranslationKeys) {
        this.removedTranslationKeys = removedTranslationKeys;
    }

    public void setStatementsByDataBase(Map<String, List<String>> statementsByDataBase) {
        this.statementsByDataBase = statementsByDataBase;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String header = String.format("Version %s", this.label);
        pw.println(header);
        pw.println(StringUtils.repeat((String)"-", (int)header.length()));
        if (StringUtils.isNotEmpty((String)this.description)) {
            pw.println(this.description);
        }
        pw.println();
        this.appendList(pw, this.enhancements, "New / modified functions", " * ", null);
        this.appendList(pw, this.bugFixes, "Bug fixes", " * ", null);
        this.appendList(pw, this.newLibraries, "New library dependencies", " * ", null);
        this.appendList(pw, this.removedLibraries, "Removed library dependencies", " * ", null);
        this.appendList(pw, this.newHelps, "New help files", " * ", null);
        this.appendList(pw, this.removedHelps, "Removed help files", " * ", null);
        this.appendList(pw, this.newStaticFiles, "New static files", " * ", null);
        this.appendList(pw, this.removedStaticFiles, "Removed static files", " * ", null);
        this.appendList(pw, this.newCssClasses, "New CSS classes", " * ", null);
        this.appendList(pw, this.removedCssClasses, "Removed CSS classes", " * ", null);
        this.appendList(pw, this.newTranslationKeys, "New application translation keys", " * ", null);
        this.appendList(pw, this.removedTranslationKeys, "Removed application translation keys", " * ", null);
        this.appendList(pw, this.newSetupKeys, "New setup translation keys", " * ", null);
        this.appendList(pw, this.removedSetupKeys, "Removed setup translation keys", " * ", null);
        pw.close();
        return sw.toString();
    }

    private void appendList(PrintWriter out, List<String> list, String header, String prefix, String suffix) {
        if (list == null || list.isEmpty()) {
            return;
        }
        out.println(header);
        for (String item : list) {
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)prefix)) {
                sb.append(prefix);
            }
            sb.append(item);
            if (StringUtils.isNotEmpty((String)suffix)) {
                sb.append(suffix);
            }
            out.println(sb);
        }
        out.println();
    }
}

