/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import nl.strohalm.cyclos.setup.Version;

public class VersionHistory
implements Serializable {
    private static final String VERSION_SEPARATOR = "---------------------------------------------------------------------------";
    private static final long serialVersionUID = -7557182450900181998L;
    private List<Version> history;
    private Version current;

    public synchronized void addVersion(Version version) {
        if (version == null) {
            throw new NullPointerException();
        }
        if (this.history == null) {
            this.history = new ArrayList<Version>();
        } else if (this.history.contains(version)) {
            throw new IllegalArgumentException(String.format("Version %s already on history", version.getLabel()));
        }
        this.history.add(version);
    }

    public Version find(String version) {
        int index = this.indexOf(version);
        return index < 0 ? null : this.history.get(index);
    }

    public Version getCurrent() {
        return this.current;
    }

    public List<Version> getHistory() {
        return this.history;
    }

    public int indexOf(String version) {
        for (int i = 0; i < this.history.size(); ++i) {
            Version current = this.history.get(i);
            if (!current.sameAs(version)) continue;
            return i;
        }
        return -1;
    }

    public void onFinish() {
        if (this.history != null) {
            Collections.reverse(this.history);
            this.current = this.history.get(this.history.size() - 1);
        }
    }

    public void setHistory(List<Version> history) {
        this.history.clear();
        if (history != null) {
            for (Version version : history) {
                this.addVersion(version);
            }
        }
    }

    public String toString() {
        if (this.history == null || this.history.isEmpty()) {
            return "Empty history";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Cyclos 3 changelog");
        pw.println("==================");
        pw.println();
        boolean firstTime = true;
        ListIterator<Version> listIterator = this.history.listIterator(this.history.size());
        while (listIterator.hasPrevious()) {
            Version version = listIterator.previous();
            if (firstTime) {
                firstTime = false;
            } else {
                pw.println(VERSION_SEPARATOR);
                pw.println();
            }
            pw.print(version);
        }
        return sw.toString();
    }

    public List<Version> upgrade(String fromVersion) {
        if (this.current != null && this.current.sameAs(fromVersion)) {
            return Collections.emptyList();
        }
        int index = this.indexOf(fromVersion);
        if (index < 0) {
            return null;
        }
        return new ArrayList<Version>(this.history.subList(index + 1, this.history.size()));
    }
}

