/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nl.strohalm.cyclos.setup.Migration;
import nl.strohalm.cyclos.setup.Version;
import nl.strohalm.cyclos.setup.VersionHistory;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionHistoryReader {
    public static void main(String[] args) {
        System.out.println(new VersionHistoryReader().read());
    }

    public VersionHistory read() {
        Document document = this.readDocument();
        VersionHistory history = new VersionHistory();
        NodeList versions = document.getElementsByTagName("version");
        for (int i = 0; i < versions.getLength(); ++i) {
            Element version = (Element)versions.item(i);
            history.addVersion(this.readVersion(version));
        }
        history.onFinish();
        return history;
    }

    private Element firstChild(Element element, String tagName) {
        NodeList rootElements = element.getElementsByTagName(tagName);
        if (rootElements.getLength() == 0) {
            return null;
        }
        return (Element)rootElements.item(0);
    }

    private Document readDocument() {
        DocumentBuilder documentBuilder;
        InputStream in = this.getClass().getResourceAsStream("changelog.xml");
        if (in == null) {
            throw new RuntimeException("changelog.xml");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating the document builder", e);
        }
        try {
            return documentBuilder.parse(in);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing the changelog.xml file", e);
        }
    }

    private List<String> readItems(Element element) {
        if (element == null) {
            return Collections.emptyList();
        }
        NodeList items = element.getElementsByTagName("item");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < items.getLength(); ++i) {
            Element item = (Element)items.item(i);
            String value = this.readValue(item);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private void readMigrations(Version version, Element element) {
        NodeList migrationsList = element.getElementsByTagName("migration");
        for (int i = 0; i < migrationsList.getLength(); ++i) {
            Class<Migration> clazz;
            Element migration = (Element)migrationsList.item(i);
            String className = StringUtils.trimToNull((String)migration.getAttribute("class"));
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal migration class name: " + className);
            }
            version.addMigration(migration.getAttribute("database"), clazz);
        }
    }

    private void readStatements(Version version, Element element) {
        NodeList statementsList = element.getElementsByTagName("statements");
        for (int i = 0; i < statementsList.getLength(); ++i) {
            Element statements = (Element)statementsList.item(i);
            version.addStatements(statements.getAttribute("database"), this.readItems(statements));
        }
    }

    private String readValue(Element element, String tagName) {
        return this.readValue(this.firstChild(element, tagName));
    }

    private String readValue(Node node) {
        if (node instanceof Element) {
            node = node.getFirstChild();
        }
        return node == null ? null : StringUtils.trimToNull((String)node.getNodeValue());
    }

    private Version readVersion(Element element) {
        String label = element.getAttribute("label");
        Version version = new Version(label);
        version.setDescription(this.readValue(element, "description"));
        this.readStatements(version, element);
        this.readMigrations(version, element);
        version.setBugFixes(this.readItems(this.firstChild(element, "bug-fixes")));
        version.setEnhancements(this.readItems(this.firstChild(element, "enhancements")));
        version.setNewLibraries(this.readItems(this.firstChild(element, "new-libraries")));
        version.setRemovedLibraries(this.readItems(this.firstChild(element, "removed-libraries")));
        version.setNewHelps(this.readItems(this.firstChild(element, "new-helps")));
        version.setRemovedHelps(this.readItems(this.firstChild(element, "removed-helps")));
        version.setNewStaticFiles(this.readItems(this.firstChild(element, "new-static-files")));
        version.setRemovedStaticFiles(this.readItems(this.firstChild(element, "removed-static-files")));
        version.setNewTranslationKeys(this.readItems(this.firstChild(element, "new-translation-keys")));
        version.setRemovedTranslationKeys(this.readItems(this.firstChild(element, "removed-translation-keys")));
        version.setNewSetupKeys(this.readItems(this.firstChild(element, "new-setup-keys")));
        version.setRemovedSetupKeys(this.readItems(this.firstChild(element, "removed-setup-keys")));
        version.setNewCssClasses(this.readItems(this.firstChild(element, "new-css-classes")));
        version.setRemovedCssClasses(this.readItems(this.firstChild(element, "removed-css-classes")));
        return version;
    }
}

