/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class AccountFeeLogPeriodMigration
implements UntraceableMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        Timestamp startingAt = CoercionHelper.coerce(Timestamp.class, new GregorianCalendar(2009, 2, 12));
        ResultSet fees = jdbc.query("select * from account_fees where run_mode = ? and enabled_since >= ?", "S", startingAt);
        try {
            while (fees.next()) {
                long feeId = fees.getLong("id");
                int recurrenceNumber = fees.getInt("recurrence_number");
                TimePeriod.Field recurrenceField = TimePeriod.Field.findByCalendarField(fees.getInt("recurrence_field"));
                if (recurrenceField.compareTo(TimePeriod.Field.WEEKS) <= 0) continue;
                TimePeriod recurrence = new TimePeriod(recurrenceNumber, recurrenceField);
                ResultSet logs = jdbc.updatableQuery("select * from account_fee_logs where account_fee_id = ?", feeId);
                try {
                    while (logs.next()) {
                        Calendar begin = CoercionHelper.coerce(Calendar.class, logs.getTimestamp("begin_date"));
                        Period period = recurrence.currentPeriod(begin);
                        Calendar executionDate = CoercionHelper.coerce(Calendar.class, logs.getTimestamp("date"));
                        boolean inconsistent = false;
                        if (period.includes(executionDate)) {
                            period = recurrence.periodEndingAt(period.getBegin());
                            inconsistent = true;
                        } else if (begin.get(5) != 1) {
                            inconsistent = true;
                        }
                        if (!inconsistent) continue;
                        logs.updateTimestamp("begin_date", CoercionHelper.coerce(Timestamp.class, period.getBegin()));
                        logs.updateTimestamp("end_date", CoercionHelper.coerce(Timestamp.class, period.getEnd()));
                        logs.updateRow();
                    }
                }
                finally {
                    JDBCWrapper.closeQuietly(logs);
                }
            }
        }
        finally {
            JDBCWrapper.closeQuietly(fees);
        }
    }
}

