/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class AccountStatusRecreationMigration
implements UntraceableMigration {
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        String accountQuery = "select id, subclass, credit_limit, upper_credit_limit from accounts";
        String transferQuery = "select id, date, amount, status ,from_account_id, to_account_id, parent_id, account_fee_log_id from transfers where from_account_id = ? or to_account_id = ? order by date, id";
        String initialStatusInsert = "insert into account_status (subclass, account_id, date, credit_limit, upper_credit_limit) select subclass, id, creation_date, credit_limit, upper_credit_limit from accounts";
        String statusInsert = "insert into account_status (subclass, account_id, date, root_credits_count, root_credits_amount, root_debits_count, root_debits_amount, nested_credits_count, nested_credits_amount, nested_debits_count, nested_debits_amount, pending_credits_amount, pending_credits_count, pending_debits_amount, pending_debits_count, credit_limit, upper_credit_limit, transfer_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        ResultSet rsAccounts = jdbc.query("select id, subclass, credit_limit, upper_credit_limit from accounts", new Object[0]);
        LocalSettings settings = new LocalSettings();
        LocalSettings.Precision precision = CoercionHelper.coerce(LocalSettings.Precision.class, jdbc.readScalarAsString("select value from settings where name=?", "precision"));
        if (precision != null) {
            settings.setPrecision(precision);
        }
        jdbc.execute("insert into account_status (subclass, account_id, date, credit_limit, upper_credit_limit) select subclass, id, creation_date, credit_limit, upper_credit_limit from accounts", new Object[0]);
        while (rsAccounts.next()) {
            long accountId = rsAccounts.getLong("id");
            String subclass = rsAccounts.getString("subclass");
            BigDecimal creditLimit = settings.round(rsAccounts.getBigDecimal("credit_limit"));
            BigDecimal upperCreditLimit = settings.round(rsAccounts.getBigDecimal("upper_credit_limit"));
            BigDecimal rootCreditsAmount = BigDecimal.ZERO;
            int rootCreditsCount = 0;
            BigDecimal rootDebitsAmount = BigDecimal.ZERO;
            int rootDebitsCount = 0;
            BigDecimal nestedCreditsAmount = BigDecimal.ZERO;
            int nestedCreditsCount = 0;
            BigDecimal nestedDebitsAmount = BigDecimal.ZERO;
            int nestedDebitsCount = 0;
            BigDecimal pendingCreditsAmount = BigDecimal.ZERO;
            int pendingCreditsCount = 0;
            BigDecimal pendingDebitsAmount = BigDecimal.ZERO;
            int pendingDebitsCount = 0;
            ResultSet rsTransfers = jdbc.query("select id, date, amount, status ,from_account_id, to_account_id, parent_id, account_fee_log_id from transfers where from_account_id = ? or to_account_id = ? order by date, id", accountId, accountId);
            while (rsTransfers.next()) {
                long transferId = rsTransfers.getLong("id");
                Timestamp date = rsTransfers.getTimestamp("date");
                BigDecimal amount = settings.round(rsTransfers.getBigDecimal("amount"));
                long fromAccountId = rsTransfers.getLong("from_account_id");
                boolean isRoot = rsTransfers.getString("parent_id") == null && rsTransfers.getString("account_fee_log_id") == null;
                String status = rsTransfers.getString("status");
                boolean isDebit = accountId == fromAccountId;
                boolean isProcessed = status.equals("O");
                boolean isPending = status.equals("P");
                if (!isPending && !isProcessed) continue;
                if (isDebit) {
                    if (isRoot) {
                        if (isProcessed) {
                            rootDebitsAmount = rootDebitsAmount.add(amount);
                            ++rootDebitsCount;
                        } else if (isPending) {
                            pendingDebitsAmount = pendingDebitsAmount.add(amount);
                            ++pendingDebitsCount;
                        }
                    } else if (isProcessed) {
                        nestedDebitsAmount = nestedDebitsAmount.add(amount);
                        ++nestedDebitsCount;
                    } else if (isPending) {
                        pendingDebitsAmount = pendingDebitsAmount.add(amount);
                        ++pendingDebitsCount;
                    }
                } else if (isRoot) {
                    if (isProcessed) {
                        rootCreditsAmount = rootCreditsAmount.add(amount);
                        ++rootCreditsCount;
                    } else if (isPending) {
                        pendingCreditsAmount = pendingCreditsAmount.add(amount);
                        ++pendingCreditsCount;
                    }
                } else if (isProcessed) {
                    nestedCreditsAmount = nestedCreditsAmount.add(amount);
                    ++nestedCreditsCount;
                } else if (isPending) {
                    pendingCreditsAmount = pendingCreditsAmount.add(amount);
                    ++pendingCreditsCount;
                }
                jdbc.execute("insert into account_status (subclass, account_id, date, root_credits_count, root_credits_amount, root_debits_count, root_debits_amount, nested_credits_count, nested_credits_amount, nested_debits_count, nested_debits_amount, pending_credits_amount, pending_credits_count, pending_debits_amount, pending_debits_count, credit_limit, upper_credit_limit, transfer_id) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", subclass, accountId, date, rootCreditsCount, rootCreditsAmount, rootDebitsCount, rootDebitsAmount, nestedCreditsCount, nestedCreditsAmount, nestedDebitsCount, nestedDebitsAmount, pendingCreditsAmount, pendingCreditsCount, pendingDebitsAmount, pendingDebitsCount, creditLimit, upperCreditLimit, transferId);
            }
            JDBCWrapper.closeQuietly(rsTransfers);
        }
        JDBCWrapper.closeQuietly(rsAccounts);
    }
}

