/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class BrokeringCommissionStatusMigration
implements UntraceableMigration {
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        String selectBrokerCommissions = "select id, when_apply, when_count, amount, amount_type from transaction_fees where subclass = 'B'";
        String selectBrokerings = "select id, broker_id, start_date, commission_end_date from brokerings";
        String selectFees = "select sum(t.amount) as total_sum, count(*) as total_count, max(t.date) as max_date from transfers t inner join accounts a on t.to_account_id = a.id where t.transaction_fee_id = ? and a.member_id = ?";
        String insertBrokeringCommissionStatus = "insert into brokering_commission_status (creation_date, brokering_id, broker_commission_id, start_date, end_date, expiry_date, total_count, total_amount, amount, amount_type, when_apply) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        Timestamp today = new Timestamp(DateHelper.truncate(Calendar.getInstance()).getTimeInMillis());
        ResultSet rsBrokerCommissions = jdbc.query("select id, when_apply, when_count, amount, amount_type from transaction_fees where subclass = 'B'", new Object[0]);
        while (rsBrokerCommissions.next()) {
            Long brokerCommissionId = rsBrokerCommissions.getLong("id");
            String whenString = rsBrokerCommissions.getString("when_apply");
            BrokerCommission.When when = CoercionHelper.coerce(BrokerCommission.When.class, whenString);
            Integer whenCount = rsBrokerCommissions.getInt("when_count");
            String feeAmount = rsBrokerCommissions.getString("amount");
            String feeAmountType = rsBrokerCommissions.getString("amount_type");
            ResultSet rsBrokerings = jdbc.query("select id, broker_id, start_date, commission_end_date from brokerings", new Object[0]);
            while (rsBrokerings.next()) {
                Long brokeringId = rsBrokerings.getLong("id");
                Long brokerId = rsBrokerings.getLong("broker_id");
                Timestamp brokeringStartDate = rsBrokerings.getTimestamp("start_date");
                Timestamp brokeringCommissionEndDate = rsBrokerings.getTimestamp("commission_end_date");
                Object[] feesParams = new Object[]{brokerCommissionId, brokerId};
                ResultSet rsFees = jdbc.query("select sum(t.amount) as total_sum, count(*) as total_count, max(t.date) as max_date from transfers t inner join accounts a on t.to_account_id = a.id where t.transaction_fee_id = ? and a.member_id = ?", feesParams);
                rsFees.next();
                BigDecimal amount = rsFees.getBigDecimal("total_sum");
                if (amount == null) {
                    amount = new BigDecimal(0.0);
                }
                Integer count = rsFees.getInt("total_count");
                Timestamp maxDate = rsFees.getTimestamp("max_date");
                JDBCWrapper.closeQuietly(rsFees);
                Timestamp expiryDate = null;
                if (when == BrokerCommission.When.COUNT) {
                    if (count >= whenCount && brokeringCommissionEndDate == null) {
                        brokeringCommissionEndDate = maxDate;
                    }
                } else if (when == BrokerCommission.When.DAYS && today.compareTo(expiryDate = this.calculateExpiryDate(brokeringStartDate, count)) > 0 && brokeringCommissionEndDate == null) {
                    brokeringCommissionEndDate = expiryDate;
                }
                Object[] brokeringCommissionStatusParams = new Object[]{Calendar.getInstance(), brokeringId, brokerCommissionId, brokeringStartDate, brokeringCommissionEndDate, expiryDate, count, amount, feeAmount, feeAmountType, when.getValue()};
                jdbc.execute("insert into brokering_commission_status (creation_date, brokering_id, broker_commission_id, start_date, end_date, expiry_date, total_count, total_amount, amount, amount_type, when_apply) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", brokeringCommissionStatusParams);
            }
            JDBCWrapper.closeQuietly(rsBrokerings);
        }
        JDBCWrapper.closeQuietly(rsBrokerCommissions);
        String dropBrokeringCommissionEndDate = "alter table brokerings drop column commission_end_date";
        jdbc.execute("alter table brokerings drop column commission_end_date", new Object[0]);
        String dropBrokeringNotes = "alter table brokerings drop column notes";
        jdbc.execute("alter table brokerings drop column notes", new Object[0]);
    }

    private Timestamp calculateExpiryDate(Timestamp startDate, int days) {
        Calendar date = Calendar.getInstance();
        date.setTime(startDate);
        date.add(5, days);
        return new Timestamp(date.getTimeInMillis());
    }
}

