/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ResourceBundle;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.setup.CreateBasicData;
import nl.strohalm.cyclos.setup.Setup;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class ChannelsMigration
implements UntraceableMigration {
    private Long webId;
    private Long wap1Id;
    private Long wap2Id;
    private Long webShopId;
    private Long posWebId;
    private ResourceBundle resourceBundle;

    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        String languageStr = jdbc.readScalarAsString("select value from settings where name='language'", new Object[0]);
        LocalSettings.Language language = CoercionHelper.coerce(LocalSettings.Language.class, languageStr);
        this.resourceBundle = Setup.getResourceBundle(language.getLocale());
        this.insertChannels(jdbc);
        this.initChannelIds(jdbc);
        this.associateChannelsToGroups(jdbc);
        this.associateChannelsToTransferTypes(jdbc);
        this.associateChannelsToMembers(jdbc);
        this.cleanDB(jdbc);
    }

    private void associateChannelsToGroups(JDBCWrapper jdbc) throws SQLException {
        ResultSet groups = jdbc.query("select id, mobile_service from groups where subclass in ('M', 'B') and status = 'N'", new Object[0]);
        String relateGroupSql = "insert into groups_channels (group_id, channel_id) values (?, ?)";
        while (groups.next()) {
            long groupId = groups.getLong("id");
            jdbc.execute("insert into groups_channels (group_id, channel_id) values (?, ?)", groupId, this.webId);
            String mobileService = groups.getString("mobile_service");
            if ("BOTH".equals(mobileService) || "WAP2_ONLY".equals(mobileService)) {
                jdbc.execute("insert into groups_channels (group_id, channel_id) values (?, ?)", groupId, this.wap2Id);
            }
            if (!"BOTH".equals(mobileService)) continue;
            jdbc.execute("insert into groups_channels (group_id, channel_id) values (?, ?)", groupId, this.wap1Id);
        }
        JDBCWrapper.closeQuietly(groups);
        String insertDefaultChannelsSql = "insert into groups_default_channels (group_id, channel_id) select group_id, channel_id from groups_channels";
        jdbc.execute("insert into groups_default_channels (group_id, channel_id) select group_id, channel_id from groups_channels", new Object[0]);
    }

    private void associateChannelsToMembers(JDBCWrapper jdbc) throws SQLException {
        StringBuilder associateChannelsToMembersSql = new StringBuilder();
        associateChannelsToMembersSql.append(" insert into members_channels (member_id, channel_id)");
        associateChannelsToMembersSql.append(" select m.id, c.id from members m ");
        associateChannelsToMembersSql.append(" inner join groups g on m.group_id = g.id ");
        associateChannelsToMembersSql.append(" inner join groups_channels gc on gc.group_id = g.id ");
        associateChannelsToMembersSql.append(" inner join channels c on gc.channel_id = c.id ");
        jdbc.execute(associateChannelsToMembersSql.toString(), new Object[0]);
    }

    private void associateChannelsToTransferTypes(JDBCWrapper jdbc) throws SQLException {
        String associateChannelToTTSql = "insert into transfer_types_channels (transfer_type_id, channel_id) values (?, ?)";
        String enableTransferTypeSql = "update transfer_types set allowed_payment=true where id = ?";
        ResultSet directPaymentTTs = jdbc.query("select id from transfer_types where allowed_payment = true", new Object[0]);
        while (directPaymentTTs.next()) {
            long transferTypeId = directPaymentTTs.getLong("id");
            jdbc.execute("insert into transfer_types_channels (transfer_type_id, channel_id) values (?, ?)", transferTypeId, this.webId);
        }
        JDBCWrapper.closeQuietly(directPaymentTTs);
        ResultSet mobileTTs = jdbc.query("select id from transfer_types where allowed_mobile = true", new Object[0]);
        while (mobileTTs.next()) {
            long transferTypeId = mobileTTs.getLong("id");
            jdbc.execute("insert into transfer_types_channels (transfer_type_id, channel_id) values (?, ?)", transferTypeId, this.wap1Id);
            jdbc.execute("insert into transfer_types_channels (transfer_type_id, channel_id) values (?, ?)", transferTypeId, this.wap2Id);
            jdbc.execute("update transfer_types set allowed_payment=true where id = ?", transferTypeId);
        }
        JDBCWrapper.closeQuietly(mobileTTs);
        ResultSet webShopTTs = jdbc.query("select id from transfer_types where allowed_external_payment = true", new Object[0]);
        while (webShopTTs.next()) {
            long transferTypeId = webShopTTs.getLong("id");
            jdbc.execute("insert into transfer_types_channels (transfer_type_id, channel_id) values (?, ?)", transferTypeId, this.webShopId);
            jdbc.execute("insert into transfer_types_channels (transfer_type_id, channel_id) values (?, ?)", transferTypeId, this.posWebId);
            jdbc.execute("update transfer_types set allowed_payment=true where id = ?", transferTypeId);
        }
        JDBCWrapper.closeQuietly(webShopTTs);
    }

    private void cleanDB(JDBCWrapper jdbc) throws SQLException {
        jdbc.execute("alter table groups drop column mobile_service", new Object[0]);
        jdbc.execute("alter table transfer_types drop column allowed_external_payment", new Object[0]);
        jdbc.execute("alter table transfer_types drop column allowed_mobile", new Object[0]);
    }

    private void initChannelIds(JDBCWrapper jdbc) throws SQLException {
        String selectChannelId = "select id from channels where internal_name = ?";
        this.webId = jdbc.readScalarAsLong("select id from channels where internal_name = ?", "web");
        this.wap1Id = jdbc.readScalarAsLong("select id from channels where internal_name = ?", "wap1");
        this.wap2Id = jdbc.readScalarAsLong("select id from channels where internal_name = ?", "wap2");
        this.webShopId = jdbc.readScalarAsLong("select id from channels where internal_name = ?", "webshop");
        this.posWebId = jdbc.readScalarAsLong("select id from channels where internal_name = ?", "posweb");
    }

    private void insertChannels(JDBCWrapper jdbc) throws SQLException {
        String insert = "insert into channels (internal_name, display_name, use_pin) values (?, ?, ?)";
        List<Channel> builtinChannels = CreateBasicData.getBuiltinChannels(this.resourceBundle);
        for (Channel channel : builtinChannels) {
            jdbc.execute("insert into channels (internal_name, display_name, use_pin) values (?, ?, ?)", channel.getInternalName(), channel.getDisplayName(), "posweb".equals(channel.getInternalName()));
        }
    }
}

