/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;

public class GroupHistoryLogMigration
implements UntraceableMigration {
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        String elementsQuery = "select id, creation_date, group_id from members";
        String groupRemarksQuery = "select r.old_group_id, r.new_group_id, r.date from remarks r where r.subclass='G' and r.subject_id = ? order by r.date";
        String insertGroupHistoryLog = "insert into group_history_logs (element_id, group_id, start_date) values (?, ?, ?)";
        String groupHistoryLogsQuery = "select * from group_history_logs where element_id = ? order by start_date";
        ResultSet rsElements = jdbc.query("select id, creation_date, group_id from members", new Object[0]);
        while (rsElements.next()) {
            Long elementId = rsElements.getLong("id");
            Timestamp creationDate = rsElements.getTimestamp("creation_date");
            Long currentGroupId = rsElements.getLong("group_id");
            Long firstGroupId = null;
            ResultSet rsGroupRemarks = jdbc.query("select r.old_group_id, r.new_group_id, r.date from remarks r where r.subclass='G' and r.subject_id = ? order by r.date", elementId);
            firstGroupId = rsGroupRemarks.next() ? Long.valueOf(rsGroupRemarks.getLong("old_group_id")) : currentGroupId;
            JDBCWrapper.closeQuietly(rsGroupRemarks);
            Object[] insertGroupHistoryLogParameters = new Object[]{elementId, firstGroupId, creationDate};
            jdbc.execute("insert into group_history_logs (element_id, group_id, start_date) values (?, ?, ?)", insertGroupHistoryLogParameters);
            rsGroupRemarks = jdbc.query("select r.old_group_id, r.new_group_id, r.date from remarks r where r.subclass='G' and r.subject_id = ? order by r.date", elementId);
            while (rsGroupRemarks.next()) {
                Long groupId = rsGroupRemarks.getLong("new_group_id");
                Timestamp start = rsGroupRemarks.getTimestamp("date");
                insertGroupHistoryLogParameters = new Object[]{elementId, groupId, start};
                jdbc.execute("insert into group_history_logs (element_id, group_id, start_date) values (?, ?, ?)", insertGroupHistoryLogParameters);
            }
            JDBCWrapper.closeQuietly(rsGroupRemarks);
            ResultSet rsGroupHistoryLogs = jdbc.updatableQuery("select * from group_history_logs where element_id = ? order by start_date", elementId);
            rsGroupHistoryLogs.next();
            while (rsGroupHistoryLogs.next()) {
                Timestamp end = rsGroupHistoryLogs.getTimestamp("start_date");
                rsGroupHistoryLogs.previous();
                rsGroupHistoryLogs.updateTimestamp("end_date", end);
                rsGroupHistoryLogs.updateRow();
                rsGroupHistoryLogs.next();
            }
            JDBCWrapper.closeQuietly(rsGroupHistoryLogs);
        }
        JDBCWrapper.closeQuietly(rsElements);
    }
}

