/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import org.apache.commons.lang.StringUtils;

public class LoanCustomFieldMigration
implements UntraceableMigration {
    public static void main(String[] args) throws Exception {
        Class.forName("com.mysql.jdbc.Driver");
        Connection conn = DriverManager.getConnection("jdbc:mysql://localhost/cyclos3_new", "root", "");
        try {
            conn.setAutoCommit(false);
            JDBCWrapper jdbc = new JDBCWrapper(conn);
            new LoanCustomFieldMigration().execute(jdbc);
            conn.commit();
        }
        catch (Exception e) {
            conn.rollback();
            throw e;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        ResultSet loanCustomFields = jdbc.query("select * from custom_fields where subclass = ?", "loan");
        try {
            while (loanCustomFields.next()) {
                long loanCustomFieldId = loanCustomFields.getLong("id");
                HashMap<Long, Long> loanCustomFieldMap = new HashMap<Long, Long>();
                HashMap<Long, Long> possibleValuesMap = new HashMap<Long, Long>();
                ResultSet loanTransferTypes = jdbc.query("select id from transfer_types where loan_type is not null", new Object[0]);
                try {
                    while (loanTransferTypes.next()) {
                        long transferTypeId = loanTransferTypes.getLong("id");
                        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                        values.put("subclass", "pmt");
                        values.put("internal_name", loanCustomFields.getString("internal_name"));
                        values.put("name", loanCustomFields.getString("name"));
                        values.put("order_number", loanCustomFields.getString("order_number"));
                        values.put("type", loanCustomFields.getString("type"));
                        values.put("control", loanCustomFields.getString("control"));
                        values.put("size", loanCustomFields.getString("size"));
                        values.put("val_required", loanCustomFields.getBoolean("val_required"));
                        values.put("val_unique", loanCustomFields.getBoolean("val_unique"));
                        values.put("val_min_length", loanCustomFields.getString("val_min_length"));
                        values.put("val_max_length", loanCustomFields.getString("val_max_length"));
                        values.put("all_selected_label", loanCustomFields.getString("all_selected_label"));
                        values.put("pattern", loanCustomFields.getString("pattern"));
                        values.put("description", loanCustomFields.getString("description"));
                        values.put("parent_id", loanCustomFields.getString("parent_id"));
                        values.put("transfer_type_id", transferTypeId);
                        values.put("payment_search_access", loanCustomFields.getBoolean("loan_show_in_search") ? PaymentCustomField.Access.BOTH_ACCOUNTS.getValue() : PaymentCustomField.Access.NONE.getValue());
                        values.put("payment_list_access", loanCustomFields.getBoolean("loan_show_in_payment_results") ? PaymentCustomField.Access.BOTH_ACCOUNTS.getValue() : PaymentCustomField.Access.NONE.getValue());
                        Object[] placeHolders = new String[values.size()];
                        Arrays.fill(placeHolders, "?");
                        jdbc.execute("insert into custom_fields (" + StringUtils.join(values.keySet().iterator(), (char)',') + ") values (" + StringUtils.join((Object[])placeHolders, (char)',') + ")", values.values().toArray());
                        long newCustomFieldId = jdbc.readScalarAsLong("select last_insert_id()", new Object[0]);
                        loanCustomFieldMap.put(transferTypeId, newCustomFieldId);
                        ResultSet possibleValues = jdbc.query("select * from custom_field_possible_values where field_id = ?", loanCustomFieldId);
                        try {
                            while (possibleValues.next()) {
                                long oldPossibleValueId = possibleValues.getLong("id");
                                String value = possibleValues.getString("value");
                                jdbc.execute("insert into custom_field_possible_values (field_id, value) values (?, ?)", newCustomFieldId, value);
                                long newPossibleValueId = jdbc.readScalarAsLong("select last_insert_id()", new Object[0]);
                                possibleValuesMap.put(oldPossibleValueId, newPossibleValueId);
                            }
                        }
                        finally {
                            JDBCWrapper.closeQuietly(possibleValues);
                        }
                    }
                }
                finally {
                    JDBCWrapper.closeQuietly(loanTransferTypes);
                }
                ResultSet fieldValues = jdbc.query("select fv.*, t.type_id as transfer_type_id from custom_field_values fv inner join loans l on fv.loan_id = l.id inner join transfers t on l.transfer_id = t.id where fv.field_id = ?", loanCustomFieldId);
                try {
                    while (fieldValues.next()) {
                        long fieldValueId = fieldValues.getLong("id");
                        long loanId = fieldValues.getLong("loan_id");
                        long newCustomFieldId = (Long)loanCustomFieldMap.get(fieldValues.getLong("transfer_type_id"));
                        Long newPossibleValueId = (Long)possibleValuesMap.get(fieldValues.getLong("possible_value_id"));
                        long transferId = jdbc.readScalarAsLong("select transfer_id from loans where id=?", loanId);
                        jdbc.execute("update custom_field_values set subclass=?, loan_id=null, transfer_id=?, field_id=?, possible_value_id=? where id=?", "pmt", transferId, newCustomFieldId, newPossibleValueId, fieldValueId);
                    }
                }
                finally {
                    JDBCWrapper.closeQuietly(fieldValues);
                }
                jdbc.execute("delete from custom_field_possible_values where field_id=?", loanCustomFieldId);
                jdbc.execute("delete from custom_fields where id=?", loanCustomFieldId);
            }
        }
        finally {
            JDBCWrapper.closeQuietly(loanCustomFields);
        }
        try {
            jdbc.execute("alter table custom_field_values drop foreign key FK8AE18A15F9B21025", new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jdbc.execute("alter table custom_field_values drop column loan_id", new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jdbc.execute("alter table custom_fields drop column loan_show_in_search", new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            jdbc.execute("alter table custom_fields drop column loan_show_in_payment_results", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

