/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.HashHandler;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import org.apache.commons.lang.StringUtils;

public class PasswordHashMigration
implements UntraceableMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        String select = "select id, password, transaction_password from users";
        String update = "update users set password = ?, transaction_password = ? where id = ?";
        ResultSet rs = jdbc.query("select id, password, transaction_password from users", new Object[0]);
        try {
            while (rs.next()) {
                long id = rs.getLong("id");
                String password = StringUtils.trimToNull((String)rs.getString("password"));
                String transactionPassword = StringUtils.trimToNull((String)rs.getString("transaction_password"));
                if (password == null && transactionPassword == null) continue;
                String newPassword = password == null ? null : HashHandler.sha2(password.toUpperCase());
                String newTransactionPassword = transactionPassword == null ? null : HashHandler.sha2(transactionPassword.toUpperCase());
                jdbc.execute("update users set password = ?, transaction_password = ? where id = ?", newPassword, newTransactionPassword, id);
            }
        }
        finally {
            JDBCWrapper.closeQuietly(rs);
        }
    }
}

