/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_5;

import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.setup.UntraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;

public class TransactionFeesMigration
implements UntraceableMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(JDBCWrapper jdbc) throws SQLException {
        String simple = TransactionFee.Nature.SIMPLE.getValue();
        String feesSelect = "select * from transaction_fees";
        String feesUpdate = "update transaction_fees set payer=?, receiver=?, which_broker=? where id=?";
        ResultSet fees = jdbc.query("select * from transaction_fees", new Object[0]);
        try {
            while (fees.next()) {
                long id = fees.getLong("id");
                String subclass = fees.getString("subclass");
                TransferTypeDescriptor original = TransferTypeDescriptor.fromId(fees.getLong("original_type_id"), jdbc);
                TransferTypeDescriptor generated = TransferTypeDescriptor.fromId(fees.getLong("generated_type_id"), jdbc);
                TransactionFee.Subject payer = null;
                TransactionFee.Subject receiver = null;
                BrokerCommission.WhichBroker whichBroker = null;
                if (generated.fromSystem) {
                    payer = TransactionFee.Subject.SYSTEM;
                } else {
                    String whoPays = fees.getString("who_pays");
                    TransactionFee.Subject subject = payer = "D".equals(whoPays) ? TransactionFee.Subject.DESTINATION : TransactionFee.Subject.SOURCE;
                }
                if (simple.equals(subclass)) {
                    if (generated.toSystem) {
                        receiver = TransactionFee.Subject.SYSTEM;
                    } else if (!original.fromSystem) {
                        receiver = TransactionFee.Subject.SOURCE;
                    } else if (!original.toSystem) {
                        receiver = TransactionFee.Subject.DESTINATION;
                    }
                } else {
                    whichBroker = BrokerCommission.WhichBroker.SOURCE;
                }
                String payerValue = payer == null ? null : payer.getValue();
                String receiverValue = receiver == null ? null : receiver.getValue();
                String whichBrokerValue = whichBroker == null ? null : whichBroker.getValue();
                jdbc.execute("update transaction_fees set payer=?, receiver=?, which_broker=? where id=?", payerValue, receiverValue, whichBrokerValue, id);
            }
        }
        finally {
            JDBCWrapper.closeQuietly(fees);
        }
        jdbc.execute("alter table transaction_fees drop column who_pays", new Object[0]);
    }

    private static class TransferTypeDescriptor {
        private boolean fromSystem;
        private boolean toSystem;

        private TransferTypeDescriptor() {
        }

        private static TransferTypeDescriptor fromId(long id, JDBCWrapper jdbc) throws SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append(" select f.subclass as from_class, t.subclass as to_class");
            sql.append(" from transfer_types tt");
            sql.append("    inner join account_types as f on tt.from_account_type_id = f.id");
            sql.append("    inner join account_types as t on tt.to_account_type_id = t.id");
            sql.append(" where tt.id = ?");
            ResultSet rs = jdbc.query(sql.toString(), id);
            TransferTypeDescriptor tt = null;
            if (rs.next()) {
                String system = AccountType.Nature.SYSTEM.getValue();
                tt = new TransferTypeDescriptor();
                tt.fromSystem = system.equals(rs.getString("from_class"));
                tt.toSystem = system.equals(rs.getString("to_class"));
            }
            JDBCWrapper.closeQuietly(rs);
            return tt;
        }
    }
}

