/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_6;

import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.setup.TraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;

public class ChangeImagesColumnsMigration
implements TraceableMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JDBCWrapper jdbc) throws SQLException {
        ResultSet imageResult = jdbc.query("show columns from images where Field = 'image'", new Object[0]);
        ResultSet thumbnailResult = jdbc.query("show columns from images where Field = 'thumbnail'", new Object[0]);
        try {
            imageResult.next();
            String imageColumnType = imageResult.getString("Type");
            Boolean imageNullable = imageResult.getBoolean("Null");
            boolean shouldAlterImageColumn = !imageColumnType.equals("mediumblob") || imageNullable != false;
            thumbnailResult.next();
            String thumbnailColumnType = thumbnailResult.getString("Type");
            Boolean thumbnailNullable = thumbnailResult.getBoolean("Null");
            boolean shouldAlterThumbnailColumn = !thumbnailColumnType.equals("mediumblob") || thumbnailNullable == false;
            int modifiedRows = 0;
            if (shouldAlterImageColumn && shouldAlterThumbnailColumn) {
                modifiedRows = jdbc.execute("alter table images modify column image mediumblob not null, modify column thumbnail mediumblob default null", new Object[0]);
            } else if (shouldAlterImageColumn) {
                modifiedRows = jdbc.execute("alter table images modify column image mediumblob not null", new Object[0]);
            } else if (shouldAlterThumbnailColumn) {
                modifiedRows = jdbc.execute("alter table images modify column thumbnail mediumblob default null", new Object[0]);
            }
            int n = modifiedRows;
            return n;
        }
        finally {
            JDBCWrapper.closeQuietly(imageResult);
            JDBCWrapper.closeQuietly(thumbnailResult);
        }
    }
}

