/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_6;

import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.access.Module;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.access.Permission;
import nl.strohalm.cyclos.setup.TraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangePermissionSchemeMigration
implements TraceableMigration {
    private static final Log LOG = LogFactory.getLog(ChangePermissionSchemeMigration.class);

    @Override
    public int execute(JDBCWrapper jdbc) throws SQLException {
        jdbc.execute("ALTER TABLE permissions ADD COLUMN permission varchar(100)", new Object[0]);
        ResultSet rs = jdbc.query("SELECT id, message_key FROM operations", new Object[0]);
        int updatedRows = 0;
        while (rs.next()) {
            String messageKey = rs.getString("message_key");
            int operationId = rs.getInt("id");
            Permission p = this.findPermission(messageKey);
            if (p == null) continue;
            updatedRows += jdbc.execute("update permissions set permission=? where operation_id=?", p.getQualifiedName(), operationId);
        }
        updatedRows += jdbc.execute("delete from permissions where permission is null or permission = ''", new Object[0]);
        jdbc.execute("ALTER TABLE permissions modify permission varchar(100) not null", new Object[0]);
        LOG.info((Object)"Dropping table modules...");
        jdbc.execute("ALTER TABLE operations DROP FOREIGN KEY FK3FD7EC7FE57DC", new Object[0]);
        jdbc.execute("DROP TABLE modules", new Object[0]);
        LOG.info((Object)"Dropping table operations...");
        jdbc.execute("ALTER TABLE permissions DROP FOREIGN KEY FK4392F48486D11B78", new Object[0]);
        jdbc.execute("ALTER TABLE permissions DROP column operation_id", new Object[0]);
        jdbc.execute("DROP TABLE operations", new Object[0]);
        return updatedRows;
    }

    private Permission findPermission(String messageKey) {
        if (messageKey.equals("permission.operatorPayments.externalMakePayment")) {
            return OperatorPermission.PAYMENTS_POSWEB_MAKE_PAYMENT;
        }
        if (messageKey.equals("permission.operatorPayments.externalReceivePayment")) {
            return OperatorPermission.PAYMENTS_POSWEB_RECEIVE_PAYMENT;
        }
        for (Module m : Module.values()) {
            for (Permission p : m.getPermissions()) {
                String tmp = "permission." + p.getValue();
                if (!tmp.equals(messageKey)) continue;
                return p;
            }
        }
        return null;
    }
}

