/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_6;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.setup.TraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import org.apache.commons.lang.time.DateUtils;

public class ClosedAccountBalancesMigration
implements TraceableMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JDBCWrapper jdbc) throws SQLException {
        ResultSet accountStatusExists = null;
        try {
            accountStatusExists = jdbc.query("select 1 from account_status limit 1", new Object[0]);
        }
        catch (SQLException e) {
            int n;
            try {
                n = 0;
            }
            catch (Throwable throwable) {
                JDBCWrapper.closeQuietly(accountStatusExists);
                throw throwable;
            }
            JDBCWrapper.closeQuietly(accountStatusExists);
            return n;
        }
        JDBCWrapper.closeQuietly(accountStatusExists);
        jdbc.execute("insert into account_limit_logs  (account_id, date, by_id, credit_limit, upper_credit_limit)  select account_id, date, credit_limit_by_id, credit_limit, upper_credit_limit from account_status where credit_limit_by_id is not null", new Object[0]);
        jdbc.execute("insert into account_limit_logs  (account_id, date, by_id, credit_limit, upper_credit_limit)  select account_id, date, by_id, lower_limit, upper_limit from pending_account_status where type = 'lim'", new Object[0]);
        jdbc.execute("insert into amount_reservations (subclass, account_id, date, amount, transfer_id) select 'P', from_account_id, date, amount, id  from transfers t  where t.status = ? ", Payment.Status.PENDING.getValue());
        jdbc.execute("insert into amount_reservations (subclass, account_id, date, amount, scheduled_payment_id) select 'S', from_account_id, date, amount, id  from scheduled_payments  where reserve_amount = true ", new Object[0]);
        jdbc.execute("insert into amount_reservations (subclass, account_id, date, amount, transfer_id) select 'I', t.from_account_id, ifnull(t.process_date, t.date), -t.amount, t.id  from transfers t inner join scheduled_payments sp on t.scheduled_payment_id = sp.id where sp.reserve_amount = true and t.status <> ? ", Payment.Status.SCHEDULED.getValue());
        int results = 0;
        ResultSet accounts = jdbc.query("select id, creation_date from accounts", new Object[0]);
        try {
            while (accounts.next()) {
                long accountId = accounts.getLong("id");
                java.sql.Date creationDate = new java.sql.Date(DateUtils.truncate((Date)accounts.getTimestamp("creation_date"), (int)5).getTime());
                ResultSet diffs = jdbc.query(" select * from (      select 'B' as type, b.date, b.balance as diff     from (          select date(date) as date, sum(amount) as balance          from (              select t.process_date as date,              case when t.chargeback_of_id is null then                  case when t.from_account_id = ? then -t.amount else t.amount end              else                  case when t.to_account_id = ? then t.amount else -t.amount end              end as amount              from transfers t              where (t.from_account_id = ? or t.to_account_id = ?)                and t.process_date is not null          ) t          group by date(date)      ) b      union      select 'R', date(r.date), sum(r.amount)      from amount_reservations r      where r.account_id = ?      group by date(r.date)  ) t  where date < current_date()  order by date", accountId, accountId, accountId, accountId, accountId);
                java.sql.Date lastDate = creationDate;
                double balance = 0.0;
                double reserved = 0.0;
                try {
                    boolean hasData = false;
                    while (diffs.next()) {
                        hasData = true;
                        boolean isBalance = "B".equals(diffs.getString("type"));
                        java.sql.Date date = diffs.getDate("date");
                        double diff = diffs.getDouble("diff");
                        if (!lastDate.equals(date)) {
                            results += jdbc.execute("insert into closed_account_balances (date, account_id, balance, reserved) values (?, ?, ?, ?)", this.nextDay(lastDate), accountId, balance, reserved);
                        }
                        if (isBalance) {
                            balance += diff;
                        } else {
                            reserved += diff;
                        }
                        lastDate = date;
                    }
                    if (hasData) {
                        results += jdbc.execute("insert into closed_account_balances (date, account_id, balance, reserved) values (?, ?, ?, ?)", this.nextDay(lastDate), accountId, balance, reserved);
                    }
                }
                finally {
                    JDBCWrapper.closeQuietly(diffs);
                }
                jdbc.execute("update accounts set last_closing_date = ? where id = ?", lastDate, accountId);
            }
        }
        finally {
            JDBCWrapper.closeQuietly(accounts);
        }
        jdbc.execute("drop table account_status", new Object[0]);
        jdbc.execute("drop table pending_account_status", new Object[0]);
        return results;
    }

    private java.sql.Date nextDay(java.sql.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return new java.sql.Date(calendar.getTimeInMillis());
    }
}

