/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_6;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import nl.strohalm.cyclos.setup.TraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.lucene.IndexHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForceReindexMigration
implements TraceableMigration {
    private static final Log LOG = LogFactory.getLog(ForceReindexMigration.class);

    @Override
    public int execute(JDBCWrapper jdbc) throws SQLException {
        File indexRoot = IndexHandler.resolveIndexRoot();
        if (indexRoot.exists()) {
            try {
                FileUtils.deleteDirectory((File)indexRoot);
                LOG.info((Object)("The index root directory (" + indexRoot + ") was removed successfully"));
            }
            catch (IOException e) {
                LOG.warn((Object)("Error removing the index root directory (" + indexRoot + "). Error: " + e.getMessage()));
            }
        }
        return 0;
    }
}

