/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.setup.migrations.version3_6;

import java.sql.ResultSet;
import java.sql.SQLException;
import nl.strohalm.cyclos.setup.TraceableMigration;
import nl.strohalm.cyclos.utils.JDBCWrapper;
import nl.strohalm.cyclos.utils.StringHelper;

public class RemoveMaskFromCustomFieldsMigration
implements TraceableMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JDBCWrapper jdbc) throws SQLException {
        String sql = " select fv.id, fv.string_value, f.pattern";
        sql = sql + " from custom_field_values fv";
        sql = sql + " inner join custom_fields f on fv.field_id = f.id";
        sql = sql + " where f.pattern is not null";
        sql = sql + "   and fv.string_value is not null";
        sql = sql + "   and length(fv.string_value) > 0";
        ResultSet values = jdbc.query(sql, new Object[0]);
        try {
            int modifiedRows = 0;
            while (values.next()) {
                String value = values.getString("string_value");
                long id = values.getLong("id");
                String mask = values.getString("pattern");
                String newValue = StringHelper.removeMask(mask, value);
                if (value.equals(newValue)) continue;
                modifiedRows += jdbc.execute("update custom_field_values set string_value = ? where id = ?", newValue, id);
            }
            int n = modifiedRows;
            return n;
        }
        finally {
            JDBCWrapper.closeQuietly(values);
        }
    }
}

