/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.spring;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class BaseSingletonFactoryBean<T>
implements FactoryBean<T>,
DisposableBean,
ApplicationContextAware {
    protected final Class<T> objectType;
    protected T object;
    protected ApplicationContext applicationContext;

    public BaseSingletonFactoryBean(Class<T> objectType) {
        this.objectType = objectType;
    }

    public void destroy() throws Exception {
        if (this.object instanceof DisposableBean) {
            ((DisposableBean)this.object).destroy();
        }
    }

    public final T getObject() throws Exception {
        Class<?> implementationClass = this.resolveImplementationClass();
        AutowireCapableBeanFactory acbf = this.applicationContext.getAutowireCapableBeanFactory();
        this.object = acbf.createBean(implementationClass, 1, false);
        return this.object;
    }

    public Class<?> getObjectType() {
        return this.objectType;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected abstract Class<?> resolveImplementationClass();
}

