/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.spring;

import nl.strohalm.cyclos.setup.DataBaseConfiguration;
import nl.strohalm.cyclos.utils.tasks.TaskRunner;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.function.ClassicAvgFunction;
import org.hibernate.dialect.function.ClassicCountFunction;
import org.hibernate.dialect.function.ClassicSumFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

public class CustomSessionFactoryBean
extends LocalSessionFactoryBean {
    private SessionFactoryImplementor sessionFactoryImplementor;
    private TaskRunner taskRunner;
    private DataBaseConfiguration dataBaseConfiguration;

    public void destroy() throws HibernateException {
        super.destroy();
        if (this.dataBaseConfiguration != null) {
            this.dataBaseConfiguration.release();
        }
    }

    public SessionFactoryImplementor getSessionFactoryImplementor() {
        return this.sessionFactoryImplementor;
    }

    public void setTaskRunner(TaskRunner taskRunner) {
        this.taskRunner = taskRunner;
    }

    protected SessionFactory newSessionFactory(Configuration config) throws HibernateException {
        this.dataBaseConfiguration = new DataBaseConfiguration(config, this.taskRunner);
        this.dataBaseConfiguration.run();
        SessionFactory sessionFactory = this.dataBaseConfiguration.getSessionFactory();
        if (sessionFactory == null) {
            sessionFactory = super.newSessionFactory(config);
        }
        this.sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
        return sessionFactory;
    }

    protected void postProcessConfiguration(Configuration config) throws HibernateException {
        config.addSqlFunction("count", (SQLFunction)new ClassicCountFunction());
        config.addSqlFunction("avg", (SQLFunction)new ClassicAvgFunction());
        config.addSqlFunction("sum", (SQLFunction)new ClassicSumFunction());
    }
}

