/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.spring;

import java.io.IOException;
import java.util.Properties;
import nl.strohalm.cyclos.CyclosConfiguration;
import nl.strohalm.cyclos.utils.CurrentApplicationContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class CustomWebApplicationContext
extends XmlWebApplicationContext {
    public String[] getConfigLocations() {
        Properties cyclosProperties;
        try {
            cyclosProperties = CyclosConfiguration.getCyclosProperties();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        boolean disableScheduling = Boolean.valueOf(cyclosProperties.getProperty("cyclos.disableScheduling", "false"));
        boolean disableWebServices = Boolean.valueOf(cyclosProperties.getProperty("cyclos.disableWebServices", "false"));
        boolean disableRest = Boolean.valueOf(cyclosProperties.getProperty("cyclos.disableRestServices", "false"));
        String[] configLocations = super.getConfigLocations();
        if (!disableScheduling) {
            configLocations = this.appendConfigLocations(configLocations, "schedulingConfigLocation");
        }
        if (!disableWebServices) {
            configLocations = this.appendConfigLocations(configLocations, "webServicesConfigLocation");
        }
        if (!disableRest) {
            configLocations = this.appendConfigLocations(configLocations, "restConfigLocation");
        }
        return configLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws BeansException, IllegalStateException {
        CurrentApplicationContext.CURRENT.set((ApplicationContext)this);
        try {
            super.refresh();
        }
        finally {
            CurrentApplicationContext.CURRENT.remove();
        }
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        DefaultListableBeanFactory beanFactory = super.createBeanFactory();
        beanFactory.setAllowRawInjectionDespiteWrapping(true);
        return beanFactory;
    }

    private String[] appendConfigLocations(String[] configLocations, String paramName) {
        String param = this.getServletContext().getInitParameter(paramName);
        Object[] locations = StringUtils.split((String)param, (String)" ,\n\r");
        configLocations = (String[])ArrayUtils.addAll((Object[])configLocations, (Object[])locations);
        return configLocations;
    }
}

