/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.spring;

import java.util.Properties;
import nl.strohalm.cyclos.spring.BaseSingletonFactoryBean;
import org.apache.commons.lang.StringUtils;

public class FactoryBeanFromProperties<T>
extends BaseSingletonFactoryBean<T> {
    protected final String propertyName;
    protected final Class<? extends T> defaultObjectType;
    protected Properties cyclosProperties;

    public FactoryBeanFromProperties(Class<T> objectType, String propertyName, Class<? extends T> defaultObjectType) {
        super(objectType);
        this.propertyName = propertyName;
        this.defaultObjectType = defaultObjectType;
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        this.cyclosProperties = cyclosProperties;
    }

    @Override
    protected final Class<?> resolveImplementationClass() {
        Class<?> implementationClass;
        String className = StringUtils.trimToNull((String)this.cyclosProperties.getProperty(this.propertyName));
        if (className == null) {
            return this.defaultObjectType;
        }
        try {
            implementationClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class specified in " + this.propertyName + " was not found: " + className);
        }
        if (!this.objectType.isAssignableFrom(implementationClass)) {
            throw new IllegalStateException("The class specified in " + this.propertyName + " was not assignable to " + this.objectType.getName() + ": " + className);
        }
        return implementationClass;
    }
}

