/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.spring;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.services.Service;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import org.apache.commons.lang.ClassUtils;

public class ServiceSecurityProxyInvocationHandler
implements InvocationHandler {
    private final Object bean;
    private final Class<?>[] serviceInterfaces;

    public ServiceSecurityProxyInvocationHandler(Object bean) {
        this.bean = bean;
        Class<?> clazz = bean.getClass();
        List interfaces = ClassUtils.getAllInterfaces(clazz);
        HashSet<Class> serviceInterfaces = new HashSet<Class>();
        for (Class iface : interfaces) {
            if (!Service.class.isAssignableFrom(clazz)) continue;
            serviceInterfaces.add(iface);
        }
        this.serviceInterfaces = serviceInterfaces.toArray(new Class[serviceInterfaces.size()]);
    }

    public Class<?>[] getServiceInterfaces() {
        return this.serviceInterfaces;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            try {
                return method.invoke(this.bean, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable t) {
            CurrentTransactionData.setError(t);
            throw t;
        }
    }
}

