/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.services.customization.TranslationChangeListener;
import nl.strohalm.cyclos.services.customization.TranslationMessageService;
import nl.strohalm.cyclos.utils.MessageResourcesLoadedListener;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.util.MessageResources;
import org.springframework.web.context.ServletContextAware;

public class CyclosMessageResources
extends MessageResources
implements ServletContextAware {
    private static final long serialVersionUID = 6706539088478972L;
    private ServletContext servletContext;
    private TranslationMessageService translationMessageService;
    private Properties properties;
    private List<MessageResourcesLoadedListener> messagesLoadedListeners = new ArrayList<MessageResourcesLoadedListener>();

    public CyclosMessageResources() {
        super(null, null);
    }

    public void addMessagesLoadedListener(MessageResourcesLoadedListener messagesLoadedListener) {
        this.messagesLoadedListeners.add(messagesLoadedListener);
    }

    public String getMessage(Locale locale, String key) {
        String message = this.getProperties().getProperty(key);
        if (message == null) {
            message = "???" + key + "???";
        }
        return message;
    }

    public void initialize() {
        this.translationMessageService.addTranslationChangeListener(new TranslationChangeListener(){

            @Override
            public void onTranslationsChanged(Properties properties) {
                CyclosMessageResources.this.reload(properties);
            }
        });
        this.reload(null);
        for (MessageResourcesLoadedListener messagesLoadedListener : this.messagesLoadedListeners) {
            messagesLoadedListener.onApplicationResourcesLoaded();
        }
        this.servletContext.setAttribute("org.apache.struts.action.MESSAGE", (Object)this);
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    public void setTranslationMessageService(TranslationMessageService translationMessageService) {
        this.translationMessageService = translationMessageService;
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.reload(null);
        }
        return this.properties;
    }

    private synchronized void reload(final Properties newProperties) {
        this.properties = LoggedUser.runAsSystem(new Callable<Properties>(){

            @Override
            public Properties call() throws Exception {
                Properties properties = CyclosMessageResources.this.translationMessageService.readFile(Locale.US);
                Properties dbProperties = newProperties == null ? CyclosMessageResources.this.translationMessageService.exportAsProperties() : newProperties;
                for (Map.Entry<Object, Object> entry : dbProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    properties.setProperty(key, value);
                }
                return properties;
            }
        });
        this.formats.clear();
    }
}

