/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.strohalm.cyclos.annotations.Inject;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.exceptions.LockingException;
import nl.strohalm.cyclos.entities.settings.events.LocalSettingsChangeListener;
import nl.strohalm.cyclos.exceptions.ApplicationException;
import nl.strohalm.cyclos.http.ResettableHttpServletRequest;
import nl.strohalm.cyclos.http.ResettableHttpServletResponse;
import nl.strohalm.cyclos.services.access.exceptions.SystemOfflineException;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.struts.CyclosControllerConfig;
import nl.strohalm.cyclos.utils.ActionHelper;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.ExceptionHelper;
import nl.strohalm.cyclos.utils.RequestHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.logging.LoggingHandler;
import nl.strohalm.cyclos.utils.logging.TraceLogDTO;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.SecureTilesRequestProcessor;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.engine.SessionFactoryImplementor;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class CyclosRequestProcessor
extends SecureTilesRequestProcessor {
    public static final String EXECUTION_RESULT_KEY = "cyclos.executionResult";
    public static final String NO_TRANSACTION_KEY = "cyclos.noTransactionManagement";
    private static final Log LOG = LogFactory.getLog(CyclosRequestProcessor.class);
    private SettingsService settingsService;
    private LoggingHandler loggingHandler;
    private SessionFactoryImplementor sessionFactory;
    private ConnectionProvider connectionProvider;
    private ActionHelper actionHelper;

    public SettingsService getSettingsService() {
        return this.settingsService;
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        super.init(servlet, moduleConfig);
        SpringHelper.injectBeans(servlet.getServletContext(), (Object)this);
        CyclosControllerConfig config = (CyclosControllerConfig)moduleConfig.getControllerConfig();
        this.settingsService.addListener(config);
        config.initialize(this.settingsService.getLocalSettings());
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            request.setAttribute(EXECUTION_RESULT_KEY, (Object)new ExecutionResult());
            super.process(request, response);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            this.cleanUpTransaction(request);
        }
    }

    @Inject
    public void setActionHelper(ActionHelper actionHelper) {
        this.actionHelper = actionHelper;
    }

    @Inject
    public void setLoggingHandler(LoggingHandler loggingHandler) {
        this.loggingHandler = loggingHandler;
    }

    @Inject
    public void setSessionFactory(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.connectionProvider = sessionFactory.getConnectionProvider();
    }

    @Inject
    public void setSettingsService(SettingsService settingsService) {
        this.settingsService = settingsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException {
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            Action action = (Action)this.actions.get(actionMapping.getType());
            if (action != null) {
                return action;
            }
            action = super.processActionCreate(request, response, actionMapping);
            if (action == null) {
                return null;
            }
            if (action instanceof LocalSettingsChangeListener) {
                this.settingsService.addListener((LocalSettingsChangeListener)action);
            }
            try {
                SpringHelper.injectBeans(this.getServletContext(), (Object)action);
            }
            catch (Exception e) {
                this.actions.remove(actionMapping.getType());
                LOG.error((Object)("Error injecting beans on " + action), (Throwable)e);
                throw new IllegalStateException(e);
            }
            return action;
        }
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) {
        HttpSession session = request.getSession();
        if (StringUtils.isEmpty((String)actionMapping.getName())) {
            return null;
        }
        if (RequestHelper.isFromMenu(request)) {
            session.removeAttribute(actionMapping.getName());
        }
        ActionForm form = super.processActionForm(request, response, actionMapping);
        if ("session".equals(actionMapping.getScope())) {
            HashSet<String> sessionForms = (HashSet<String>)session.getAttribute("sessionForms");
            if (sessionForms == null) {
                sessionForms = new HashSet<String>();
                session.setAttribute("sessionForms", sessionForms);
            }
            sessionForms.add(actionMapping.getName());
        }
        return form;
    }

    /*
     * Loose catch block
     */
    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        if (RequestHelper.isFromMenu(request)) {
            this.cleanSessionForms(request, form);
        }
        ResettableHttpServletRequest resetableRequest = new ResettableHttpServletRequest(request);
        ResettableHttpServletResponse resetableResponse = new ResettableHttpServletResponse(response);
        while (true) {
            try {
                ExecutionResult result = this.executeAction((HttpServletRequest)resetableRequest, resetableResponse, action, form, mapping);
                resetableRequest.applyState();
                resetableResponse.applyState();
                return result.forward;
            }
            catch (LockingException e) {
                resetableRequest.resetState();
                resetableResponse.resetState();
                this.logDebug(request, "Locking error - re-executing action");
                continue;
            }
            break;
        }
        catch (SystemOfflineException e) {
            return ActionHelper.sendError(mapping, request, response, "error.systemOffline", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        boolean managesTransaction;
        boolean needsReadOnlyConnection;
        ExecutionResult result = (ExecutionResult)request.getAttribute(EXECUTION_RESULT_KEY);
        boolean isInclude = forward != null && !forward.getRedirect();
        boolean bl = needsReadOnlyConnection = isInclude && !result.longTransaction;
        if (needsReadOnlyConnection) {
            this.openReadOnlyConnection(request);
        }
        boolean bl2 = managesTransaction = !this.noTransaction(request);
        if (managesTransaction) {
            request.setAttribute(NO_TRANSACTION_KEY, (Object)true);
        }
        try {
            super.processForwardConfig(request, response, forward);
        }
        catch (IllegalStateException e) {
            LOG.warn((Object)("Error processing the forward to " + forward.getPath()));
        }
        finally {
            if (managesTransaction) {
                request.removeAttribute(NO_TRANSACTION_KEY);
            }
            if (result.longTransaction) {
                result.commit = false;
                this.commitOrRollbackTransaction(request);
            } else if (needsReadOnlyConnection) {
                this.rollbackReadOnlyConnection(request);
            }
        }
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        HttpServletRequest multipartRequest = super.processMultipart(request);
        if (multipartRequest != request) {
            request.setAttribute("multipartRequest", (Object)multipartRequest);
        }
        return multipartRequest;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        try {
            super.processPopulate(request, response, form, mapping);
        }
        catch (Exception e) {
            LOG.error((Object)("Error populating " + form + " in " + mapping.getPath()), (Throwable)e);
            request.getSession().setAttribute("errorKey", (Object)"error.validation");
            RequestDispatcher rd = request.getRequestDispatcher("/do/error");
            try {
                rd.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException e1) {
                LOG.error((Object)"Error while trying to forward to error page", (Throwable)e1);
            }
        }
    }

    private void cleanSessionForms(HttpServletRequest request, ActionForm form) {
        HttpSession session = request.getSession();
        Set sessionForms = (Set)session.getAttribute("sessionForms");
        if (sessionForms != null) {
            for (String name : sessionForms) {
                ActionForm currentForm = (ActionForm)session.getAttribute(name);
                if (currentForm == form) continue;
                session.removeAttribute(name);
            }
        }
    }

    private void cleanUpTransaction(HttpServletRequest request) {
        Connection connection;
        if (this.noTransaction(request)) {
            return;
        }
        this.logDebug(request, "Cleaning up transaction");
        DataIteratorHelper.closeOpenIterators();
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        if (holder != null) {
            try {
                org.hibernate.Session session = holder.getSession();
                if (session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error closing Hibernate session", (Throwable)e);
            }
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
        }
        if ((connection = (Connection)TransactionSynchronizationManager.getResource((Object)this.connectionProvider)) != null) {
            try {
                this.connectionProvider.closeConnection(connection);
            }
            catch (Exception e) {
                LOG.error((Object)"Error closing database connection", (Throwable)e);
            }
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.connectionProvider);
        }
        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)false);
        TransactionSynchronizationManager.setActualTransactionActive((boolean)false);
        CurrentTransactionData.cleanup();
        request.removeAttribute(EXECUTION_RESULT_KEY);
    }

    private void commitOrRollbackTransaction(HttpServletRequest request) throws IOException, ServletException {
        if (this.noTransaction(request)) {
            return;
        }
        ExecutionResult result = (ExecutionResult)request.getAttribute(EXECUTION_RESULT_KEY);
        SessionHolder sessionHolder = this.getSessionHolder();
        boolean runCommitListeners = false;
        boolean lockingException = false;
        if (result.commit) {
            this.logDebug(request, "Committing transaction");
            runCommitListeners = true;
            try {
                sessionHolder.getTransaction().commit();
            }
            catch (Throwable t) {
                lockingException = ExceptionHelper.isLockingException(t);
                result.error = t;
            }
        } else {
            if (result.error == null && !result.hasWrite) {
                runCommitListeners = true;
                this.logDebug(request, "Nothing written to database. Rolling-back transaction");
            } else {
                this.logDebug(request, "Rolling-back transaction");
            }
            sessionHolder.getTransaction().rollback();
        }
        sessionHolder.getSession().disconnect();
        if (lockingException) {
            this.cleanUpTransaction(request);
            throw new LockingException();
        }
        TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
        CurrentTransactionData.detachListeners().runListeners(runCommitListeners);
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)sessionHolder);
        if (result.traceLog) {
            this.traceLog(request, result.error, result.commit);
        }
        if (result.error != null && !result.errorWasSilenced) {
            this.actionHelper.generateLog(request, this.servlet.getServletContext(), result.error);
            ActionHelper.throwException(result.error);
        }
    }

    private ExecutionResult doExecuteAction(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) {
        ExecutionResult result = (ExecutionResult)request.getAttribute(EXECUTION_RESULT_KEY);
        try {
            result.forward = super.processActionPerform(request, response, action, form, mapping);
            result.error = CurrentTransactionData.getError();
            result.errorWasSilenced = result.error != null;
            result.longTransaction = DataIteratorHelper.hasOpenIteratorsRequiringOpenConnection();
            if (result.error == null) {
                SessionHolder holder = this.getSessionHolder();
                holder.getSession().flush();
            }
            result.hasWrite = CurrentTransactionData.hasWrite();
            if (result.error instanceof ApplicationException) {
                result.commit = result.hasWrite && !((ApplicationException)result.error).isShouldRollback();
            } else {
                result.commit = result.hasWrite && !result.errorWasSilenced;
            }
        }
        catch (ApplicationException e) {
            result.commit = !e.isShouldRollback();
            result.error = e;
        }
        catch (Throwable e) {
            result.commit = false;
            result.error = e;
        }
        result.traceLog = this.generateTraceLog(request);
        return result;
    }

    private ExecutionResult executeAction(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        try {
            this.openReadWriteConnection(request);
        }
        catch (Exception e) {
            throw new SystemOfflineException();
        }
        ExecutionResult result = this.doExecuteAction(request, response, action, form, mapping);
        if (!result.longTransaction) {
            this.commitOrRollbackTransaction(request);
        } else {
            this.logDebug(request, "Keeping connection open because there are open iterators");
        }
        return result;
    }

    private boolean generateTraceLog(HttpServletRequest request) {
        String uri = request.getRequestURI();
        return LoggedUser.getAccessType() == LoggedUser.AccessType.USER && !RequestHelper.isAjax(request) && !uri.endsWith("/login") && !uri.endsWith("/logout");
    }

    private SessionHolder getSessionHolder() {
        return (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
    }

    private void logDebug(HttpServletRequest request, String message) {
        if (LOG.isDebugEnabled()) {
            String method = RequestHelper.isValidation(request) ? "VALIDATION" : request.getMethod();
            LOG.debug((Object)String.format("%s (%s): %s", request.getRequestURI(), method, message));
        }
    }

    private boolean noTransaction(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute(NO_TRANSACTION_KEY));
    }

    private void openReadOnlyConnection(HttpServletRequest request) {
        if (this.noTransaction(request)) {
            return;
        }
        this.logDebug(request, "Opening read-only transaction for include");
        Connection connection = (Connection)TransactionSynchronizationManager.getResource((Object)this.connectionProvider);
        SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.sessionFactory);
        org.hibernate.Session session = holder.getSession();
        session.setFlushMode(FlushMode.MANUAL);
        session.setDefaultReadOnly(true);
        session.reconnect(connection);
        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openReadWriteConnection(HttpServletRequest request) throws IOException, ServletException {
        if (this.noTransaction(request)) {
            return;
        }
        this.logDebug(request, "Opening a new read-write transaction");
        Connection connection = null;
        Session session = null;
        SessionHolder holder = null;
        Transaction transaction = null;
        try {
            connection = this.connectionProvider.getConnection();
            TransactionSynchronizationManager.bindResource((Object)this.connectionProvider, (Object)connection);
            session = this.sessionFactory.openSession(connection);
            holder = new SessionHolder((org.hibernate.Session)session);
            transaction = session.beginTransaction();
            holder.setTransaction(transaction);
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)holder);
            holder.setSynchronizedWithTransaction(true);
            TransactionSynchronizationManager.setActualTransactionActive((boolean)true);
            TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)false);
        }
        catch (Exception e) {
            if (connection != null) {
                try {
                    this.connectionProvider.closeConnection(connection);
                }
                catch (SQLException e1) {
                    LOG.warn((Object)"Error closing connection", (Throwable)e1);
                }
                finally {
                    TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.connectionProvider);
                    TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.sessionFactory);
                }
            }
            LOG.error((Object)"Couldn't open a transaction", (Throwable)e);
            ActionHelper.throwException(e);
        }
    }

    private void rollbackReadOnlyConnection(HttpServletRequest request) {
        if (this.noTransaction(request)) {
            return;
        }
        Connection connection = (Connection)TransactionSynchronizationManager.getResource((Object)this.connectionProvider);
        try {
            this.logDebug(request, "Rolling back read-only transaction");
            connection.rollback();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    private void traceLog(HttpServletRequest request, Throwable error, boolean hasWrite) {
        HttpServletRequest multipartRequest = (HttpServletRequest)request.getAttribute("multipartRequest");
        HttpServletRequest req = multipartRequest == null ? request : multipartRequest;
        TraceLogDTO params = new TraceLogDTO();
        params.setUser((User)LoggedUser.user());
        params.setRemoteAddress(req.getRemoteAddr());
        params.setRequestMethod(req.getMethod());
        params.setPath(req.getRequestURI());
        params.setParameters(ActionHelper.getParameterMap(req));
        HttpSession session = req.getSession(false);
        params.setSessionId(session == null ? null : session.getId());
        params.setError(error);
        params.setHasDatabaseWrites(hasWrite);
        this.loggingHandler.trace(params);
    }

    public static class ExecutionResult {
        private boolean commit;
        private boolean errorWasSilenced;
        private boolean hasWrite;
        private boolean traceLog;
        private boolean longTransaction;
        private Throwable error;
        private ActionForward forward;

        public Throwable getError() {
            return this.error;
        }

        public ActionForward getForward() {
            return this.forward;
        }

        public boolean isCommit() {
            return this.commit;
        }

        public boolean isErrorWasSilenced() {
            return this.errorWasSilenced;
        }

        public boolean isHasWrite() {
            return this.hasWrite;
        }

        public boolean isLongTransaction() {
            return this.longTransaction;
        }

        public boolean isTraceLog() {
            return this.traceLog;
        }
    }
}

