/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access;

import nl.strohalm.cyclos.controls.AbstractActionContext;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.accounts.pos.PosService;
import nl.strohalm.cyclos.services.elements.ElementService;
import nl.strohalm.cyclos.services.groups.GroupService;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.struts.access.ActionPolicyRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionAccessMonitor {
    private static final Log LOG = LogFactory.getLog(ActionAccessMonitor.class);
    private PermissionService permissionService;
    private ElementService elementService;
    private PosService posService;
    private GroupService groupService;

    public ElementService getElementService() {
        return this.elementService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public PosService getPosService() {
        return this.posService;
    }

    public void requestAccess(AbstractActionContext context) {
        ActionPolicy policy = ActionPolicyRepository.getApplicablePolicy(context.getActionMapping().getType());
        this.check(policy, context);
    }

    public void setElementService(ElementService elementService) {
        this.elementService = elementService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPosService(PosService posService) {
        this.posService = posService;
    }

    private void check(ActionPolicy policy, AbstractActionContext context) {
        if (policy != null && !policy.check(new ActionDescriptor(context, this))) {
            LOG.debug((Object)("Access denied for: " + context.getActionMapping().getPath()));
            throw new PermissionDeniedException();
        }
    }
}

