/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access.policies;

import javax.servlet.http.HttpServletRequest;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.controls.AbstractActionContext;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.services.permissions.PermissionService;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.IdConverter;

public class AccountOverviewActionPolicy
implements ActionPolicy {
    private static final AccountOverviewActionPolicy INSTANCE = new AccountOverviewActionPolicy();

    public static ActionPolicy instance() {
        return INSTANCE;
    }

    private AccountOverviewActionPolicy() {
    }

    @Override
    public boolean check(ActionDescriptor descriptor) {
        PermissionService permissionService = descriptor.getPermissionService();
        AbstractActionContext context = descriptor.getContext();
        HttpServletRequest request = context.getRequest();
        Long memberId = IdConverter.instance().valueOf(request.getParameter("memberId"));
        if (LoggedUser.isBroker() && memberId != null && !memberId.equals(((Entity)context.getUser()).getId())) {
            return permissionService.hasPermission(BrokerPermission.ACCOUNTS_INFORMATION);
        }
        if (LoggedUser.isMember() || LoggedUser.isOperator()) {
            return true;
        }
        if (memberId != null) {
            return permissionService.hasPermission(AdminMemberPermission.ACCOUNTS_INFORMATION);
        }
        return permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_INFORMATION);
    }
}

