/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access.policies;

import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.controls.members.activities.ActivitiesForm;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.struts.access.policies.utils.AbstractActionPolicy;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class ActivitiesActionPolicy
extends AbstractActionPolicy {
    private static final ActivitiesActionPolicy INSTANCE = new ActivitiesActionPolicy();

    public static ActionPolicy instance() {
        return INSTANCE;
    }

    private ActivitiesActionPolicy() {
    }

    @Override
    protected boolean doCheck(ActionDescriptor descriptor) {
        ActivitiesForm form = (ActivitiesForm)((Object)this.getForm());
        if (form.getMemberId() > 0L) {
            if (LoggedUser.isBroker()) {
                return this.hasPermission(BrokerPermission.REPORTS_VIEW);
            }
            return this.hasPermission(AdminMemberPermission.REPORTS_VIEW, MemberPermission.REPORTS_VIEW);
        }
        if (LoggedUser.isMember()) {
            return true;
        }
        if (LoggedUser.isOperator()) {
            return this.hasPermission(OperatorPermission.REPORTS_VIEW_MEMBER);
        }
        return false;
    }
}

