/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access.policies;

import java.util.concurrent.Callable;
import nl.strohalm.cyclos.access.AdminAdminPermission;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.controls.access.ManagePasswordsForm;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.struts.access.policies.utils.AbstractActionPolicy;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class ManagePasswordsActionPolicy
extends AbstractActionPolicy {
    private static final ManagePasswordsActionPolicy INSTANCE = new ManagePasswordsActionPolicy();

    public static ActionPolicy instance() {
        return INSTANCE;
    }

    private ManagePasswordsActionPolicy() {
    }

    @Override
    protected boolean doCheck(final ActionDescriptor descriptor) {
        final ManagePasswordsForm form = (ManagePasswordsForm)((Object)this.getForm());
        User user = LoggedUser.runAsSystem(new Callable<User>(){

            @Override
            public User call() throws Exception {
                return descriptor.getElementService().loadUser(form.getUserId(), User.Relationships.ELEMENT);
            }
        });
        switch (user.getElement().getNature()) {
            case ADMIN: {
                return this.hasPermission(AdminAdminPermission.ACCESS_CHANGE_PASSWORD, AdminAdminPermission.ACCESS_TRANSACTION_PASSWORD);
            }
            case MEMBER: {
                return this.hasPermission(AdminMemberPermission.ACCESS_CHANGE_PASSWORD, AdminMemberPermission.ACCESS_RESET_PASSWORD, AdminMemberPermission.ACCESS_TRANSACTION_PASSWORD, BrokerPermission.MEMBER_ACCESS_CHANGE_PASSWORD, BrokerPermission.MEMBER_ACCESS_RESET_PASSWORD, BrokerPermission.MEMBER_ACCESS_TRANSACTION_PASSWORD);
            }
            case OPERATOR: {
                return this.hasPermission(MemberPermission.OPERATORS_MANAGE);
            }
        }
        return false;
    }
}

