/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access.policies;

import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.controls.members.references.MemberReferencesForm;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.struts.access.policies.utils.AbstractActionPolicy;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class MemberReferencesActionPolicy
extends AbstractActionPolicy {
    private static final MemberReferencesActionPolicy INSTANCE = new MemberReferencesActionPolicy();

    public static ActionPolicy instance() {
        return INSTANCE;
    }

    private MemberReferencesActionPolicy() {
    }

    @Override
    protected boolean doCheck(ActionDescriptor descriptor) {
        MemberReferencesForm form = (MemberReferencesForm)((Object)this.getForm());
        Reference.Nature nature = CoercionHelper.coerce(Reference.Nature.class, form.getNature());
        Reference.Nature nature2 = nature = nature == null ? Reference.Nature.GENERAL : nature;
        if (form.getMemberId() > 0L) {
            if (Reference.Nature.GENERAL == nature) {
                return this.hasPermission(AdminMemberPermission.REFERENCES_VIEW, MemberPermission.REFERENCES_VIEW, BrokerPermission.REFERENCES_MANAGE, OperatorPermission.REFERENCES_VIEW);
            }
            if (Reference.Nature.TRANSACTION == nature) {
                return LoggedUser.isMember() || LoggedUser.isOperator() || this.hasPermission(AdminMemberPermission.TRANSACTION_FEEDBACKS_VIEW);
            }
            return false;
        }
        if (LoggedUser.isMember()) {
            return true;
        }
        if (LoggedUser.isOperator()) {
            return this.hasPermission(Reference.Nature.GENERAL == nature ? OperatorPermission.REFERENCES_MANAGE_MEMBER_REFERENCES : OperatorPermission.REFERENCES_MANAGE_MEMBER_TRANSACTION_FEEDBACKS);
        }
        return false;
    }
}

