/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access.policies;

import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.controls.invoices.SendInvoiceForm;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.struts.access.policies.utils.AbstractActionPolicy;
import org.apache.commons.lang.StringUtils;

public class SendInvoiceActionPolicy
extends AbstractActionPolicy {
    private static final SendInvoiceActionPolicy INSTANCE = new SendInvoiceActionPolicy();

    public static ActionPolicy instance() {
        return INSTANCE;
    }

    private SendInvoiceActionPolicy() {
    }

    @Override
    protected boolean doCheck(ActionDescriptor descriptor) {
        SendInvoiceForm form = (SendInvoiceForm)((Object)this.getForm());
        if (form.isToSystem()) {
            if (StringUtils.isEmpty((String)form.getFrom())) {
                return this.hasPermission(MemberPermission.INVOICES_SEND_TO_SYSTEM, OperatorPermission.INVOICES_SEND_TO_SYSTEM);
            }
            return this.hasPermission(BrokerPermission.INVOICES_SEND_AS_MEMBER_TO_SYSTEM, AdminMemberPermission.INVOICES_SEND_AS_MEMBER_TO_SYSTEM);
        }
        if (StringUtils.isNotEmpty((String)form.getTo()) || form.isSelectMember()) {
            return this.hasPermission(AdminMemberPermission.INVOICES_SEND, MemberPermission.INVOICES_SEND_TO_MEMBER, OperatorPermission.INVOICES_SEND_TO_MEMBER);
        }
        if (StringUtils.isNotEmpty((String)form.getFrom())) {
            return this.hasPermission(AdminMemberPermission.INVOICES_SEND_AS_MEMBER_TO_MEMBER, BrokerPermission.INVOICES_SEND_AS_MEMBER_TO_MEMBER);
        }
        return false;
    }
}

