/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.struts.access.policies;

import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.controls.members.messages.SendMessageAction;
import nl.strohalm.cyclos.controls.members.messages.SendMessageForm;
import nl.strohalm.cyclos.struts.access.ActionDescriptor;
import nl.strohalm.cyclos.struts.access.ActionPolicy;
import nl.strohalm.cyclos.struts.access.policies.utils.AbstractActionPolicy;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;

public class SendMessageActionPolicy
extends AbstractActionPolicy {
    private static final SendMessageActionPolicy INSTANCE = new SendMessageActionPolicy();

    public static ActionPolicy instance() {
        return INSTANCE;
    }

    private SendMessageActionPolicy() {
    }

    @Override
    protected boolean doCheck(ActionDescriptor descriptor) {
        SendMessageForm form = (SendMessageForm)((Object)this.getForm());
        SendMessageAction.SendTo sendTo = null;
        sendTo = form.getToMemberId() > 0L ? SendMessageAction.SendTo.MEMBER : CoercionHelper.coerce(SendMessageAction.SendTo.class, form.getSendTo());
        if (sendTo == null) {
            return true;
        }
        switch (sendTo) {
            case MEMBER: {
                return this.hasPermission(AdminMemberPermission.MESSAGES_SEND_TO_MEMBER, MemberPermission.MESSAGES_SEND_TO_MEMBER, OperatorPermission.MESSAGES_SEND_TO_MEMBER);
            }
            case GROUP: {
                return this.hasPermission(AdminMemberPermission.MESSAGES_SEND_TO_GROUP);
            }
            case BROKERED_MEMBERS: {
                return this.hasPermission(BrokerPermission.MESSAGES_SEND_TO_MEMBERS);
            }
            case ADMIN: {
                return this.hasPermission(MemberPermission.MESSAGES_SEND_TO_ADMINISTRATION, OperatorPermission.MESSAGES_SEND_TO_ADMINISTRATION);
            }
        }
        return false;
    }
}

