/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.utils.CustomizationHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public abstract class AbstractCustomizedFileTag
extends TagSupport {
    private static final long serialVersionUID = 7545420264637927211L;
    private String type;
    private String name;
    private Long groupId;
    private Long groupFilterId;

    public Long getGroupFilterId() {
        return this.groupFilterId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void release() {
        super.release();
        this.type = null;
        this.name = null;
        this.groupId = null;
        this.groupFilterId = null;
    }

    public void setGroupFilterId(Long groupFilterId) {
        if (groupFilterId != null && groupFilterId == 0L) {
            groupFilterId = null;
        }
        this.groupFilterId = groupFilterId;
    }

    public void setGroupId(Long groupId) {
        if (groupId != null && groupId == 0L) {
            groupId = null;
        }
        this.groupId = groupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected String resolvePath() {
        ServletContext servletContext = this.pageContext.getServletContext();
        CustomizationHelper customizationHelper = SpringHelper.bean(servletContext, CustomizationHelper.class);
        CustomizedFile.Type type = this.resolveType();
        Group group = this.resolveGroup();
        GroupFilter groupFilter = this.resolveGroupFilter();
        return customizationHelper.findPathOf(type, group, groupFilter, this.name);
    }

    protected CustomizedFile.Type resolveType() {
        if (this.type != null) {
            this.type = this.type.toLowerCase();
            if (this.type.startsWith("static")) {
                return CustomizedFile.Type.STATIC_FILE;
            }
            if (this.type.startsWith("help")) {
                return CustomizedFile.Type.HELP;
            }
            if (this.type.startsWith("style")) {
                return CustomizedFile.Type.STYLE;
            }
        }
        throw new IllegalArgumentException("Invalid customized file type '" + this.type + "'. Valid are 'static', 'help' or 'style'");
    }

    private Group resolveGroup() {
        if (this.groupId != null) {
            return EntityHelper.reference(Group.class, this.groupId);
        }
        return LoggedUser.hasUser() ? LoggedUser.group() : null;
    }

    private GroupFilter resolveGroupFilter() {
        if (this.groupFilterId != null) {
            return EntityHelper.reference(GroupFilter.class, this.groupFilterId);
        }
        return null;
    }
}

