/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.Tag;
import nl.strohalm.cyclos.taglibs.AbstractDynamicAttributesTag;
import nl.strohalm.cyclos.taglibs.LayoutTag;

public class CellTag
extends AbstractDynamicAttributesTag {
    private static final long serialVersionUID = -7905345351301614529L;
    private int colspan = 1;

    public int doEndTag() throws JspException {
        LayoutTag layoutTag = (LayoutTag)CellTag.findAncestorWithClass((Tag)this, LayoutTag.class);
        if (layoutTag == null) {
            throw new JspException("Cell tag should be nested in a Layout tag");
        }
        JspWriter out = this.pageContext.getOut();
        try {
            out.print("</td>");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            layoutTag.finishCell(this.colspan);
            this.release();
        }
        return 6;
    }

    public int doStartTag() throws JspException {
        JspWriter out = this.pageContext.getOut();
        try {
            out.print("<td colspan='" + this.colspan + "' " + this.attributesForTag() + ">");
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 1;
    }

    public int getColspan() {
        return this.colspan;
    }

    @Override
    public void release() {
        super.release();
        this.colspan = 1;
    }

    public void setColspan(int colspan) {
        this.colspan = colspan;
    }

    @Override
    protected String attributesForTag() {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("className", "class");
        replacements.put("elementId", "id");
        return super.attributesForTag(replacements);
    }
}

