/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.taglibs;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.Validation;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.settings.SettingsService;
import nl.strohalm.cyclos.taglibs.MultiDropDownTag;
import nl.strohalm.cyclos.taglibs.OptionTag;
import nl.strohalm.cyclos.taglibs.ProfileTag;
import nl.strohalm.cyclos.taglibs.RichTextAreaTag;
import nl.strohalm.cyclos.utils.MessageHelper;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.SpringHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CustomFieldTag
extends TagSupport {
    private static final long serialVersionUID = 1356009486707156305L;
    private boolean editable = true;
    private boolean enabled = true;
    private CustomField field;
    private String fieldName;
    private String styleId;
    private boolean search;
    private boolean textOnly;
    private String size;
    private Object value;
    private String valueName;
    private Collection<? extends CustomFieldValue> collection;
    private boolean encodeHtml = true;
    private MessageHelper messageHelper;
    private SettingsService settingsService;

    public int doEndTag() throws JspException {
        try {
            if (this.field == null) {
                throw new JspException("Field is null on CustomFieldTag");
            }
            if (this.value == null && this.collection != null) {
                for (CustomFieldValue customFieldValue : this.collection) {
                    if (!this.field.equals(customFieldValue.getField())) continue;
                    this.value = customFieldValue;
                    break;
                }
            }
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.fieldName)) {
                sb.append("<input type=\"hidden\" name=\"").append(this.fieldName).append("\" value=\"").append(this.field.getId()).append("\">");
            }
            CustomField.Control control = this.field.getControl();
            if (this.editable && !this.textOnly) {
                if (this.field.getType() == CustomField.Type.BOOLEAN) {
                    if (this.search) {
                        this.renderSelect(sb);
                    } else {
                        this.renderCheckBox(sb);
                    }
                } else if (this.field.getType() == CustomField.Type.MEMBER) {
                    this.renderMemberSelect(sb);
                } else if (this.field.getType() == CustomField.Type.ENUMERATED) {
                    Collection<CustomFieldPossibleValue> possibleValues = this.field.getPossibleValues(false);
                    if (CollectionUtils.isEmpty(possibleValues)) {
                        sb.append("<input type=\"hidden\" name=\"").append(this.valueName).append("\">");
                    } else if (control == CustomField.Control.RADIO && !this.search) {
                        this.renderRadioGroup(sb);
                    } else {
                        this.renderSelect(sb);
                    }
                } else if (!this.search && this.field.getControl() == CustomField.Control.TEXTAREA) {
                    this.renderTextarea(sb);
                } else if (!this.search && this.field.getControl() == CustomField.Control.RICH_EDITOR) {
                    this.renderRichEditor(sb);
                } else {
                    this.renderText(sb);
                }
            } else {
                this.renderDisplay(sb);
            }
            this.pageContext.getOut().write(sb.toString());
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.release();
        }
        return 6;
    }

    public Collection<? extends CustomFieldValue> getCollection() {
        return this.collection;
    }

    public CustomField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getSize() {
        return this.size;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueName() {
        return this.valueName;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEncodeHtml() {
        return this.encodeHtml;
    }

    public boolean isSearch() {
        return this.search;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public void release() {
        super.release();
        this.field = null;
        this.fieldName = null;
        this.valueName = null;
        this.value = null;
        this.collection = null;
        this.enabled = true;
        this.editable = true;
        this.search = false;
        this.textOnly = false;
        this.encodeHtml = true;
        this.size = null;
        this.styleId = null;
    }

    public void setCollection(Collection<? extends CustomFieldValue> collection) {
        this.collection = collection;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEncodeHtml(boolean encodeHtml) {
        this.encodeHtml = encodeHtml;
    }

    public void setField(CustomField field) {
        this.field = field;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.messageHelper = SpringHelper.bean(pageContext.getServletContext(), MessageHelper.class);
        this.settingsService = SpringHelper.bean(pageContext.getServletContext(), SettingsService.class);
    }

    public void setSearch(boolean search) {
        this.search = search;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setValueName(String valueField) {
        this.valueName = valueField;
    }

    private String ensureHtml(String string) {
        return StringUtils.replace((String)StringEscapeUtils.escapeHtml((String)string), (String)"\n", (String)"<br>");
    }

    private Member getMemberValue() {
        if (this.value instanceof CustomFieldValue) {
            return ((CustomFieldValue)this.value).getMemberValue();
        }
        return null;
    }

    private CustomFieldPossibleValue getPossibleValue() {
        if (this.value instanceof CustomFieldValue) {
            return ((CustomFieldValue)this.value).getPossibleValue();
        }
        return null;
    }

    private String getSizeClass() {
        CustomField.Size size;
        if (StringUtils.isNotEmpty((String)this.size)) {
            return this.size;
        }
        CustomField.Size size2 = size = this.field == null ? null : this.field.getSize();
        if (size == null || size == CustomField.Size.DEFAULT) {
            return "";
        }
        return size.name().toLowerCase();
    }

    private String getStringValue() {
        String string = this.value instanceof String ? (String)this.value : (this.value instanceof CustomFieldValue ? ((CustomFieldValue)this.value).getValue() : null);
        if (StringUtils.isNotEmpty((String)this.field.getPattern())) {
            string = StringHelper.applyMask(this.field.getPattern(), string);
        }
        return string == null ? "" : string;
    }

    private Collection<CustomFieldPossibleValue> removeDisabledValues(CustomFieldPossibleValue selected, Collection<CustomFieldPossibleValue> possibleValues) {
        ArrayList<CustomFieldPossibleValue> result = new ArrayList<CustomFieldPossibleValue>();
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            boolean useField = true;
            if (!(possibleValue.isEnabled() || selected != null && selected.equals(possibleValue))) {
                useField = false;
            }
            if (!useField) continue;
            result.add(possibleValue);
        }
        return result;
    }

    private void renderCheckBox(StringBuilder sb) throws JspException {
        boolean value = Boolean.parseBoolean(this.getStringValue());
        sb.append("<input type=\"hidden\" id=\"_value_of_").append(this.field.getId()).append("\" name=\"").append(this.valueName).append("\" value=\"").append(value).append("\">");
        sb.append("<input type=\"checkbox\" id=\"_check_of_").append(this.field.getId()).append("\" class=\"checkbox\" onclick=\"if (!this.disabled){$('_value_of_").append(this.field.getId()).append("').value=String(this.checked);}\"");
        if (!this.enabled) {
            sb.append("disabled ");
        }
        if (value) {
            sb.append(" checked");
        }
        sb.append(">");
    }

    private void renderDisplay(StringBuilder sb) throws JspException {
        Object memberResultDisplay;
        String value;
        boolean skipEncode = false;
        switch (this.field.getType()) {
            case ENUMERATED: {
                try {
                    value = this.getPossibleValue().getValue();
                }
                catch (NullPointerException e) {
                    value = "";
                }
                break;
            }
            case BOOLEAN: {
                String key = "true".equals(this.getStringValue()) ? "global.yes" : "global.no";
                value = this.messageHelper.message(key, new Object[0]);
                break;
            }
            case URL: {
                value = this.getStringValue();
                if (!StringUtils.isNotEmpty((String)value)) break;
                if (!value.contains("://")) {
                    value = "http://" + value;
                }
                if (!this.editable) break;
                value = "<a href=\"" + value + "\" class=\"default\" target=\"_blank\">" + value + "</a>";
                skipEncode = true;
                break;
            }
            case MEMBER: {
                Member member = this.getMemberValue();
                if (member == null) {
                    value = null;
                    break;
                }
                if (this.editable) {
                    StringWriter sw = new StringWriter();
                    this.pageContext.pushBody((Writer)sw);
                    ProfileTag profileTag = new ProfileTag();
                    profileTag.setPageContext(this.pageContext);
                    profileTag.setElementId(member.getId());
                    profileTag.doStartTag();
                    profileTag.doEndTag();
                    this.pageContext.popBody();
                    value = sw.toString();
                    skipEncode = true;
                    break;
                }
                memberResultDisplay = this.settingsService.getLocalSettings().getMemberResultDisplay();
                if (memberResultDisplay == LocalSettings.MemberResultDisplay.USERNAME) {
                    value = member.getUsername();
                    break;
                }
                value = member.getName();
                break;
            }
            default: {
                value = this.getStringValue();
            }
        }
        if (!this.textOnly) {
            sb.append("<input type=\"text\" name=\"").append(this.valueName).append("\" value=\"");
        }
        value = StringUtils.trimToEmpty((String)value);
        String script = null;
        if (!skipEncode && this.encodeHtml && this.field.getControl() != CustomField.Control.RICH_EDITOR) {
            value = StringUtils.replace((String)StringUtils.replace((String)StringUtils.replace((String)StringUtils.replace((String)value, (String)"\"", (String)"&quot;"), (String)"<", (String)"&lt;"), (String)">", (String)"&gt;"), (String)"\n", (String)"<br>");
        } else if (this.field.getControl() == CustomField.Control.RICH_EDITOR) {
            Integer lastRichTextSeq = (Integer)this.pageContext.getRequest().getAttribute("lastRichTextSeq");
            if (lastRichTextSeq == null) {
                lastRichTextSeq = 0;
            }
            memberResultDisplay = lastRichTextSeq;
            Integer n = lastRichTextSeq = Integer.valueOf(lastRichTextSeq + 1);
            this.pageContext.getRequest().setAttribute("lastRichTextSeq", (Object)lastRichTextSeq);
            String containerId = "valueContainer_" + lastRichTextSeq;
            value = "<div id='" + containerId + "' style='display:none;overflow:auto'>" + value + "</div>";
            script = "<script>\nEvent.observe(self, 'load', function() {\n var " + containerId + " = $('" + containerId + "');\n" + containerId + ".style.width = $(" + containerId + ".parentElement).getDimensions().width + 'px';\n" + containerId + ".show();\n" + "});\n</script>\n";
        }
        sb.append(value);
        if (!this.textOnly) {
            sb.append("\" class=\"" + this.getSizeClass() + " readonly InputBoxDisabled\" readonly>\n");
        }
        if (script != null) {
            sb.append(script);
        }
    }

    private void renderMemberSelect(StringBuilder sb) {
        Member memberValue = this.getMemberValue();
        String idFieldId = "memberId_field_" + this.field.getId();
        String usernameFieldId = "memberUsername_field_" + this.field.getId();
        String usernameDivId = "membersByUsername_field_" + this.field.getId();
        String nameFieldId = "memberName_field_" + this.field.getId();
        String nameDivId = "membersByName_field_" + this.field.getId();
        boolean requiredField = this.field != null && this.field.getValidation().isRequired();
        String className = this.enabled ? "InputBoxEnabled" : "InputBoxDisabled";
        sb.append("<table class='nested' width='100%'>\n");
        sb.append("    <tr>\n");
        sb.append("        <td class='label' width='25%'>").append(this.messageHelper.message("member.username", new Object[0])).append("</td>\n");
        sb.append("        <td>\n");
        sb.append("            <input type='hidden' id='").append(idFieldId).append("' name='").append(this.valueName).append("' value='").append(memberValue == null ? "" : memberValue.getId()).append("'>\n");
        sb.append("            <input id='").append(usernameFieldId).append("' class='full ").append(className).append("' ").append(this.enabled ? "" : "disabled='disabled'").append(" value='").append(memberValue == null ? "" : StringEscapeUtils.escapeHtml((String)memberValue.getUsername())).append("'>\n");
        sb.append("            <div id='").append(usernameDivId).append("' class='autoComplete'>\n");
        sb.append("        </td>\n");
        if (requiredField) {
            sb.append("<td rowspan='2' width='10px' style='vertical-align:top'>&nbsp;<span class='fieldDecoration' style='vertical-align:top'>*</span>");
        }
        sb.append("    </tr>\n");
        sb.append("    <tr>\n");
        sb.append("        <td class='label'>").append(this.messageHelper.message("member.name", new Object[0])).append("</td>\n");
        sb.append("        <td>\n");
        sb.append("            <input id='").append(nameFieldId).append("' class='full ").append(className).append("' ").append(this.enabled ? "" : "disabled='disabled'").append(" value='").append(memberValue == null ? "" : StringEscapeUtils.escapeHtml((String)memberValue.getName())).append("'>\n");
        sb.append("            <div id='").append(nameDivId).append("' class='autoComplete'>\n");
        sb.append("        </td>\n");
        sb.append("    </tr>\n");
        sb.append("</table>\n");
        sb.append("<script>\n");
        sb.append("prepareForMemberAutocomplete('").append(usernameFieldId).append("','").append(usernameDivId).append("',").append("{paramName:'username'},'").append(idFieldId).append("','").append(usernameFieldId).append("','").append(nameFieldId).append("');\n");
        sb.append("prepareForMemberAutocomplete('").append(nameFieldId).append("','").append(nameDivId).append("',").append("{paramName:'name'},'").append(idFieldId).append("','").append(usernameFieldId).append("','").append(nameFieldId).append("');\n");
        sb.append("</script>\n");
    }

    private void renderRadioGroup(StringBuilder sb) throws JspException {
        boolean useDefault;
        CustomFieldPossibleValue value = this.getPossibleValue();
        sb.append("<table border='0' cellpadding='0' cellspacing='0' style='border-spacing:0px;'>\n");
        boolean requiredField = this.field != null && this.field.getValidation().isRequired();
        sb.append("<tr>\n");
        int i = 0;
        int controlsPerRow = Integer.MAX_VALUE;
        if (this.field != null && this.field.getSize() != null) {
            switch (this.field.getSize()) {
                case TINY: {
                    controlsPerRow = 1;
                    break;
                }
                case SMALL: {
                    controlsPerRow = 2;
                    break;
                }
                case MEDIUM: {
                    controlsPerRow = 3;
                    break;
                }
                case LARGE: {
                    controlsPerRow = 4;
                }
            }
        }
        String selectedValue = "";
        String name = "_radio_" + this.field.getId();
        Collection<CustomFieldPossibleValue> possibleValues = this.removeDisabledValues(value, this.field.getPossibleValues(false));
        boolean bl = useDefault = !this.isSearch() && this.value == null;
        if (this.value instanceof CustomFieldValue) {
            CustomFieldValue fieldValue = (CustomFieldValue)this.value;
            useDefault = fieldValue.isTransient();
        }
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            boolean checked;
            String id = name + "_" + i;
            String idAsString = String.valueOf(possibleValue.getId());
            boolean bl2 = checked = ObjectUtils.equals((Object)value, (Object)possibleValue) || useDefault && possibleValue.isDefaultValue();
            if (checked) {
                selectedValue = idAsString;
            }
            sb.append("<td valign='top'><input type='radio' name='").append(name).append("' id=\"").append(id).append("\" class='radio' value='").append(idAsString).append("'").append(this.enabled ? "" : " disabled").append(checked ? " checked" : "");
            sb.append(" onclick=\"if (!this.disabled){$('_value_of_").append(this.field.getId()).append("').value=this.value;}\"");
            sb.append("></td>\n");
            boolean isRequired = requiredField && i == possibleValues.size() - 1;
            sb.append("<td style='padding-right:5px'><label ");
            if (isRequired) {
                sb.append("class=\"required\" ");
            }
            sb.append(" for=\"").append(id).append("\">").append(possibleValue.getValue()).append("</label></td>\n");
            if (++i % controlsPerRow != 0) continue;
            sb.append("<tr>\n</tr>\n");
        }
        sb.append("</tr>\n");
        sb.append("</table>\n");
        sb.append("<input type=\"hidden\" id=\"_value_of_").append(this.field.getId()).append("\" name=\"").append(this.valueName).append("\" value=\"" + selectedValue + "\">\n");
    }

    private void renderRichEditor(StringBuilder sb) {
        RichTextAreaTag tag = new RichTextAreaTag();
        tag.setStyleId("richText" + this.getField().getId());
        tag.setDisabled(!this.enabled);
        tag.setName(this.valueName);
        tag.setPageContext(this.pageContext);
        tag.setValue(this.getStringValue());
        try {
            tag.doStartTag();
            tag.doEndTag();
        }
        catch (JspException e) {
            throw new RuntimeException(e);
        }
    }

    private void renderSelect(StringBuilder sb) throws JspException {
        boolean hasChildren = CollectionUtils.isNotEmpty(this.field.getChildren());
        boolean hasParent = this.field.getParent() != null;
        String emptyLabel = "";
        if (this.search || this.field.getValidation().isRequired()) {
            if (this.search) {
                emptyLabel = StringUtils.trimToEmpty((String)this.field.getAllSelectedLabel());
                if (StringUtils.isEmpty((String)emptyLabel)) {
                    emptyLabel = this.messageHelper.message("global.search.all", new Object[0]);
                }
            } else {
                emptyLabel = this.messageHelper.message("global.select.empty", new Object[0]);
            }
        }
        CustomFieldPossibleValue selected = this.getPossibleValue();
        Collection<CustomFieldPossibleValue> possibleValues = this.removeDisabledValues(selected, this.field.getPossibleValues(false));
        if (!hasChildren && !hasParent && this.search && this.field.getType() == CustomField.Type.ENUMERATED && this.field.getPossibleValues(false).size() > 2) {
            StringWriter temp = new StringWriter();
            this.pageContext.pushBody((Writer)temp);
            MultiDropDownTag multiSelect = new MultiDropDownTag();
            multiSelect.setPageContext(this.pageContext);
            multiSelect.setName(this.valueName);
            multiSelect.setSingleField(true);
            multiSelect.doStartTag();
            multiSelect.setEmptyLabel(emptyLabel);
            OptionTag option = new OptionTag();
            List<String> values = Arrays.asList(StringUtils.trimToEmpty((String)this.getStringValue()).split(","));
            for (CustomFieldPossibleValue possibleValue : possibleValues) {
                String idAsString = String.valueOf(possibleValue.getId());
                option.setParent((Tag)multiSelect);
                option.setPageContext(this.pageContext);
                option.setValue(idAsString);
                option.setText(possibleValue.getValue());
                option.setSelected(values.contains(idAsString));
                option.doStartTag();
                option.doEndTag();
            }
            multiSelect.doEndTag();
            this.pageContext.popBody();
            sb.append(temp.toString());
        } else {
            String id = "custom_field_select_" + this.field.getId();
            sb.append("<select id=\"").append(id).append("\"");
            sb.append(" fieldId=\"").append(this.field.getId()).append("\"");
            sb.append(" fieldName=\"").append(this.field.getInternalName()).append("\" name=\"").append(this.valueName).append('\"');
            if (this.search) {
                sb.append(" fieldEmptyLabel=\"").append(StringEscapeUtils.escapeHtml((String)emptyLabel)).append('\"');
            }
            Validation validation = this.field.getValidation();
            ArrayList<String> classes = new ArrayList<String>();
            if (validation != null && validation.isRequired() && !this.search) {
                classes.add("required");
            }
            if (!this.enabled) {
                classes.add("InputBoxDisabled");
                sb.append(" disabled");
            }
            sb.append(" class=\"").append(StringUtils.join(classes.iterator(), (char)' ')).append("\">\n");
            sb.append("<option value=''>");
            sb.append(StringEscapeUtils.escapeHtml((String)emptyLabel));
            sb.append("</option>\n");
            Long initialOptionId = null;
            if (this.field.getType() == CustomField.Type.ENUMERATED) {
                String valueAsString;
                CustomFieldPossibleValue value = selected;
                if (value == null && StringUtils.isNotEmpty((String)(valueAsString = this.getStringValue()))) {
                    final Long possibleValueId = IdConverter.instance().valueOf(valueAsString);
                    value = (CustomFieldPossibleValue)CollectionUtils.find(this.field.getPossibleValues(false), (Predicate)new Predicate(){

                        public boolean evaluate(Object obj) {
                            CustomFieldPossibleValue pv = (CustomFieldPossibleValue)obj;
                            return pv.getId().equals(possibleValueId);
                        }
                    });
                }
                if (value != null && this.field.getParent() != null) {
                    initialOptionId = value.getId();
                }
                boolean useDefault = false;
                if (!this.isSearch()) {
                    if (this.value == null) {
                        useDefault = true;
                    } else if (this.value instanceof CustomFieldValue) {
                        CustomFieldValue fieldValue = (CustomFieldValue)this.value;
                        useDefault = fieldValue.isTransient();
                    }
                }
                if (hasChildren) {
                    this.pageContext.setAttribute("valueForField_" + this.field.getId(), (Object)value);
                }
                for (CustomFieldPossibleValue possibleValue : possibleValues) {
                    String idAsString = String.valueOf(possibleValue.getId());
                    sb.append("<option");
                    if (ObjectUtils.equals((Object)value, (Object)possibleValue) || useDefault && possibleValue.isDefaultValue()) {
                        sb.append(" selected");
                    }
                    sb.append(" value=\"").append(idAsString).append("\">");
                    sb.append(this.ensureHtml(possibleValue.getValue())).append("</option>\n");
                }
            } else {
                sb.append("<option value='true'");
                if (this.value != null && "true".equalsIgnoreCase(this.value.toString())) {
                    sb.append(" selected");
                }
                sb.append(">").append(this.messageHelper.message("global.yes", new Object[0])).append("</option>\n");
                sb.append("<option value='false'");
                if (this.value != null && "false".equalsIgnoreCase(this.value.toString())) {
                    sb.append(" selected");
                }
                sb.append(">").append(this.messageHelper.message("global.no", new Object[0])).append("</option>\n");
            }
            sb.append("</select>\n");
            if (hasChildren) {
                sb.append("<script>\n");
                sb.append("$('").append(id).append("').onchange = function() {\n");
                for (CustomField child : this.field.getChildren()) {
                    String childId = "custom_field_select_" + child.getId();
                    sb.append("updateCustomFieldChildValues('").append(this.field.getNature()).append("', '").append(id).append("', '").append(childId).append("');\n");
                }
                sb.append("");
                sb.append("}\n");
                sb.append("Event.observe(self, 'loadi', $('").append(id).append("').onchange);\n");
                sb.append("</script>\n");
            }
            if (this.field.getParent() != null) {
                sb.append("<script>\n");
                if (initialOptionId != null) {
                    sb.append("$('").append(id).append("').initialOptionId = \"").append(initialOptionId).append("\";\n");
                }
                sb.append("$('").append(id).append("').initialOptions = [");
                boolean first = true;
                for (CustomFieldPossibleValue possibleValue : possibleValues) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append("new Option(\"").append(StringEscapeUtils.escapeJavaScript((String)possibleValue.getValue())).append("\",\"").append(possibleValue.getId()).append("\")");
                }
                sb.append("];\n");
                sb.append("</script>\n");
            }
        }
    }

    private void renderText(StringBuilder sb) throws JspException {
        RangeConstraint lengthConstraint;
        ArrayList<String> classNames = new ArrayList<String>();
        Validation validation = this.field.getValidation();
        if (validation != null && validation.isRequired() && !this.search) {
            classNames.add("required");
        }
        String pattern = StringUtils.trimToNull((String)this.field.getPattern());
        switch (this.field.getType()) {
            case DATE: {
                classNames.add("date");
                break;
            }
            case INTEGER: {
                classNames.add("number");
                break;
            }
            case DECIMAL: {
                classNames.add("float");
                break;
            }
            case STRING: {
                if (pattern == null) break;
                classNames.add("pattern");
            }
        }
        String sizeClass = this.getSizeClass();
        if (StringUtils.isNotEmpty((String)sizeClass)) {
            classNames.add(sizeClass);
        }
        String value = this.getStringValue();
        sb.append("<input type=\"text\" fieldName=\"").append(this.field.getInternalName()).append("\" name=\"").append(this.valueName).append("\" value=\"").append(StringEscapeUtils.escapeHtml((String)value)).append('\"');
        if (this.enabled) {
            classNames.add("InputBoxEnabled");
        } else {
            sb.append(" readonly");
            classNames.add("InputBoxDisabled");
        }
        if (StringUtils.isNotEmpty((String)this.styleId)) {
            sb.append(" id=\"").append(this.styleId).append('\"');
        }
        if (pattern != null) {
            sb.append(" maskPattern=\"").append(StringEscapeUtils.escapeHtml((String)pattern)).append('\"');
        }
        RangeConstraint rangeConstraint = lengthConstraint = validation == null ? null : validation.getLengthConstraint();
        if (lengthConstraint != null && lengthConstraint.getMax() != null && lengthConstraint.getMax() > 0) {
            sb.append(" maxLength=\"").append(lengthConstraint.getMax()).append('\"');
        }
        sb.append(" class=\"").append(StringUtils.join(classNames.iterator(), (char)' ')).append("\">\n");
    }

    private void renderTextarea(StringBuilder sb) {
        RangeConstraint lengthConstraint;
        ArrayList<String> classNames = new ArrayList<String>();
        Validation validation = this.field.getValidation();
        if (validation != null && validation.isRequired() && !this.search) {
            classNames.add("required");
        }
        sb.append("<textarea rows='5' fieldId='").append(this.field.getId()).append("' fieldName=\"").append(this.field.getInternalName()).append("\" name=\"").append(this.valueName).append('\"');
        RangeConstraint rangeConstraint = lengthConstraint = validation == null ? null : validation.getLengthConstraint();
        if (lengthConstraint != null && lengthConstraint.getMax() != null && lengthConstraint.getMax() > 0) {
            sb.append(" maxLength=\"").append(lengthConstraint.getMax()).append('\"');
            classNames.add("maxLength");
        }
        if (this.enabled) {
            classNames.add("InputBoxEnabled");
        } else {
            classNames.add("InputBoxDisabled");
            sb.append(" readonly");
        }
        String sizeClass = this.getSizeClass();
        if (StringUtils.isNotEmpty((String)sizeClass)) {
            classNames.add(sizeClass);
        }
        sb.append(" class=\"").append(StringUtils.join(classNames.iterator(), (char)' ')).append("\">").append(this.getStringValue()).append("</textarea>");
    }
}

